/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.ARenderEntityDefinable;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.components.RenderableTreadRoller;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;
import org.lwjgl.opengl.GL11;

public class RenderableModelObject<AnimationEntity extends AEntityD_Definable<?>> {
    protected final String modelLocation;
    protected final RenderableObject object;
    private final List<RenderableModelObject<AnimationEntity>> allObjects;
    private final boolean isWindow;
    private final boolean isOnlineTexture;
    private final RenderableObject interiorWindowObject;
    private RenderableObject colorObject;
    private RenderableObject coverObject;
    private final Map<JSONLight, RenderableObject> flareObjects = new HashMap<JSONLight, RenderableObject>();
    private final Map<JSONLight, RenderableObject> beamObjects = new HashMap<JSONLight, RenderableObject>();
    private static final Map<String, Map<Float, List<Double[]>>> treadPoints = new HashMap<String, Map<Float, List<Double[]>>>();
    private static final float COLOR_OFFSET = 1.0E-4f;
    private static final float FLARE_OFFSET = 2.0E-4f;
    private static final float COVER_OFFSET = 3.0E-4f;
    private static final float BEAM_OFFSET = -0.15f;
    private static final int BEAM_SEGMENTS = 40;

    public RenderableModelObject(String modelLocation, RenderableObject object, List<RenderableModelObject<AnimationEntity>> allObjects) {
        this.modelLocation = modelLocation;
        this.allObjects = allObjects;
        this.isWindow = object.name.toLowerCase().contains("window");
        boolean bl = this.isOnlineTexture = object.name.toLowerCase().startsWith("url") || object.name.toLowerCase().endsWith("url");
        if (this.isWindow) {
            this.object = new RenderableObject(object.name, "mts:textures/rendering/glass.png", object.color, object.vertices, false);
            this.object.normalizeUVs();
            this.interiorWindowObject = new RenderableObject(object.name + "_interior", "mts:textures/rendering/glass.png", object.color, FloatBuffer.allocate(object.vertices.capacity()), false);
            float[] vertexSet = new float[8];
            for (int i = object.vertices.capacity() - 8; i >= 0; i -= 8) {
                object.vertices.get(vertexSet);
                this.interiorWindowObject.vertices.position(i);
                this.interiorWindowObject.vertices.put(vertexSet);
            }
            object.vertices.rewind();
            this.interiorWindowObject.vertices.position(0);
            this.interiorWindowObject.vertices.limit(object.vertices.limit());
        } else {
            this.object = object;
            this.interiorWindowObject = null;
        }
        if (object.name.startsWith("&")) {
            this.colorObject = RenderableModelObject.generateColors(object);
            this.coverObject = RenderableModelObject.generateCovers(object);
        }
    }

    public void render(AnimationEntity entity, boolean blendingEnabled, float partialTicks) {
        float lightLevel;
        JSONLight lightDef = ((AEntityD_Definable)entity).lightObjectDefinitions.get(this.object.name);
        float f = lightLevel = lightDef != null ? ((AEntityD_Definable)entity).lightBrightnessValues.get(lightDef).floatValue() : 0.0f;
        if (this.shouldRender(entity, lightDef, blendingEnabled)) {
            GL11.glPushMatrix();
            this.object.scale = ((AEntityD_Definable)entity).scale;
            JSONAnimatedObject definition = ((AEntityD_Definable)entity).animatedObjectDefinitions.get(this.object.name);
            if (RenderableModelObject.doPreRenderTransforms(entity, definition != null ? definition.animations : null, blendingEnabled, partialTicks)) {
                this.object.isMirrored = ((AEntityD_Definable)entity).mirrored;
                if (!this.isWindow) {
                    this.object.texture = ((AEntityD_Definable)entity).getTexture();
                }
                if (this.isOnlineTexture) {
                    for (Map.Entry<JSONText, String> entry : ((AEntityD_Definable)entity).text.entrySet()) {
                        JSONText textDef = entry.getKey();
                        if (!this.object.name.contains(textDef.fieldName)) continue;
                        String textValue = ((AEntityD_Definable)entity).text.get(textDef);
                        if (textValue.isEmpty() || textValue.contains(" ")) break;
                        String errorString = InterfaceRender.downloadURLTexture(textValue);
                        if (errorString != null) {
                            entry.setValue(errorString);
                            break;
                        }
                        this.object.texture = textValue;
                        break;
                    }
                }
                if (lightDef != null) {
                    lightLevel = ((AEntityD_Definable)entity).lightBrightnessValues.get(lightDef).floatValue();
                    if (lightDef.isElectric && entity instanceof EntityVehicleF_Physics) {
                        double electricPower = ((EntityVehicleF_Physics)entity).electricPower;
                        if (electricPower < 3.0) {
                            lightLevel = 0.0f;
                        } else if (electricPower < 10.0) {
                            lightLevel = (float)((double)lightLevel * ((electricPower - 3.0) / 7.0));
                        }
                    }
                }
                if (entity instanceof PartGroundDevice && ((JSONPart)((PartGroundDevice)entity).definition).ground.isTread && !((PartGroundDevice)entity).placementDefinition.isSpare) {
                    if (!blendingEnabled) {
                        this.doTreadRendering((PartGroundDevice)entity, partialTicks);
                    }
                } else {
                    if (blendingEnabled && lightDef != null && lightLevel > 0.0f && lightDef.isBeam && ((AEntityB_Existing)entity).shouldRenderBeams()) {
                        this.object.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value;
                        this.object.enableBrightBlending = (Boolean)ConfigSystem.configObject.clientRendering.blendedLights.value;
                        this.object.alpha = Math.min((1.0f - ((AEntityD_Definable)entity).world.getLightBrightness(((AEntityD_Definable)entity).position, false)) * lightLevel, 1.0f);
                        this.object.render();
                    } else if (!(blendingEnabled ^ this.object.isTranslucent)) {
                        this.object.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value != false && lightDef != null && lightLevel > 0.0f && !lightDef.emissive && !lightDef.isBeam;
                        this.object.render();
                        if (this.interiorWindowObject != null && ((Boolean)ConfigSystem.configObject.clientRendering.innerWindows.value).booleanValue()) {
                            this.interiorWindowObject.isMirrored = this.object.isMirrored;
                            this.interiorWindowObject.scale = this.object.scale;
                            this.interiorWindowObject.render();
                        }
                    }
                    if (lightDef != null && !lightDef.isBeam) {
                        this.doLightRendering(entity, lightDef, lightLevel, ((AEntityD_Definable)entity).lightColorValues.get(lightDef), blendingEnabled);
                    }
                    if (!blendingEnabled) {
                        for (JSONText jSONText : ((AEntityD_Definable)entity).text.keySet()) {
                            if (!this.object.name.equals(jSONText.attachedTo)) continue;
                            RenderText.draw3DText(((AEntityD_Definable)entity).text.get(jSONText), entity, jSONText, ((AEntityD_Definable)entity).scale, false);
                        }
                    }
                }
                for (RenderableModelObject renderableModelObject : this.allObjects) {
                    JSONAnimatedObject animation = ((AEntityD_Definable)entity).animatedObjectDefinitions.get(renderableModelObject.object.name);
                    if (animation == null || !this.object.name.equals(animation.applyAfter)) continue;
                    renderableModelObject.render(entity, blendingEnabled, partialTicks);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public static boolean doPreRenderTransforms(AEntityD_Definable<?> entity, List<JSONAnimationDefinition> animations, boolean blendingEnabled, float partialTicks) {
        if (animations != null) {
            double variableValue = 0.0;
            double priorOffset = 0.0;
            boolean inhibitAnimations = false;
            for (JSONAnimationDefinition animation : animations) {
                priorOffset = animation.addPriorOffset ? variableValue : 0.0;
                variableValue = 0.0;
                DurationDelayClock clock = entity.animationClocks.get(animation);
                switch (animation.animationType) {
                    case VISIBILITY: {
                        if (inhibitAnimations || !((variableValue = entity.getAnimatedVariableValue(clock, partialTicks)) < (double)animation.clampMin) && !(variableValue > (double)animation.clampMax)) break;
                        return false;
                    }
                    case INHIBITOR: {
                        if (inhibitAnimations || !((variableValue = entity.getAnimatedVariableValue(clock, partialTicks)) >= (double)animation.clampMin) || !(variableValue <= (double)animation.clampMax)) break;
                        inhibitAnimations = true;
                        break;
                    }
                    case ACTIVATOR: {
                        if (!inhibitAnimations || !((variableValue = entity.getAnimatedVariableValue(clock, partialTicks)) >= (double)animation.clampMin) || !(variableValue <= (double)animation.clampMax)) break;
                        inhibitAnimations = false;
                        break;
                    }
                    case TRANSLATION: {
                        if (inhibitAnimations) break;
                        variableValue = entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, priorOffset, partialTicks);
                        if (animation.addPriorOffset) {
                            GL11.glTranslated((double)((variableValue - priorOffset) * animation.axis.x / clock.animationAxisMagnitude), (double)((variableValue - priorOffset) * animation.axis.y / clock.animationAxisMagnitude), (double)((variableValue - priorOffset) * animation.axis.z / clock.animationAxisMagnitude));
                            break;
                        }
                        if (variableValue == 0.0) break;
                        GL11.glTranslated((double)(variableValue * animation.axis.x / clock.animationAxisMagnitude), (double)(variableValue * animation.axis.y / clock.animationAxisMagnitude), (double)(variableValue * animation.axis.z / clock.animationAxisMagnitude));
                        break;
                    }
                    case ROTATION: {
                        if (inhibitAnimations) break;
                        variableValue = entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, priorOffset, partialTicks);
                        if (animation.addPriorOffset) {
                            GL11.glTranslated((double)animation.centerPoint.x, (double)animation.centerPoint.y, (double)animation.centerPoint.z);
                            GL11.glRotated((double)(variableValue - priorOffset), (double)(animation.axis.x / clock.animationAxisMagnitude), (double)(animation.axis.y / clock.animationAxisMagnitude), (double)(animation.axis.z / clock.animationAxisMagnitude));
                            GL11.glTranslated((double)(-animation.centerPoint.x), (double)(-animation.centerPoint.y), (double)(-animation.centerPoint.z));
                            break;
                        }
                        if (variableValue == 0.0) break;
                        GL11.glTranslated((double)animation.centerPoint.x, (double)animation.centerPoint.y, (double)animation.centerPoint.z);
                        GL11.glRotated((double)variableValue, (double)(animation.axis.x / clock.animationAxisMagnitude), (double)(animation.axis.y / clock.animationAxisMagnitude), (double)(animation.axis.z / clock.animationAxisMagnitude));
                        GL11.glTranslated((double)(-animation.centerPoint.x), (double)(-animation.centerPoint.y), (double)(-animation.centerPoint.z));
                        break;
                    }
                    case SCALING: {
                        if (inhibitAnimations) break;
                        variableValue = entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, priorOffset, partialTicks);
                        GL11.glTranslated((double)animation.centerPoint.x, (double)animation.centerPoint.y, (double)animation.centerPoint.z);
                        GL11.glScaled((double)(animation.axis.x == 0.0 ? 1.0 : variableValue * animation.axis.x / clock.animationAxisMagnitude), (double)(animation.axis.y == 0.0 ? 1.0 : variableValue * animation.axis.y / clock.animationAxisMagnitude), (double)(animation.axis.z == 0.0 ? 1.0 : variableValue * animation.axis.z / clock.animationAxisMagnitude));
                        GL11.glTranslated((double)(-animation.centerPoint.x), (double)(-animation.centerPoint.y), (double)(-animation.centerPoint.z));
                    }
                }
            }
        }
        return true;
    }

    public void destroy() {
        this.object.destroy();
        treadPoints.remove(this.modelLocation);
    }

    private boolean shouldRender(AnimationEntity entity, JSONLight lightDef, boolean blendingEnabled) {
        if (this.object.isTranslucent && !blendingEnabled) {
            return false;
        }
        if (this.isWindow && !((Boolean)ConfigSystem.configObject.clientRendering.renderWindows.value).booleanValue()) {
            return false;
        }
        if (this.isOnlineTexture) {
            for (JSONText textDef : ((AEntityD_Definable)entity).text.keySet()) {
                if (!this.object.name.contains(textDef.fieldName)) continue;
                if (!((AEntityD_Definable)entity).text.get(textDef).isEmpty()) break;
                return false;
            }
        }
        return lightDef == null || !blendingEnabled || this.object.isTranslucent || lightDef.emissive || lightDef.isBeam || lightDef.blendableComponents != null && !lightDef.blendableComponents.isEmpty();
    }

    private void doTreadRendering(PartGroundDevice tread, float partialTicks) {
        List<Double[]> points;
        AEntityE_Interactable entityTreadAttachedTo = tread.placementDefinition.isSubPart ? tread.parentPart : tread.entityOn;
        String treadPathModel = ((AJSONMultiModelProvider)entityTreadAttachedTo.definition).getModelLocation(entityTreadAttachedTo.subName);
        Map<Float, List<Double[]>> treadPointsMap = treadPoints.get(treadPathModel);
        if (treadPointsMap == null) {
            treadPointsMap = new HashMap<Float, List<Double[]>>();
        }
        if ((points = treadPointsMap.get(Float.valueOf(((JSONPart)tread.definition).ground.spacing))) == null) {
            points = RenderableModelObject.generateTreads(entityTreadAttachedTo, treadPathModel, treadPointsMap, tread);
            treadPointsMap.put(Float.valueOf(((JSONPart)tread.definition).ground.spacing), points);
            treadPoints.put(treadPathModel, treadPointsMap);
        }
        float treadLinearPosition = (float)((Math.abs(tread.angularPosition) + tread.angularVelocity * (double)partialTicks) * EntityVehicleF_Physics.SPEED_FACTOR);
        float treadMovementPercentage = treadLinearPosition % ((JSONPart)tread.definition).ground.spacing / ((JSONPart)tread.definition).ground.spacing;
        if (tread.angularPosition < 0.0) {
            treadMovementPercentage = 1.0f - treadMovementPercentage;
        }
        if (!(entityTreadAttachedTo instanceof APart)) {
            GL11.glTranslated((double)0.0, (double)(-tread.localOffset.y), (double)(-tread.localOffset.z));
        }
        for (int i = 0; i < points.size() - 1; ++i) {
            Double[] point = points.get(i);
            Double[] nextPoint = i == points.size() - 1 ? points.get(0) : points.get(i + 1);
            double yDelta = nextPoint[0] - point[0];
            double zDelta = nextPoint[1] - point[1];
            double angleDelta = nextPoint[2] - point[2];
            if (i == 0) {
                GL11.glTranslated((double)0.0, (double)point[0], (double)point[1]);
            }
            if (angleDelta > 180.0) {
                angleDelta -= 360.0;
            } else if (angleDelta < -180.0) {
                angleDelta += 360.0;
            }
            if (point[2] != 0.0 || angleDelta != 0.0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)(yDelta * (double)treadMovementPercentage), (double)(zDelta * (double)treadMovementPercentage));
                GL11.glRotated((double)(point[2] + angleDelta * (double)treadMovementPercentage), (double)1.0, (double)0.0, (double)0.0);
                this.object.render();
                GL11.glPopMatrix();
                GL11.glTranslated((double)0.0, (double)yDelta, (double)zDelta);
                continue;
            }
            GL11.glTranslated((double)0.0, (double)(yDelta * (double)treadMovementPercentage), (double)(zDelta * (double)treadMovementPercentage));
            this.object.render();
            GL11.glTranslated((double)0.0, (double)(yDelta * (double)(1.0f - treadMovementPercentage)), (double)(zDelta * (double)(1.0f - treadMovementPercentage)));
        }
    }

    private void doLightRendering(AnimationEntity entity, JSONLight lightDef, float lightLevel, ColorRGB color, boolean blendingEnabled) {
        float blendableBrightness;
        if (blendingEnabled && lightLevel > 0.0f && lightDef.emissive) {
            if (this.colorObject == null) {
                for (RenderableObject testObject : AModelParser.parseModel(this.modelLocation)) {
                    if (!this.object.name.equals(testObject.name)) continue;
                    this.colorObject = RenderableModelObject.generateColors(testObject);
                    break;
                }
            }
            this.colorObject.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value;
            this.colorObject.color.setTo(color);
            this.colorObject.alpha = lightLevel;
            this.colorObject.isMirrored = this.object.isMirrored;
            this.colorObject.scale = this.object.scale;
            this.colorObject.render();
        }
        if (blendingEnabled && lightLevel > 0.0f && lightDef.blendableComponents != null && !lightDef.blendableComponents.isEmpty() && (blendableBrightness = Math.min((1.0f - ((AEntityD_Definable)entity).world.getLightBrightness(((AEntityD_Definable)entity).position, false)) * lightLevel, 1.0f)) > 0.0f) {
            RenderableObject flareObject = this.flareObjects.get(lightDef);
            RenderableObject beamObject = this.beamObjects.get(lightDef);
            if (flareObject == null && beamObject == null) {
                ArrayList<JSONLight.JSONLightBlendableComponent> flareDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                ArrayList<JSONLight.JSONLightBlendableComponent> beamDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                for (JSONLight.JSONLightBlendableComponent component : lightDef.blendableComponents) {
                    if (component.flareHeight > 0.0f) {
                        flareDefs.add(component);
                    }
                    if (!(component.beamDiameter > 0.0f)) continue;
                    beamDefs.add(component);
                }
                if (!flareDefs.isEmpty()) {
                    flareObject = RenderableModelObject.generateFlares(flareDefs);
                    this.flareObjects.put(lightDef, flareObject);
                }
                if (!beamDefs.isEmpty()) {
                    beamObject = RenderableModelObject.generateBeams(beamDefs);
                    this.beamObjects.put(lightDef, beamObject);
                }
            }
            if (flareObject != null) {
                flareObject.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value;
                flareObject.color.setTo(color);
                flareObject.alpha = blendableBrightness;
                flareObject.isMirrored = this.object.isMirrored;
                flareObject.scale = this.object.scale;
                flareObject.render();
            }
            if (beamObject != null && ((AEntityB_Existing)entity).shouldRenderBeams()) {
                beamObject.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value;
                beamObject.enableBrightBlending = (Boolean)ConfigSystem.configObject.clientRendering.blendedLights.value;
                beamObject.color.setTo(color);
                beamObject.alpha = blendableBrightness;
                beamObject.isMirrored = this.object.isMirrored;
                beamObject.scale = this.object.scale;
                beamObject.render();
            }
        }
        if (!blendingEnabled && lightDef.covered) {
            if (this.coverObject == null) {
                for (RenderableObject testObject : AModelParser.parseModel(this.modelLocation)) {
                    if (!this.object.name.equals(testObject.name)) continue;
                    this.coverObject = RenderableModelObject.generateCovers(testObject);
                    break;
                }
            }
            this.coverObject.disableLighting = (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value != false && lightLevel > 0.0f;
            this.coverObject.isMirrored = this.object.isMirrored;
            this.coverObject.scale = this.object.scale;
            this.coverObject.render();
        }
    }

    private static RenderableObject generateColors(RenderableObject parsedObject) {
        RenderableObject offsetObject = new RenderableObject("color", "mts:textures/rendering/light.png", new ColorRGB(), FloatBuffer.allocate(parsedObject.vertices.capacity()), false);
        float[] vertexData = new float[8];
        while (parsedObject.vertices.hasRemaining()) {
            parsedObject.vertices.get(vertexData);
            offsetObject.vertices.put(vertexData, 0, 5);
            offsetObject.vertices.put(vertexData[5] + vertexData[0] * 1.0E-4f);
            offsetObject.vertices.put(vertexData[6] + vertexData[1] * 1.0E-4f);
            offsetObject.vertices.put(vertexData[7] + vertexData[2] * 1.0E-4f);
        }
        parsedObject.vertices.rewind();
        offsetObject.normalizeUVs();
        offsetObject.vertices.flip();
        return offsetObject;
    }

    private static RenderableObject generateCovers(RenderableObject parsedObject) {
        RenderableObject offsetObject = new RenderableObject("cover", "mts:textures/rendering/glass.png", parsedObject.color, FloatBuffer.allocate(parsedObject.vertices.capacity()), false);
        float[] vertexData = new float[8];
        while (parsedObject.vertices.hasRemaining()) {
            parsedObject.vertices.get(vertexData);
            offsetObject.vertices.put(vertexData, 0, 5);
            offsetObject.vertices.put(vertexData[5] + vertexData[0] * 3.0E-4f);
            offsetObject.vertices.put(vertexData[6] + vertexData[1] * 3.0E-4f);
            offsetObject.vertices.put(vertexData[7] + vertexData[2] * 3.0E-4f);
        }
        parsedObject.vertices.rewind();
        offsetObject.normalizeUVs();
        offsetObject.vertices.flip();
        return offsetObject;
    }

    private static RenderableObject generateFlares(List<JSONLight.JSONLightBlendableComponent> flareDefs) {
        RenderableObject flareObject = new RenderableObject("flares", "mts:textures/rendering/lensflare.png", new ColorRGB(), FloatBuffer.allocate(flareDefs.size() * 6 * 8), false);
        for (int i = 0; i < flareDefs.size(); ++i) {
            JSONLight.JSONLightBlendableComponent flareDef = flareDefs.get(i);
            Point3d rotation = flareDef.axis.copy().getAngles(false);
            Point3d vertexOffset = new Point3d();
            Point3d centerOffset = flareDef.axis.copy().multiply(2.0E-4f).add(flareDef.pos);
            for (int j = 0; j < 6; ++j) {
                float[] newVertex = new float[8];
                switch (j) {
                    case 0: {
                        newVertex[3] = 0.0f;
                        newVertex[4] = 0.0f;
                        break;
                    }
                    case 1: {
                        newVertex[3] = 0.0f;
                        newVertex[4] = 1.0f;
                        break;
                    }
                    case 2: {
                        newVertex[3] = 1.0f;
                        newVertex[4] = 1.0f;
                        break;
                    }
                    case 3: {
                        newVertex[3] = 0.0f;
                        newVertex[4] = 0.0f;
                        break;
                    }
                    case 4: {
                        newVertex[3] = 1.0f;
                        newVertex[4] = 1.0f;
                        break;
                    }
                    case 5: {
                        newVertex[3] = 1.0f;
                        newVertex[4] = 0.0f;
                    }
                }
                vertexOffset.x = (double)newVertex[3] == 0.0 ? (double)(-flareDef.flareWidth) / 2.0 : (double)flareDef.flareWidth / 2.0;
                vertexOffset.y = (double)newVertex[4] == 0.0 ? (double)flareDef.flareHeight / 2.0 : (double)(-flareDef.flareHeight) / 2.0;
                vertexOffset.z = 0.0;
                vertexOffset.rotateFine(rotation).add(centerOffset);
                newVertex[5] = (float)vertexOffset.x;
                newVertex[6] = (float)vertexOffset.y;
                newVertex[7] = (float)vertexOffset.z;
                newVertex[0] = (float)flareDef.axis.x;
                newVertex[1] = (float)flareDef.axis.y;
                newVertex[2] = (float)flareDef.axis.z;
                flareObject.vertices.put(newVertex);
            }
        }
        flareObject.vertices.flip();
        return flareObject;
    }

    private static RenderableObject generateBeams(List<JSONLight.JSONLightBlendableComponent> beamDefs) {
        RenderableObject beamObject = new RenderableObject("beams", "mts:textures/rendering/lightbeam.png", new ColorRGB(), FloatBuffer.allocate(beamDefs.size() * 2 * 40 * 3 * 8), false);
        for (int i = 0; i < beamDefs.size(); ++i) {
            JSONLight.JSONLightBlendableComponent beamDef = beamDefs.get(i);
            Point3d rotation = beamDef.axis.copy().getAngles(false);
            Point3d vertexOffset = new Point3d();
            Point3d centerOffset = beamDef.axis.copy().multiply(-0.15f).add(beamDef.pos);
            for (int j = -40; j < 40; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double currentAngleRad;
                    float[] newVertex = new float[8];
                    switch (k % 3) {
                        case 0: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 0.0f;
                            break;
                        }
                        case 1: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 1.0f;
                            break;
                        }
                        case 2: {
                            newVertex[3] = 1.0f;
                            newVertex[4] = 1.0f;
                        }
                    }
                    if (j < 0) {
                        currentAngleRad = newVertex[3] == 0.0f ? Math.PI * 2 * ((double)(j + 1) / 40.0) : Math.PI * 2 * ((double)j / 40.0);
                    } else {
                        double d = currentAngleRad = newVertex[3] == 0.0f ? Math.PI * 2 * ((double)j / 40.0) : Math.PI * 2 * ((double)(j + 1) / 40.0);
                    }
                    if ((double)newVertex[4] == 0.0) {
                        vertexOffset.set(0.0, 0.0, 0.0);
                    } else {
                        vertexOffset.x = (double)(beamDef.beamDiameter / 2.0f) * Math.cos(currentAngleRad);
                        vertexOffset.y = (double)(beamDef.beamDiameter / 2.0f) * Math.sin(currentAngleRad);
                        vertexOffset.z = beamDef.beamLength;
                    }
                    vertexOffset.rotateFine(rotation).add(centerOffset);
                    newVertex[5] = (float)vertexOffset.x;
                    newVertex[6] = (float)vertexOffset.y;
                    newVertex[7] = (float)vertexOffset.z;
                    newVertex[0] = 0.0f;
                    newVertex[1] = 0.0f;
                    newVertex[2] = 0.0f;
                    beamObject.vertices.put(newVertex);
                }
            }
        }
        beamObject.vertices.flip();
        return beamObject;
    }

    private static <TreadEntity extends AEntityD_Definable<?>> List<Double[]> generateTreads(TreadEntity entityTreadAttachedTo, String treadPathModel, Map<Float, List<Double[]>> treadPointsMap, PartGroundDevice tread) {
        int i;
        HashMap<Integer, RenderableTreadRoller> parsedRollers = new HashMap<Integer, RenderableTreadRoller>();
        for (RenderableModelObject modelObject : ((ARenderEntityDefinable)entityTreadAttachedTo.getRenderer()).objectLists.get(treadPathModel)) {
            if (!(modelObject instanceof RenderableTreadRoller)) continue;
            RenderableTreadRoller treadObject = (RenderableTreadRoller)modelObject;
            if (treadObject.isLeft) continue;
            parsedRollers.put(treadObject.rollerNumber, treadObject);
        }
        ArrayList rollers = new ArrayList();
        for (i = 0; i < parsedRollers.size(); ++i) {
            if (!parsedRollers.containsKey(i)) {
                throw new IndexOutOfBoundsException("Attempted to render roller_" + i + " on " + ((AJSONMultiModelProvider)entityTreadAttachedTo.definition).packID + ":" + ((AJSONMultiModelProvider)entityTreadAttachedTo.definition).systemName + ", but it was not found.  Did you not make it in the OBJ model?");
            }
            if (i < parsedRollers.size() - 1) {
                ((RenderableTreadRoller)parsedRollers.get(i)).calculateEndpoints((RenderableTreadRoller)parsedRollers.get(i + 1));
            } else {
                ((RenderableTreadRoller)parsedRollers.get(i)).calculateEndpoints((RenderableTreadRoller)parsedRollers.get(0));
            }
            rollers.add(parsedRollers.get(i));
        }
        ((RenderableTreadRoller)rollers.get((int)0)).endAngle = 180.0;
        for (i = 1; i < rollers.size(); ++i) {
            RenderableTreadRoller roller = (RenderableTreadRoller)rollers.get(i);
            roller.startAngle = ((RenderableTreadRoller)rollers.get((int)(i - 1))).endAngle;
            while (roller.endAngle < roller.startAngle - 30.0) {
                roller.endAngle += 360.0;
            }
            while (roller.endAngle > roller.startAngle + 360.0) {
                roller.endAngle += 360.0;
            }
        }
        while (((RenderableTreadRoller)rollers.get((int)0)).startAngle < 0.0) {
            ((RenderableTreadRoller)rollers.get((int)0)).startAngle += 360.0;
        }
        if (((RenderableTreadRoller)rollers.get((int)0)).startAngle > 180.0) {
            ((RenderableTreadRoller)rollers.get((int)0)).startAngle -= 360.0;
        }
        ((RenderableTreadRoller)rollers.get((int)0)).startAngle += 360.0;
        ((RenderableTreadRoller)rollers.get((int)(rollers.size() - 1))).endAngle = ((RenderableTreadRoller)rollers.get((int)0)).startAngle;
        double totalPathLength = 0.0;
        for (int i2 = 0; i2 < rollers.size(); ++i2) {
            RenderableTreadRoller roller = (RenderableTreadRoller)rollers.get(i2);
            totalPathLength += Math.PI * 2 * roller.radius * Math.abs(roller.endAngle - (i2 == 0 ? roller.startAngle - 360.0 : roller.startAngle)) / 360.0;
            RenderableTreadRoller nextRoller = i2 == rollers.size() - 1 ? (RenderableTreadRoller)rollers.get(0) : (RenderableTreadRoller)rollers.get(i2 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                totalPathLength += 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                continue;
            }
            totalPathLength += straightPathLength;
        }
        double deltaDist = (double)((JSONPart)tread.definition).ground.spacing + totalPathLength % (double)((JSONPart)tread.definition).ground.spacing / (totalPathLength / (double)((JSONPart)tread.definition).ground.spacing);
        double leftoverPathLength = 0.0;
        double yPoint = 0.0;
        double zPoint = 0.0;
        ArrayList<Double[]> points = new ArrayList<Double[]>();
        for (int i3 = 0; i3 < rollers.size(); ++i3) {
            RenderableTreadRoller roller = (RenderableTreadRoller)rollers.get(i3);
            double rollerPathLength = Math.PI * 2 * roller.radius * Math.abs(roller.endAngle - (i3 == 0 ? roller.startAngle - 360.0 : roller.startAngle)) / 360.0;
            double currentAngle = roller.startAngle;
            if (i3 == 0) {
                yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle));
                zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
            }
            if (deltaDist - leftoverPathLength < rollerPathLength) {
                if (leftoverPathLength > 0.0) {
                    Double[] lastPoint = (Double[])points.get(points.size() - 1);
                    yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle));
                    zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                    double pointDist = Math.hypot(yPoint - lastPoint[0], zPoint - lastPoint[1]);
                    double normalizedY = (yPoint - lastPoint[0]) / pointDist;
                    double normalizedZ = (zPoint - lastPoint[1]) / pointDist;
                    double rollerAngleSpan = 360.0 * ((deltaDist - leftoverPathLength) / roller.circumference);
                    points.add(new Double[]{lastPoint[0] + deltaDist * normalizedY, lastPoint[1] + deltaDist * normalizedZ, lastPoint[2] + rollerAngleSpan});
                    currentAngle += rollerAngleSpan;
                    rollerPathLength -= deltaDist - leftoverPathLength;
                    leftoverPathLength = 0.0;
                }
                while (rollerPathLength > deltaDist) {
                    rollerPathLength -= deltaDist;
                    yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle += 360.0 * (deltaDist / roller.circumference)));
                    zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
                }
                currentAngle = roller.endAngle;
            }
            RenderableTreadRoller nextRoller = i3 == rollers.size() - 1 ? (RenderableTreadRoller)rollers.get(0) : (RenderableTreadRoller)rollers.get(i3 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            double extraPathLength = rollerPathLength + leftoverPathLength;
            double normalizedY = (nextRoller.startY - roller.endY) / straightPathLength;
            double normalizedZ = (nextRoller.startZ - roller.endZ) / straightPathLength;
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                double hyperbolicPathLength = 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double hyperbolicFunctionStep = deltaDist * straightPathLength / hyperbolicPathLength;
                double hyperbolicPathMaxY = (double)tread.placementDefinition.treadDroopConstant * Math.cosh(-straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double hyperbolicFunctionCurrent = 0.0;
                while (straightPathLength + extraPathLength - hyperbolicFunctionCurrent > hyperbolicFunctionStep) {
                    if (extraPathLength > 0.0) {
                        hyperbolicFunctionCurrent += extraPathLength * hyperbolicFunctionStep;
                        extraPathLength = 0.0;
                    } else {
                        hyperbolicFunctionCurrent += hyperbolicFunctionStep;
                    }
                    yPoint = roller.endY + normalizedY * hyperbolicFunctionCurrent + (double)tread.placementDefinition.treadDroopConstant * Math.cosh((hyperbolicFunctionCurrent - straightPathLength / 2.0) / (double)tread.placementDefinition.treadDroopConstant) - hyperbolicPathMaxY;
                    zPoint = roller.endZ + normalizedZ * hyperbolicFunctionCurrent;
                    points.add(new Double[]{yPoint, zPoint, roller.endAngle + 180.0 - Math.toDegrees(Math.asin((hyperbolicFunctionCurrent - straightPathLength / 2.0) / (double)tread.placementDefinition.treadDroopConstant))});
                }
                leftoverPathLength = (straightPathLength - hyperbolicFunctionCurrent) / (straightPathLength / hyperbolicPathLength);
                continue;
            }
            while (straightPathLength + extraPathLength > deltaDist) {
                if (extraPathLength > 0.0) {
                    yPoint = roller.endY + normalizedY * (deltaDist - extraPathLength);
                    zPoint = roller.endZ + normalizedZ * (deltaDist - extraPathLength);
                    straightPathLength -= deltaDist - extraPathLength;
                    extraPathLength = 0.0;
                } else {
                    yPoint += normalizedY * deltaDist;
                    zPoint += normalizedZ * deltaDist;
                    straightPathLength -= deltaDist;
                }
                points.add(new Double[]{yPoint, zPoint, roller.endAngle + 180.0});
            }
            leftoverPathLength = straightPathLength;
        }
        return points;
    }
}

