/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.mcinterface.InterfaceRender;

public class RenderableObject {
    public final String name;
    public String texture;
    public final ColorRGB color;
    public FloatBuffer vertices;
    public final boolean cacheVertices;
    public boolean isTranslucent;
    public boolean isMirrored;
    public int cachedVertexIndex = -1;
    public BlendState blend = BlendState.SOLID;
    public float alpha = 1.0f;
    public float lineWidth = 0.0f;
    public float scale = 1.0f;
    public boolean disableLighting;
    public boolean ignoreWorldShading;
    public boolean enableBrightBlending;
    public static final String GLOBAL_TEXTURE_NAME = "GLOBAL";
    public static final String PARTICLE_TEXTURE_NAME = "PARTICLE";
    private static final int[][] FACE_POINT_INDEXES = new int[][]{{0, 1, 3, 2}, {5, 4, 6, 7}, {6, 2, 3, 7}, {5, 1, 0, 4}, {4, 0, 2, 6}, {1, 5, 7, 3}};
    private static final float[][] FACE_NORMALS = new float[][]{{-1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}};
    private static final int[][] WIREFRAME_POINT_INDEXES = new int[][]{{0, 1}, {4, 5}, {0, 4}, {1, 5}, {2, 3}, {6, 7}, {2, 6}, {3, 7}, {0, 2}, {1, 3}, {4, 6}, {5, 7}};
    private static final int BUFFERS_PER_LINE = 6;
    private static final int BUFFERS_PER_VERTEX = 8;
    private static final int BUFFERS_PER_FACE = 24;
    private static final int BUFFERS_PER_HOLGRAPHIC_BOX = 288;
    private static final int BUFFERS_PER_WIREFRAME_BOX = 72;

    public RenderableObject(String name, String texture, ColorRGB color, FloatBuffer vertices, boolean cacheVertices) {
        this.name = name;
        this.texture = texture;
        this.color = color;
        this.cacheVertices = cacheVertices;
        this.isTranslucent = name.toLowerCase().contains("translucent");
        this.vertices = vertices;
    }

    public RenderableObject(ColorRGB color, int numberLines) {
        this("", null, color, FloatBuffer.allocate(numberLines * 6), false);
        this.lineWidth = 2.0f;
        this.disableLighting = true;
    }

    public RenderableObject(BoundingBox box, ColorRGB color, boolean holgraphic) {
        this("", holgraphic ? "mts:textures/rendering/holobox.png" : null, color, FloatBuffer.allocate(holgraphic ? 288 : 72), false);
        if (holgraphic) {
            this.isTranslucent = true;
            this.alpha = 0.5f;
            this.setHolographicBoundingBox(box);
        } else {
            this.lineWidth = 2.0f;
            this.setWireframeBoundingBox(box);
        }
        this.disableLighting = true;
    }

    public boolean equals(Object object) {
        if (object instanceof RenderableObject) {
            RenderableObject otherProperties = (RenderableObject)object;
            return this.texture.equals(otherProperties.texture) && this.color.equals(otherProperties.color);
        }
        return false;
    }

    public void render() {
        InterfaceRender.renderVertices(this);
    }

    public void addLine(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.vertices.put(x1);
        this.vertices.put(y1);
        this.vertices.put(z1);
        this.vertices.put(x2);
        this.vertices.put(y2);
        this.vertices.put(z2);
    }

    public void setHolographicBoundingBox(BoundingBox box) {
        float[][] points = box.getEdgePoints();
        for (int i = 0; i < 6; ++i) {
            block6: for (int j = 0; j < 6; ++j) {
                this.vertices.put(FACE_NORMALS[i]);
                this.vertices.put(0.0f);
                this.vertices.put(0.0f);
                switch (j) {
                    case 3: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][0]]);
                        continue block6;
                    }
                    case 4: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][2]]);
                        continue block6;
                    }
                    case 5: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][3]]);
                        continue block6;
                    }
                    default: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][j]]);
                    }
                }
            }
        }
        this.normalizeUVs();
        this.vertices.flip();
    }

    public void setWireframeBoundingBox(BoundingBox box) {
        float[][] points = box.getEdgePoints();
        for (int[] indexes : WIREFRAME_POINT_INDEXES) {
            this.vertices.put(points[indexes[0]]);
            this.vertices.put(points[indexes[1]]);
        }
        this.vertices.flip();
    }

    public void normalizeUVs() {
        int verticesInObject = this.vertices.capacity() / 8;
        block13: for (int i = 0; i < verticesInObject; ++i) {
            if (verticesInObject > 3 && i % 6 >= 3) {
                switch (i % 6) {
                    case 3: {
                        this.vertices.put(i * 8 + 3, 0.0f);
                        this.vertices.put(i * 8 + 4, 0.0f);
                        break;
                    }
                    case 4: {
                        this.vertices.put(i * 8 + 3, 1.0f);
                        this.vertices.put(i * 8 + 4, 1.0f);
                        break;
                    }
                    case 5: {
                        this.vertices.put(i * 8 + 3, 1.0f);
                        this.vertices.put(i * 8 + 4, 0.0f);
                    }
                }
                continue;
            }
            switch (i % 6) {
                case 0: {
                    this.vertices.put(i * 8 + 3, 0.0f);
                    this.vertices.put(i * 8 + 4, 0.0f);
                    continue block13;
                }
                case 1: {
                    this.vertices.put(i * 8 + 3, 0.0f);
                    this.vertices.put(i * 8 + 4, 1.0f);
                    continue block13;
                }
                case 2: {
                    this.vertices.put(i * 8 + 3, 1.0f);
                    this.vertices.put(i * 8 + 4, 1.0f);
                    continue block13;
                }
                case 3: {
                    this.vertices.put(i * 8 + 3, 1.0f);
                    this.vertices.put(i * 8 + 4, 1.0f);
                    continue block13;
                }
                case 4: {
                    this.vertices.put(i * 8 + 3, 1.0f);
                    this.vertices.put(i * 8 + 4, 0.0f);
                    continue block13;
                }
                case 5: {
                    this.vertices.put(i * 8 + 3, 0.0f);
                    this.vertices.put(i * 8 + 4, 0.0f);
                }
            }
        }
    }

    public void destroy() {
        this.vertices = null;
        InterfaceRender.deleteVertices(this);
    }

    public static enum BlendState {
        SOLID,
        TRANSLUCENT,
        BRIGHT_BLENDED;

    }
}

