/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.rendering.components.RenderableModelObject;
import minecrafttransportsimulator.rendering.components.RenderableObject;

public class RenderableTreadRoller<AnimationEntity extends AEntityD_Definable<?>>
extends RenderableModelObject<AnimationEntity> {
    public final boolean isLeft;
    public final int rollerNumber;
    public final Point3d centerPoint;
    public final double radius;
    public final double circumference;
    public double startY;
    public double startZ;
    public double startAngle;
    public double endY;
    public double endZ;
    public double endAngle;

    public RenderableTreadRoller(String modelLocation, RenderableObject object, List<RenderableModelObject<AnimationEntity>> allObjects) {
        super(modelLocation, object, allObjects);
        this.isLeft = object.name.toLowerCase().startsWith("l");
        this.rollerNumber = Integer.valueOf(object.name.substring(object.name.lastIndexOf(95) + 1));
        float minY = 999.0f;
        float maxY = -999.0f;
        float minZ = 999.0f;
        float maxZ = -999.0f;
        for (int i = 0; i < object.vertices.capacity(); i += 8) {
            float y = object.vertices.get(i + 6);
            float z = object.vertices.get(i + 7);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
            minZ = Math.min(minZ, z);
            maxZ = Math.max(maxZ, z);
        }
        this.centerPoint = new Point3d(0.0, (double)minY + (double)(maxY - minY) / 2.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
        this.radius = (double)(maxZ - minZ) / 2.0;
        this.circumference = Math.PI * 2 * this.radius;
    }

    public void calculateEndpoints(RenderableTreadRoller<AnimationEntity> nextRoller) {
        if (this.radius == nextRoller.radius) {
            nextRoller.startAngle = this.endAngle = Math.toDegrees(Math.atan2(nextRoller.centerPoint.z - this.centerPoint.z, nextRoller.centerPoint.y - this.centerPoint.y)) - 90.0;
            this.endY = this.centerPoint.y + this.radius * Math.cos(Math.toRadians(this.endAngle));
            this.endZ = this.centerPoint.z + this.radius * Math.sin(Math.toRadians(this.endAngle));
            nextRoller.startY = nextRoller.centerPoint.y + nextRoller.radius * Math.cos(Math.toRadians(this.endAngle));
            nextRoller.startZ = nextRoller.centerPoint.z + nextRoller.radius * Math.sin(Math.toRadians(this.endAngle));
        } else {
            double centerDistance = Math.hypot(nextRoller.centerPoint.z - this.centerPoint.z, nextRoller.centerPoint.y - this.centerPoint.y);
            boolean nextRollerLarger = this.radius < nextRoller.radius;
            double r1CenterY = nextRollerLarger ? this.centerPoint.y : nextRoller.centerPoint.y;
            double r1CenterZ = nextRollerLarger ? this.centerPoint.z : nextRoller.centerPoint.z;
            double r2CenterY = !nextRollerLarger ? this.centerPoint.y : nextRoller.centerPoint.y;
            double r2CenterZ = !nextRollerLarger ? this.centerPoint.z : nextRoller.centerPoint.z;
            double r1Radius = nextRollerLarger ? this.radius : nextRoller.radius;
            double r2Radius = !nextRollerLarger ? this.radius : nextRoller.radius;
            double centerVectorAngle = Math.atan2(r2CenterZ - r1CenterZ, r2CenterY - r1CenterY);
            double inscribedVectorAngle = Math.asin((r2Radius - r1Radius) / centerDistance);
            double netAngle = centerVectorAngle + (nextRollerLarger ? -inscribedVectorAngle - 1.5707963267948966 : inscribedVectorAngle + 1.5707963267948966);
            nextRoller.startAngle = this.endAngle = Math.toDegrees(netAngle);
            this.endY = this.centerPoint.y + this.radius * Math.cos(Math.toRadians(this.endAngle));
            this.endZ = this.centerPoint.z + this.radius * Math.sin(Math.toRadians(this.endAngle));
            nextRoller.startY = nextRoller.centerPoint.y + nextRoller.radius * Math.cos(Math.toRadians(this.endAngle));
            nextRoller.startZ = nextRoller.centerPoint.z + nextRoller.radius * Math.sin(Math.toRadians(this.endAngle));
        }
    }
}

