/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.mcinterface.InterfaceEventsModelLoader;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.RenderableObject;

public final class ModelParserLT
extends AModelParser {
    @Override
    protected String getModelSuffix() {
        return "txt";
    }

    @Override
    protected List<RenderableObject> parseModelInternal(String modelLocation) {
        InputStreamReader reader;
        ArrayList<RenderableObject> objectList = new ArrayList<RenderableObject>();
        try {
            reader = new InputStreamReader(ModelParserLT.class.getResourceAsStream(modelLocation));
        }
        catch (Exception e) {
            throw new NullPointerException("Attempted to parse the Little Tiles model at: " + modelLocation + " but could not find it.  Check the path and try again.");
        }
        try {
            LTMainModel model = JSONParser.parseStream(reader, LTMainModel.class, null, null);
            reader.close();
            float scale = 1.0f / (float)model.grid;
            for (LTTileEntry tile : model.tiles) {
                if (tile.bBox != null) {
                    tile.boxes = new ArrayList<LTBox>();
                    tile.boxes.add(tile.bBox);
                }
                FloatBuffer buffer = FloatBuffer.allocate(tile.boxes.size() * 6 * 6 * 8);
                Point3f normal = new Point3f();
                Point3f min = new Point3f();
                Point3f max = new Point3f();
                float[] uvPoints = InterfaceEventsModelLoader.getDefaultBlockTexture(tile.tile.block);
                for (LTBox box : tile.boxes) {
                    block14: for (int i = 0; i < 6; ++i) {
                        switch (i) {
                            case 0: {
                                normal.set(0.0f, -1.0f, 0.0f);
                                min.set((float)box.pos2[0] * scale, (float)box.pos1[1] * scale, (float)box.pos1[2] * scale);
                                max.set((float)box.pos1[0] * scale, (float)box.pos1[1] * scale, (float)box.pos2[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[0] - box.pos1[0]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[2] - box.pos1[2]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, false, buffer);
                                continue block14;
                            }
                            case 1: {
                                normal.set(0.0f, 1.0f, 0.0f);
                                min.set((float)box.pos1[0] * scale, (float)box.pos2[1] * scale, (float)box.pos1[2] * scale);
                                max.set((float)box.pos2[0] * scale, (float)box.pos2[1] * scale, (float)box.pos2[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[0] - box.pos1[0]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[2] - box.pos1[2]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, false, buffer);
                                continue block14;
                            }
                            case 2: {
                                normal.set(0.0f, 0.0f, -1.0f);
                                min.set((float)box.pos2[0] * scale, (float)box.pos1[1] * scale, (float)box.pos1[2] * scale);
                                max.set((float)box.pos1[0] * scale, (float)box.pos2[1] * scale, (float)box.pos1[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[0] - box.pos1[0]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[1] - box.pos1[1]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, true, buffer);
                                continue block14;
                            }
                            case 3: {
                                normal.set(0.0f, 0.0f, 1.0f);
                                min.set((float)box.pos1[0] * scale, (float)box.pos1[1] * scale, (float)box.pos2[2] * scale);
                                max.set((float)box.pos2[0] * scale, (float)box.pos2[1] * scale, (float)box.pos2[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[0] - box.pos1[0]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[1] - box.pos1[1]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, true, buffer);
                                continue block14;
                            }
                            case 4: {
                                normal.set(1.0f, 0.0f, 0.0f);
                                min.set((float)box.pos2[0] * scale, (float)box.pos1[1] * scale, (float)box.pos2[2] * scale);
                                max.set((float)box.pos2[0] * scale, (float)box.pos2[1] * scale, (float)box.pos1[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[2] - box.pos1[2]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[1] - box.pos1[1]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, true, buffer);
                                continue block14;
                            }
                            case 5: {
                                normal.set(-1.0f, 0.0f, 0.0f);
                                min.set((float)box.pos1[0] * scale, (float)box.pos1[1] * scale, (float)box.pos1[2] * scale);
                                max.set((float)box.pos1[0] * scale, (float)box.pos2[1] * scale, (float)box.pos2[2] * scale);
                                float U = uvPoints[0] + (uvPoints[1] - uvPoints[0]) * (float)(box.pos2[2] - box.pos1[2]) * scale;
                                float V = uvPoints[2] + (uvPoints[3] - uvPoints[2]) * (float)(box.pos2[1] - box.pos1[1]) * scale;
                                ModelParserLT.addFaceToBuffer(min, max, normal, uvPoints[0], U, uvPoints[2], V, true, buffer);
                                continue block14;
                            }
                        }
                    }
                }
                RenderableObject newObject = new RenderableObject("little_tiles_generated", "GLOBAL", new ColorRGB(tile.tile.color), buffer, false);
                objectList.add(newObject);
            }
            return objectList;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not finish parsing: " + modelLocation + " due to IOException error.  Did the file change state during parsing?");
        }
    }

    private static void addFaceToBuffer(Point3f min, Point3f max, Point3f normal, float u, float U, float v, float V, boolean horzontalFace, FloatBuffer buffer) {
        block6: for (int i = 0; i < 6; ++i) {
            buffer.put(normal.x);
            buffer.put(normal.y);
            buffer.put(normal.z);
            switch (i) {
                case 0: 
                case 3: {
                    buffer.put(U);
                    buffer.put(V);
                    if (horzontalFace) {
                        buffer.put(max.x);
                        buffer.put(min.y);
                        buffer.put(max.z);
                        continue block6;
                    }
                    buffer.put(max.x);
                    buffer.put(max.y);
                    buffer.put(max.z);
                    continue block6;
                }
                case 1: {
                    buffer.put(U);
                    buffer.put(v);
                    if (horzontalFace) {
                        buffer.put(max.x);
                        buffer.put(max.y);
                        buffer.put(max.z);
                        continue block6;
                    }
                    buffer.put(max.x);
                    buffer.put(max.y);
                    buffer.put(min.z);
                    continue block6;
                }
                case 2: 
                case 4: {
                    buffer.put(u);
                    buffer.put(v);
                    if (horzontalFace) {
                        buffer.put(min.x);
                        buffer.put(max.y);
                        buffer.put(min.z);
                        continue block6;
                    }
                    buffer.put(min.x);
                    buffer.put(max.y);
                    buffer.put(min.z);
                    continue block6;
                }
                case 5: {
                    buffer.put(u);
                    buffer.put(V);
                    if (horzontalFace) {
                        buffer.put(min.x);
                        buffer.put(min.y);
                        buffer.put(min.z);
                        continue block6;
                    }
                    buffer.put(min.x);
                    buffer.put(min.y);
                    buffer.put(max.z);
                }
            }
        }
    }

    public static class LTPropertiesEntry {
        public int color;
        public String block;
    }

    public static class LTBox {
        public int[] pos1;
        public int[] pos2;
    }

    public static class LTTileEntry {
        public LTBox bBox;
        public List<LTBox> boxes;
        public LTPropertiesEntry tile;
    }

    public static class LTMainModel {
        public List<LTTileEntry> tiles;
        public int grid;
    }
}

