/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.RenderableObject;

public final class ModelParserOBJ
extends AModelParser {
    @Override
    protected String getModelSuffix() {
        return "obj";
    }

    @Override
    protected List<RenderableObject> parseModelInternal(String modelLocation) {
        BufferedReader reader;
        ArrayList<RenderableObject> objectList = new ArrayList<RenderableObject>();
        try {
            reader = new BufferedReader(new InputStreamReader(ModelParserOBJ.class.getResourceAsStream(modelLocation)));
        }
        catch (Exception e) {
            throw new NullPointerException("Attempted to parse the OBJ model at: " + modelLocation + " but could not find it.  Check the path and try again.");
        }
        String objectName = null;
        ArrayList<float[]> vertexList = new ArrayList<float[]>();
        ArrayList<float[]> normalList = new ArrayList<float[]>();
        ArrayList<float[]> textureList = new ArrayList<float[]>();
        ArrayList<String> faceList = new ArrayList<String>();
        try {
            int lineNumber = 0;
            while (reader.ready()) {
                float[] coords;
                String line = reader.readLine();
                ++lineNumber;
                if (line.startsWith("o ")) {
                    if (objectName != null) {
                        if (faceList.isEmpty()) {
                            InterfaceCore.logError("Object " + objectName + " found with no faces defined at line: " + lineNumber + " in: " + modelLocation);
                        } else {
                            ModelParserOBJ.compileVertexArray(objectList, vertexList, normalList, textureList, faceList, modelLocation, objectName);
                            objectName = null;
                        }
                    }
                    try {
                        objectName = line.trim().substring(2, line.length());
                    }
                    catch (Exception e) {
                        InterfaceCore.logError("Object found with no name at line: " + lineNumber + " of: " + modelLocation + ".  Make sure your model exporter isn't making things into groups rather than objects.");
                    }
                    continue;
                }
                if (line.startsWith("v ")) {
                    try {
                        coords = new float[3];
                        line = line.trim().substring(2, line.trim().length()).trim();
                        coords[0] = Float.valueOf(line.substring(0, line.indexOf(32))).floatValue();
                        coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32))).floatValue();
                        coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length())).floatValue();
                        vertexList.add(coords);
                    }
                    catch (Exception e) {
                        InterfaceCore.logError("Could not parse vertex info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Vertex lines must consist of only three numbers (X, Y, Z).");
                    }
                    continue;
                }
                if (line.startsWith("vt ")) {
                    try {
                        coords = new float[2];
                        line = line.trim().substring(3, line.trim().length()).trim();
                        int space = line.indexOf(32);
                        int vertexEnd = line.lastIndexOf(32) == space ? line.length() : line.lastIndexOf(32);
                        coords[0] = Float.valueOf(line.substring(0, space)).floatValue();
                        coords[1] = 1.0f - Float.valueOf(line.substring(space + 1, vertexEnd)).floatValue();
                        textureList.add(coords);
                    }
                    catch (Exception e) {
                        InterfaceCore.logError("Could not parse vertex texture info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Vertex texture lines must consist of only two numbers (U, V).");
                    }
                    continue;
                }
                if (line.startsWith("vn ")) {
                    try {
                        coords = new float[3];
                        line = line.trim().substring(2, line.trim().length()).trim();
                        coords[0] = Float.valueOf(line.substring(0, line.indexOf(32))).floatValue();
                        coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32))).floatValue();
                        coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length())).floatValue();
                        normalList.add(coords);
                    }
                    catch (Exception e) {
                        InterfaceCore.logError("Could not parse normals info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Normals lines must consist of only three numbers (Xn, Yn, Zn).");
                    }
                    continue;
                }
                if (!line.startsWith("f ")) continue;
                try {
                    faceList.add(line.trim().substring(2, line.trim().length()));
                }
                catch (Exception e) {
                    InterfaceCore.logError("Could not parse face info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Face lines must consist of sets of three numbers in the format (V1/T1/N1, V2/T2/N2, ...).");
                }
            }
            ModelParserOBJ.compileVertexArray(objectList, vertexList, normalList, textureList, faceList, modelLocation, objectName);
            reader.close();
            return objectList;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not finish parsing: " + modelLocation + " due to IOException error.  Did the file change state during parsing?");
        }
    }

    private static void compileVertexArray(List<RenderableObject> objectList, List<float[]> vertexList, List<float[]> normalList, List<float[]> textureList, List<String> faceList, String modelLocation, String objectName) {
        if (objectName == null) {
            InterfaceCore.logError("No object name found in the entire OBJ model file of " + modelLocation + ".  Resorting to 'model' as default.  Are you using groups instead of objects by mistake?");
            objectName = "model";
        }
        try {
            ArrayList vertexDataSets = new ArrayList();
            for (String faceString : faceList) {
                ArrayList<Object> faceVertexData = new ArrayList<Object>();
                while (!faceString.isEmpty()) {
                    String faceDef;
                    int defEnd = faceString.indexOf(32);
                    if (defEnd != -1) {
                        faceDef = faceString.substring(0, defEnd);
                        faceString = faceString.substring(defEnd + 1);
                    } else {
                        faceDef = faceString;
                        faceString = "";
                    }
                    int firstSlash = faceDef.indexOf(47);
                    int secondSlash = faceDef.lastIndexOf(47);
                    int vertexNumber = Integer.valueOf(faceDef.substring(0, firstSlash)) - 1;
                    int textureNumber = Integer.valueOf(faceDef.substring(firstSlash + 1, secondSlash)) - 1;
                    int normalNumber = Integer.valueOf(faceDef.substring(secondSlash + 1)) - 1;
                    if (faceVertexData.size() >= 3) {
                        faceVertexData.add(faceVertexData.get(0));
                        faceVertexData.add(faceVertexData.get(faceVertexData.size() - 2));
                    }
                    faceVertexData.add(new Integer[]{vertexNumber, textureNumber, normalNumber});
                }
                vertexDataSets.addAll(faceVertexData);
            }
            FloatBuffer compiledBuffer = FloatBuffer.allocate(vertexDataSets.size() * 8);
            for (int i = 0; i < vertexDataSets.size(); ++i) {
                Integer[] vertexData = (Integer[])vertexDataSets.get(i);
                compiledBuffer.put(normalList.get(vertexData[2]));
                compiledBuffer.put(textureList.get(vertexData[1]));
                compiledBuffer.put(vertexList.get(vertexData[0]));
            }
            compiledBuffer.flip();
            objectList.add(new RenderableObject(objectName, null, ColorRGB.WHITE, compiledBuffer, true));
        }
        catch (Exception e) {
            InterfaceCore.logError("Could not compile points of: " + modelLocation + ":" + objectName + ".  This is likely due to missing UV mapping on some or all faces.");
        }
        faceList.clear();
    }
}

