/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntitySignalController;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import minecrafttransportsimulator.rendering.components.ARenderTileEntityBase;
import org.lwjgl.opengl.GL11;

public class RenderDecor
extends ARenderTileEntityBase<TileEntityDecor> {
    @Override
    protected void renderModel(TileEntityDecor decor, boolean blendingEnabled, float partialTicks) {
        super.renderModel(decor, blendingEnabled, partialTicks);
        if (blendingEnabled && decor instanceof TileEntitySignalController) {
            TileEntitySignalController controller = (TileEntitySignalController)decor;
            if (controller.unsavedClientChangesPreset || InterfaceRender.shouldRenderBoundingBoxes()) {
                for (Set<TileEntitySignalController.SignalGroup> signalGroupSet : controller.signalGroups.values()) {
                    for (TileEntitySignalController.SignalGroup signalGroup : signalGroupSet) {
                        if (signalGroup.signalLineWidth == 0.0 || !controller.intersectionProperties.get((Object)((Object)signalGroup.axis)).isActive) continue;
                        BoundingBox box = new BoundingBox(signalGroup.signalLineCenter.copy().add(0.0, 0.0, 8.0).rotateY(signalGroup.axis.yRotation).add(controller.intersectionCenterPoint).subtract(controller.position), signalGroup.signalLineWidth / 2.0, 2.0, 8.0);
                        signalGroup.renderable.setHolographicBoundingBox(box);
                        GL11.glPushMatrix();
                        GL11.glRotated((double)(-controller.angles.y), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glTranslated((double)box.globalCenter.x, (double)box.globalCenter.y, (double)box.globalCenter.z);
                        GL11.glRotated((double)signalGroup.axis.yRotation, (double)0.0, (double)1.0, (double)0.0);
                        signalGroup.renderable.render();
                        GL11.glPopMatrix();
                    }
                }
            }
        }
    }
}

