/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;
import org.lwjgl.opengl.GL11;

public final class RenderInstrument {
    private static final Point3d bottomLeft = new Point3d();
    private static final Point3d topLeft = new Point3d();
    private static final Point3d topRight = new Point3d();
    private static final Point3d bottomRight = new Point3d();
    private static final Point3d rotation = new Point3d();
    private static final float[][] points = new float[6][8];
    private static final RenderableObject renderObject = new RenderableObject("instrument", null, new ColorRGB(), FloatBuffer.allocate(48), false);

    public static void drawInstrument(ItemInstrument instrument, int partNumber, AEntityE_Interactable<?> entity, float scale, boolean blendingEnabled, float partialTicks) {
        boolean lightsOn = entity.renderTextLit();
        float globalScale = entity.scale * scale;
        for (int i = 0; i < ((JSONInstrument)instrument.definition).components.size(); i = (int)((byte)(i + 1))) {
            JSONInstrument.Component component = ((JSONInstrument)instrument.definition).components.get(i);
            if (!(component.overlayTexture ? blendingEnabled : !blendingEnabled)) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)i * 1.0E-4f));
            if (component.textObject != null) {
                boolean addSuffix;
                int variablePartNumber = AEntityD_Definable.getVariableNumber(component.textObject.variableName);
                boolean bl = addSuffix = variablePartNumber == -1 && (component.textObject.variableName.startsWith("engine_") || component.textObject.variableName.startsWith("propeller_") || component.textObject.variableName.startsWith("gun_") || component.textObject.variableName.startsWith("seat_"));
                if (addSuffix) {
                    String oldName = component.textObject.variableName;
                    component.textObject.variableName = component.textObject.variableName + "_" + partNumber;
                    RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, component.textObject, globalScale * component.scale, true);
                    component.textObject.variableName = oldName;
                } else {
                    RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, component.textObject, globalScale * component.scale, true);
                }
            } else {
                RenderInstrument.renderObject.texture = "/assets/" + ((JSONInstrument)instrument.definition).packID + "/textures/" + ((JSONInstrument)instrument.definition).textureName;
                RenderInstrument.renderObject.scale = globalScale * component.scale;
                bottomLeft.set((double)(-component.textureWidth) / 2.0, (double)component.textureHeight / 2.0, 0.0);
                topLeft.set((double)(-component.textureWidth) / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
                topRight.set((double)component.textureWidth / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
                bottomRight.set((double)component.textureWidth / 2.0, (double)component.textureHeight / 2.0, 0.0);
                boolean skipRender = false;
                boolean skipFurtherTransforms = false;
                if (component.animations != null) {
                    for (JSONAnimationDefinition animation : component.animations) {
                        DurationDelayClock animationClock;
                        boolean addSuffix;
                        int variablePartNumber = AEntityD_Definable.getVariableNumber(animation.variable);
                        boolean bl = addSuffix = variablePartNumber == -1 && !(entity instanceof APart) && (animation.variable.startsWith("engine_") || animation.variable.startsWith("propeller_") || animation.variable.startsWith("gun_") || animation.variable.startsWith("seat_"));
                        if (partNumber == 0 && addSuffix) {
                            partNumber = 1;
                        }
                        if (addSuffix) {
                            animation.variable = animation.variable + "_" + partNumber;
                        }
                        if ((animationClock = (DurationDelayClock)entity.animationClocks.get(animation)) == null) {
                            animationClock = new DurationDelayClock(animation);
                            entity.animationClocks.put(animation, animationClock);
                        }
                        switch (animation.animationType) {
                            case ROTATION: {
                                if (skipFurtherTransforms) break;
                                double variableValue = -entity.getAnimatedVariableValue(animationClock, animation.axis.z, partialTicks);
                                if (component.rotateWindow) {
                                    bottomLeft.add(animation.centerPoint);
                                    topLeft.add(animation.centerPoint);
                                    topRight.add(animation.centerPoint);
                                    bottomRight.add(animation.centerPoint);
                                    rotation.set(0.0, 0.0, variableValue);
                                    bottomLeft.rotateFine(rotation);
                                    topLeft.rotateFine(rotation);
                                    topRight.rotateFine(rotation);
                                    bottomRight.rotateFine(rotation);
                                    bottomLeft.subtract(animation.centerPoint);
                                    topLeft.subtract(animation.centerPoint);
                                    topRight.subtract(animation.centerPoint);
                                    bottomRight.subtract(animation.centerPoint);
                                    break;
                                }
                                GL11.glTranslated((double)(((double)component.xCenter + animation.centerPoint.x) * (double)globalScale), (double)(-((double)component.yCenter + animation.centerPoint.y) * (double)globalScale), (double)0.0);
                                GL11.glRotated((double)variableValue, (double)0.0, (double)0.0, (double)1.0);
                                GL11.glTranslated((double)(-((double)component.xCenter + animation.centerPoint.x) * (double)globalScale), (double)(((double)component.yCenter + animation.centerPoint.y) * (double)globalScale), (double)0.0);
                                break;
                            }
                            case TRANSLATION: {
                                if (skipFurtherTransforms) break;
                                double xTranslation = entity.getAnimatedVariableValue(animationClock, animation.axis.x, partialTicks);
                                double yTranslation = entity.getAnimatedVariableValue(animationClock, animation.axis.y, partialTicks);
                                if (component.extendWindow) {
                                    if (animation.axis.x < 0.0) {
                                        RenderInstrument.bottomLeft.x += xTranslation;
                                        RenderInstrument.topLeft.x += xTranslation;
                                    } else if (animation.axis.x > 0.0) {
                                        RenderInstrument.topRight.x += xTranslation;
                                        RenderInstrument.bottomRight.x += xTranslation;
                                    }
                                    if (animation.axis.y < 0.0) {
                                        RenderInstrument.bottomLeft.y += yTranslation;
                                        RenderInstrument.bottomRight.y += yTranslation;
                                        break;
                                    }
                                    if (!(animation.axis.y > 0.0)) break;
                                    RenderInstrument.topLeft.y += yTranslation;
                                    RenderInstrument.topRight.y += yTranslation;
                                    break;
                                }
                                if (component.moveComponent) {
                                    GL11.glTranslated((double)(xTranslation * (double)globalScale), (double)(yTranslation * (double)globalScale), (double)0.0);
                                    break;
                                }
                                if (animation.axis.x != 0.0) {
                                    RenderInstrument.bottomLeft.x += xTranslation;
                                    RenderInstrument.topLeft.x += xTranslation;
                                    RenderInstrument.topRight.x += xTranslation;
                                    RenderInstrument.bottomRight.x += xTranslation;
                                }
                                if (animation.axis.y == 0.0) break;
                                RenderInstrument.bottomLeft.y += yTranslation;
                                RenderInstrument.topLeft.y += yTranslation;
                                RenderInstrument.topRight.y += yTranslation;
                                RenderInstrument.bottomRight.y += yTranslation;
                                break;
                            }
                            case SCALING: {
                                break;
                            }
                            case VISIBILITY: {
                                if (skipFurtherTransforms) break;
                                double variableValue = entity.getAnimatedVariableValue(animationClock, partialTicks);
                                skipRender = variableValue < (double)animation.clampMin || variableValue > (double)animation.clampMax;
                                break;
                            }
                            case INHIBITOR: {
                                if (skipFurtherTransforms) break;
                                double variableValue = entity.getAnimatedVariableValue(animationClock, partialTicks);
                                skipFurtherTransforms = variableValue >= (double)animation.clampMin && variableValue <= (double)animation.clampMax;
                                break;
                            }
                            case ACTIVATOR: {
                                if (!skipFurtherTransforms) break;
                                double variableValue = entity.getAnimatedVariableValue(animationClock, partialTicks);
                                boolean bl2 = skipFurtherTransforms = !(variableValue >= (double)animation.clampMin) || !(variableValue <= (double)animation.clampMax);
                            }
                        }
                        if (addSuffix) {
                            animation.variable = animation.variable.substring(0, animation.variable.length() - ("_" + partNumber).length());
                        }
                        if (!skipRender) continue;
                        break;
                    }
                }
                if (!skipRender) {
                    bottomLeft.add(component.textureXCenter, component.textureYCenter, 0.0);
                    topLeft.add(component.textureXCenter, component.textureYCenter, 0.0);
                    topRight.add(component.textureXCenter, component.textureYCenter, 0.0);
                    bottomRight.add(component.textureXCenter, component.textureYCenter, 0.0);
                    bottomLeft.multiply(9.765625E-4);
                    topLeft.multiply(9.765625E-4);
                    topRight.multiply(9.765625E-4);
                    bottomRight.multiply(9.765625E-4);
                    GL11.glTranslatef((float)((float)component.xCenter * globalScale), (float)((float)(-component.yCenter) * globalScale), (float)0.0f);
                    RenderInstrument.renderObject.disableLighting = component.lightUpTexture && lightsOn && (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value != false;
                    RenderInstrument.renderSquareUV(component, globalScale * component.scale);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private static void renderSquareUV(JSONInstrument.Component component, float componentScale) {
        for (int i = 0; i < points.length; ++i) {
            float[] charVertex = points[i];
            switch (i) {
                case 0: {
                    charVertex[5] = component.textureWidth / 2;
                    charVertex[6] = -component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.bottomRight.x;
                    charVertex[4] = (float)RenderInstrument.bottomRight.y;
                    break;
                }
                case 1: {
                    charVertex[5] = component.textureWidth / 2;
                    charVertex[6] = component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.topRight.x;
                    charVertex[4] = (float)RenderInstrument.topRight.y;
                    break;
                }
                case 2: {
                    charVertex[5] = -component.textureWidth / 2;
                    charVertex[6] = component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.topLeft.x;
                    charVertex[4] = (float)RenderInstrument.topLeft.y;
                    break;
                }
                case 3: {
                    charVertex[5] = component.textureWidth / 2;
                    charVertex[6] = -component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.bottomRight.x;
                    charVertex[4] = (float)RenderInstrument.bottomRight.y;
                    break;
                }
                case 4: {
                    charVertex[5] = -component.textureWidth / 2;
                    charVertex[6] = component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.topLeft.x;
                    charVertex[4] = (float)RenderInstrument.topLeft.y;
                    break;
                }
                case 5: {
                    charVertex[5] = -component.textureWidth / 2;
                    charVertex[6] = -component.textureHeight / 2;
                    charVertex[3] = (float)RenderInstrument.bottomLeft.x;
                    charVertex[4] = (float)RenderInstrument.bottomLeft.y;
                }
            }
            charVertex[2] = componentScale;
            RenderInstrument.renderObject.vertices.put(charVertex);
        }
        RenderInstrument.renderObject.vertices.flip();
        renderObject.render();
    }
}

