/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.rendering.components.ARenderEntityDefinable;
import org.lwjgl.opengl.GL11;

public class RenderPart
extends ARenderEntityDefinable<APart> {
    @Override
    public boolean disableRendering(APart part, float partialTicks) {
        return super.disableRendering(part, partialTicks) || part.isFake() || part.isDisabled;
    }

    @Override
    public void adjustPositionRotation(APart part, Point3d entityPositionDelta, Point3d entityRotationDelta, float partialTicks) {
        entityRotationDelta.add(part.getRenderingRotation(partialTicks));
    }

    @Override
    protected void renderBoundingBoxes(APart part, Point3d entityPositionDelta) {
        if (!part.entityOn.areVariablesBlocking(part.placementDefinition, InterfaceClient.getClientPlayer())) {
            super.renderBoundingBoxes(part, entityPositionDelta);
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                Point3d bulletPosition = new Point3d();
                Point3d bulletVelocity = new Point3d();
                for (JSONMuzzle muzzle : ((JSONPart)gun.definition).gun.muzzleGroups.get((int)gun.currentMuzzleGroupIndex).muzzles) {
                    gun.setBulletSpawn(bulletPosition, bulletVelocity, muzzle);
                    bulletPosition.subtract(gun.position).add(entityPositionDelta);
                    GL11.glTranslated((double)bulletPosition.x, (double)bulletPosition.y, (double)bulletPosition.z);
                    gun.muzzleWireframe.render();
                    GL11.glTranslated((double)(-bulletPosition.x), (double)(-bulletPosition.y), (double)(-bulletPosition.z));
                }
            }
        }
    }
}

