/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.instances.ItemRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.ARenderTileEntityBase;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import org.lwjgl.opengl.GL11;

public class RenderRoad
extends ARenderTileEntityBase<TileEntityRoad> {
    @Override
    protected void renderModel(TileEntityRoad road, boolean blendingEnabled, float partialTicks) {
        block24: {
            block25: {
                if (!(road.isActive() ^ blendingEnabled)) break block24;
                for (TileEntityRoad.RoadComponent roadComponent : road.components.keySet()) {
                    if (!road.componentRenderables.containsKey((Object)roadComponent)) {
                        Point3d position = new Point3d();
                        Point3d rotation = new Point3d();
                        ItemRoadComponent componentItem = road.components.get((Object)roadComponent);
                        switch (roadComponent) {
                            case CORE_STATIC: {
                                List<RenderableObject> parsedModel = AModelParser.parseModel(((JSONRoadComponent)componentItem.definition).getModelLocation(componentItem.subName));
                                int totalVertices = 0;
                                for (RenderableObject renderableObject : parsedModel) {
                                    totalVertices += renderableObject.vertices.capacity();
                                    for (int i = 0; i < renderableObject.vertices.capacity(); i += 8) {
                                        position.set((double)renderableObject.vertices.get(i + 5) - 0.5, renderableObject.vertices.get(i + 6), (double)renderableObject.vertices.get(i + 7) - 0.5);
                                        position.rotateFine(road.angles);
                                        renderableObject.vertices.put(i + 5, (float)position.x);
                                        renderableObject.vertices.put(i + 6, (float)position.y);
                                        renderableObject.vertices.put(i + 7, (float)position.z);
                                    }
                                }
                                FloatBuffer totalModel = FloatBuffer.allocate(totalVertices);
                                for (RenderableObject object : parsedModel) {
                                    totalModel.put(object.vertices);
                                }
                                totalModel.flip();
                                road.componentRenderables.put(roadComponent, new RenderableObject(roadComponent.name(), ((JSONRoadComponent)componentItem.definition).getTextureLocation(componentItem.subName), new ColorRGB(), totalModel, true));
                                break;
                            }
                            case CORE_DYNAMIC: {
                                if (road.dynamicCurve == null) break;
                                List<RenderableObject> parsedModel = AModelParser.parseModel(((JSONRoadComponent)componentItem.definition).getModelLocation(componentItem.subName));
                                int totalVertices = 0;
                                for (RenderableObject renderableObject : parsedModel) {
                                    totalVertices += renderableObject.vertices.capacity();
                                }
                                FloatBuffer parsedVertices = FloatBuffer.allocate(totalVertices);
                                for (RenderableObject object : parsedModel) {
                                    parsedVertices.put(object.vertices);
                                }
                                parsedVertices.flip();
                                Point3d point3d = new Point3d();
                                Point3d priorRotation = new Point3d();
                                Point3d testPoint1 = new Point3d();
                                Point3d testPoint2 = new Point3d();
                                Point3d vertexOffsetPriorLine = new Point3d();
                                Point3d vertexOffsetCurrentLine = new Point3d();
                                Point3d segmentVector = new Point3d();
                                Point3d renderedVertex = new Point3d();
                                float indexDelta = (float)((double)road.dynamicCurve.pathLength / Math.floor(road.dynamicCurve.pathLength / ((JSONRoadComponent)road.definition).road.segmentLength));
                                boolean finalSegment = false;
                                float priorIndex = 0.0f;
                                float currentIndex = 0.0f;
                                ArrayList<float[]> segmentVertices = new ArrayList<float[]>();
                                while (!finalSegment) {
                                    if (currentIndex != road.dynamicCurve.pathLength && (double)currentIndex + (double)indexDelta * 1.25 > (double)road.dynamicCurve.pathLength) {
                                        currentIndex = road.dynamicCurve.pathLength;
                                        finalSegment = true;
                                    } else {
                                        currentIndex += indexDelta;
                                    }
                                    road.dynamicCurve.setPointToPositionAt(point3d, priorIndex);
                                    road.dynamicCurve.setPointToRotationAt(priorRotation, priorIndex);
                                    road.dynamicCurve.setPointToPositionAt(position, currentIndex);
                                    road.dynamicCurve.setPointToRotationAt(rotation, currentIndex);
                                    testPoint1.set(((JSONRoadComponent)road.definition).road.borderOffset, 0.0, 0.0).rotateFine(priorRotation).add(point3d);
                                    testPoint2.set(((JSONRoadComponent)road.definition).road.borderOffset, 0.0, 0.0).rotateFine(rotation).add(position);
                                    if (currentIndex != road.dynamicCurve.pathLength && ((position.x - point3d.x) * (testPoint2.x - testPoint1.x) < 0.0 || (position.z - point3d.z) * (testPoint2.z - testPoint1.z) < 0.0)) {
                                        if (!(currentIndex + 3.0f * indexDelta > road.dynamicCurve.pathLength)) continue;
                                        currentIndex = road.dynamicCurve.pathLength - indexDelta;
                                        continue;
                                    }
                                    for (int i = 0; i < parsedVertices.capacity(); i += 8) {
                                        float[] convertedVertexData = new float[8];
                                        parsedVertices.get(convertedVertexData, 0, 5);
                                        float x = parsedVertices.get();
                                        float y = parsedVertices.get();
                                        float z = parsedVertices.get();
                                        vertexOffsetPriorLine.set(x, y, 0.0);
                                        vertexOffsetPriorLine.rotateFine(priorRotation).add(point3d);
                                        vertexOffsetCurrentLine.set(x, y, 0.0);
                                        vertexOffsetCurrentLine.rotateFine(rotation).add(position);
                                        segmentVector.setTo(vertexOffsetCurrentLine).subtract(vertexOffsetPriorLine).multiply(Math.abs(z) / ((JSONRoadComponent)road.definition).road.segmentLength);
                                        renderedVertex.setTo(vertexOffsetPriorLine).add(segmentVector);
                                        convertedVertexData[5] = (float)renderedVertex.x;
                                        convertedVertexData[6] = (float)renderedVertex.y;
                                        convertedVertexData[7] = (float)renderedVertex.z;
                                        segmentVertices.add(convertedVertexData);
                                    }
                                    parsedVertices.rewind();
                                    priorIndex = currentIndex;
                                }
                                FloatBuffer convertedVertices = FloatBuffer.allocate(segmentVertices.size() * 8);
                                for (float[] segmentVertex : segmentVertices) {
                                    convertedVertices.put(segmentVertex);
                                }
                                convertedVertices.flip();
                                road.componentRenderables.put(roadComponent, new RenderableObject(roadComponent.name(), ((JSONRoadComponent)componentItem.definition).getTextureLocation(componentItem.subName), new ColorRGB(), convertedVertices, true));
                                break;
                            }
                        }
                    }
                    RenderableObject object = road.componentRenderables.get((Object)roadComponent);
                    if (road.isActive()) {
                        object.color.setTo(ColorRGB.WHITE);
                        object.alpha = 1.0f;
                        object.isTranslucent = false;
                    } else {
                        object.color.setTo(ColorRGB.GREEN);
                        object.alpha = 0.5f;
                        object.isTranslucent = true;
                    }
                    object.render();
                }
                if (road.isActive()) break block25;
                if (road.blockingRenderables.isEmpty()) {
                    road.blockingRenderables.put(new Point3d(0.0, 0.75, 0.0), new RenderableObject(new BoundingBox(new Point3d(), 0.15, 1.5, 0.15), ColorRGB.BLUE, true));
                    for (Point3d point3d : road.collidingBlockOffsets) {
                        road.blockingRenderables.put(point3d, new RenderableObject(new BoundingBox(point3d, 0.55, 0.55, 0.55), ColorRGB.RED, true));
                    }
                }
                for (Map.Entry entry : road.blockingRenderables.entrySet()) {
                    Point3d location = (Point3d)entry.getKey();
                    RenderableObject renderable = (RenderableObject)entry.getValue();
                    GL11.glTranslated((double)location.x, (double)(location.y + 0.5), (double)location.z);
                    renderable.render();
                    GL11.glTranslated((double)(-location.x), (double)(-location.y - 0.5), (double)(-location.z));
                }
                break block24;
            }
            if (!((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue() || !InterfaceRender.shouldRenderBoundingBoxes()) break block24;
            if (road.devRenderables.isEmpty()) {
                RenderRoad.generateDevElements(road);
            }
            for (RenderableObject renderableObject : road.devRenderables) {
                renderableObject.render();
            }
        }
    }

    @Override
    protected void renderBoundingBoxes(TileEntityRoad road, Point3d entityPositionDelta) {
        super.renderBoundingBoxes(road, entityPositionDelta);
        GL11.glTranslated((double)entityPositionDelta.x, (double)entityPositionDelta.y, (double)entityPositionDelta.z);
        for (Point3d blockOffset : road.collisionBlockOffsets) {
            ABlockBase block = road.world.getBlock(road.position.copy().add(blockOffset));
            if (!(block instanceof BlockCollision)) continue;
            BoundingBox blockBounds = ((BlockCollision)block).blockBounds;
            GL11.glTranslated((double)blockOffset.x, (double)(blockOffset.y + blockBounds.heightRadius), (double)blockOffset.z);
            blockBounds.renderable.render();
            GL11.glTranslated((double)(-blockOffset.x), (double)(-blockOffset.y - blockBounds.heightRadius), (double)(-blockOffset.z));
        }
        GL11.glTranslated((double)(-entityPositionDelta.x), (double)(-entityPositionDelta.y), (double)(-entityPositionDelta.z));
    }

    private static void generateDevElements(TileEntityRoad road) {
        BezierCurve otherCurve;
        RoadLane otherLane;
        TileEntityRoad otherRoad;
        BezierCurve currentCurve;
        RenderableObject curveObject;
        Point3d point1 = new Point3d();
        Point3d point2 = new Point3d();
        if (road.dynamicCurve != null) {
            curveObject = new RenderableObject(ColorRGB.GREEN, (int)(road.dynamicCurve.pathLength * 10.0f));
            float f = 0.0f;
            while (curveObject.vertices.hasRemaining()) {
                road.dynamicCurve.setPointToPositionAt(point1, f);
                curveObject.addLine((float)point1.x, (float)point1.y, (float)point1.z, (float)point1.x, (float)point1.y + 1.0f, (float)point1.z);
                f = (float)((double)f + 0.1);
            }
            curveObject.vertices.flip();
            road.devRenderables.add(curveObject);
            curveObject = new RenderableObject(ColorRGB.CYAN, (int)(road.dynamicCurve.pathLength * 10.0f));
            f = 0.0f;
            while (curveObject.vertices.hasRemaining()) {
                road.dynamicCurve.setPointToRotationAt(point2, f);
                point1.set(((JSONRoadComponent)road.definition).road.borderOffset, 0.0, 0.0).rotateFine(point2);
                road.dynamicCurve.offsetPointByPositionAt(point1, f);
                curveObject.addLine((float)point1.x, (float)point1.y, (float)point1.z, (float)point1.x, (float)point1.y + 1.0f, (float)point1.z);
                f = (float)((double)f + 0.1);
            }
            curveObject.vertices.flip();
            road.devRenderables.add(curveObject);
        }
        for (RoadLane lane : road.lanes) {
            for (BezierCurve bezierCurve : lane.curves) {
                curveObject = new RenderableObject(ColorRGB.RED, 2);
                Point3d bearingPos = bezierCurve.endPos.copy().subtract(bezierCurve.startPos).normalize().add(bezierCurve.startPos);
                curveObject.addLine((float)bezierCurve.startPos.x, (float)bezierCurve.startPos.y, (float)bezierCurve.startPos.z, (float)bezierCurve.startPos.x, (float)bezierCurve.startPos.y + 3.0f, (float)bezierCurve.startPos.z);
                curveObject.addLine((float)bezierCurve.startPos.x, (float)bezierCurve.startPos.y + 3.0f, (float)bezierCurve.startPos.z, (float)bearingPos.x, (float)bearingPos.y + 3.0f, (float)bearingPos.z);
                curveObject.vertices.flip();
                road.devRenderables.add(curveObject);
                curveObject = new RenderableObject(ColorRGB.YELLOW, (int)(bezierCurve.pathLength * 10.0f));
                float f = 0.0f;
                while (curveObject.vertices.hasRemaining()) {
                    bezierCurve.setPointToPositionAt(point1, f);
                    curveObject.addLine((float)point1.x, (float)point1.y, (float)point1.z, (float)point1.x, (float)point1.y + 1.0f, (float)point1.z);
                    f = (float)((double)f + 0.1);
                }
                curveObject.vertices.flip();
                road.devRenderables.add(curveObject);
            }
        }
        for (RoadLane lane : road.lanes) {
            for (List list : lane.priorConnections) {
                currentCurve = lane.curves.get(lane.priorConnections.indexOf(list));
                for (RoadLaneConnection priorConnection : list) {
                    otherRoad = (TileEntityRoad)road.world.getTileEntity(priorConnection.tileLocation);
                    if (otherRoad == null || (otherLane = otherRoad.lanes.get(priorConnection.laneNumber)) == null) continue;
                    curveObject = new RenderableObject(ColorRGB.PINK, 3);
                    currentCurve.setPointToPositionAt(point1, 0.5f);
                    otherCurve = otherLane.curves.get(priorConnection.curveNumber);
                    otherCurve.setPointToPositionAt(point2, priorConnection.connectedToStart ? 0.5f : otherCurve.pathLength - 0.5f);
                    point2.add(otherLane.road.position).subtract(road.position);
                    curveObject.addLine((float)point1.x, (float)point1.y + 3.0f, (float)point1.z, (float)point1.x, (float)point1.y + 0.5f, (float)point1.z);
                    curveObject.addLine((float)point1.x, (float)point1.y + 0.5f, (float)point1.z, (float)point2.x, (float)point2.y + 0.5f, (float)point2.z);
                    curveObject.addLine((float)point2.x, (float)point2.y + 0.5f, (float)point2.z, (float)point2.x, (float)point2.y + 2.0f, (float)point2.z);
                    curveObject.vertices.flip();
                    road.devRenderables.add(curveObject);
                }
            }
        }
        for (RoadLane lane : road.lanes) {
            for (List list : lane.nextConnections) {
                currentCurve = lane.curves.get(lane.nextConnections.indexOf(list));
                for (RoadLaneConnection nextConnection : list) {
                    otherRoad = (TileEntityRoad)road.world.getTileEntity(nextConnection.tileLocation);
                    if (otherRoad == null || (otherLane = otherRoad.lanes.get(nextConnection.laneNumber)) == null) continue;
                    curveObject = new RenderableObject(ColorRGB.ORANGE, 3);
                    currentCurve.setPointToPositionAt(point1, currentCurve.pathLength - 0.5f);
                    otherCurve = otherLane.curves.get(nextConnection.curveNumber);
                    otherCurve.setPointToPositionAt(point2, nextConnection.connectedToStart ? 0.5f : otherCurve.pathLength - 0.5f);
                    point2.add(otherLane.road.position).subtract(road.position);
                    curveObject.addLine((float)point1.x, (float)point1.y + 3.0f, (float)point1.z, (float)point1.x, (float)point1.y + 0.5f, (float)point1.z);
                    curveObject.addLine((float)point1.x, (float)point1.y + 0.5f, (float)point1.z, (float)point2.x, (float)point2.y + 0.5f, (float)point2.z);
                    curveObject.addLine((float)point2.x, (float)point2.y + 0.5f, (float)point2.z, (float)point2.x, (float)point2.y + 2.0f, (float)point2.z);
                    curveObject.vertices.flip();
                    road.devRenderables.add(curveObject);
                }
            }
        }
    }

    @Override
    public void adjustPositionRotation(TileEntityRoad road, Point3d entityPositionDelta, Point3d entityRotationDelta, float partialTicks) {
        super.adjustPositionRotation(road, entityPositionDelta, entityRotationDelta, partialTicks);
        entityRotationDelta.set(0.0, 0.0, 0.0);
    }

    @Override
    public boolean translateToSlabs() {
        return false;
    }
}

