/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import org.lwjgl.opengl.GL11;

public class RenderText {
    public static final char FORMATTING_CHAR = '\u00a7';
    public static final char BOLD_FORMATTING_CHAR = 'l';
    public static final char ITALIC_FORMATTING_CHAR = 'o';
    public static final char UNDERLINE_FORMATTING_CHAR = 'n';
    public static final char STRIKETHROUGH_FORMATTING_CHAR = 'm';
    public static final char RANDOM_FORMATTING_CHAR = 'k';
    public static final char RESET_FORMATTING_CHAR = 'r';
    public static final char UNDERLINE_CHAR = '_';
    public static final char STRIKETHROUGH_CHAR = '-';
    private static final Map<String, FontData> fontDatas = new HashMap<String, FontData>();

    public static void drawText(String text, String fontName, Point3d position, Point3d rotation, ColorRGB color, TextAlignment alignment, float scale, boolean autoScale, int wrapWidth, float prevScaleFactor, boolean renderLit) {
        if (!text.isEmpty()) {
            RenderText.getFontData(fontName).renderText(text, position, rotation, alignment, scale, autoScale, wrapWidth, 1.0f, true, color, renderLit);
        }
    }

    public static void draw3DText(String text, AEntityD_Definable<?> entity, JSONText definition, float preScaledFactor, boolean pixelCoords) {
        if (!text.isEmpty()) {
            ColorRGB color = entity.getTextColor(definition.inheritedColorIndex, definition.color);
            float scale = pixelCoords ? definition.scale : definition.scale / 16.0f;
            RenderText.getFontData(definition.fontName).renderText(text, definition.pos, definition.rot, TextAlignment.values()[definition.renderPosition], scale, definition.autoScale, definition.wrapWidth, preScaledFactor, pixelCoords, color, definition.lightsUp && entity.renderTextLit());
        }
    }

    public static float getStringWidth(String text, String fontName) {
        FontData font = RenderText.getFontData(fontName);
        if (font.isDefault) {
            return 1.4f * font.getStringWidth(text);
        }
        return font.getStringWidth(text);
    }

    public static float getHeight(int numberLines, String fontName) {
        float height = (float)numberLines * 8.5f;
        if (RenderText.getFontData(fontName).isDefault) {
            return 1.4f * height;
        }
        return height;
    }

    private static FontData getFontData(String fontName) {
        FontData fontData = fontDatas.get(fontName);
        if (fontData == null) {
            fontData = new FontData(fontName);
            fontDatas.put(fontName, fontData);
        }
        return fontData;
    }

    public static enum TextAlignment {
        CENTERED,
        LEFT_ALIGNED,
        RIGHT_ALIGNED;

    }

    private static class FontData {
        private static final byte CHARS_PER_ROWCOL = 16;
        private static final int CHARS_PER_TEXTURE_SHEET = 256;
        private static final byte DEFAULT_PIXELS_PER_CHAR = 8;
        private static final float CHAR_SPACING = 0.5f;
        private static final ColorRGB[] COLORS = new ColorRGB[]{new ColorRGB(0, 0, 0), new ColorRGB(0, 0, 170), new ColorRGB(0, 170, 0), new ColorRGB(0, 170, 170), new ColorRGB(170, 0, 0), new ColorRGB(170, 0, 170), new ColorRGB(255, 170, 0), new ColorRGB(170, 170, 170), new ColorRGB(85, 85, 85), new ColorRGB(85, 85, 255), new ColorRGB(85, 255, 85), new ColorRGB(85, 255, 255), new ColorRGB(255, 85, 85), new ColorRGB(255, 85, 255), new ColorRGB(255, 255, 85), new ColorRGB(255, 255, 255)};
        private static final FontRenderState[] STATES = FontRenderState.generateDefaults();
        private static final int MAX_VERTCIES_PER_RENDER = 6000;
        private static final Point3d DEFAULT_ADJ = new Point3d();
        private static final Point3d MUTABLE_POSITION = new Point3d();
        private final boolean isDefault;
        private final String[] fontLocations = new String[255];
        private final float[] charWidths = new float[65535];
        private final float[] offsetsMinU = new float[65535];
        private final float[] offsetsMaxU = new float[65535];
        private final float[] offsetsMinV = new float[65535];
        private final float[] offsetsMaxV = new float[65535];
        private static final Map<String, Map<ColorRGB, RenderableObject>> createdRenderObjects = new HashMap<String, Map<ColorRGB, RenderableObject>>();
        private final Set<RenderableObject> activeRenderObjects = new LinkedHashSet<RenderableObject>();
        private final float[] charVertex = new float[3];
        private final float[] supplementalVertex = new float[3];
        private final float[] charUV = new float[2];
        private final float[] supplementalUV = new float[2];
        private final Point3d rotatedVertex = new Point3d();

        private FontData(String fontName) {
            this.isDefault = fontName == null;
            String fontBaseLocation = this.isDefault ? "/assets/minecraft/textures/font/unicode_page_" : "/assets/" + fontName.substring(0, fontName.indexOf(":")) + "/textures/fonts/" + fontName.substring(fontName.indexOf(":") + 1) + "/unicode_page_";
            for (int i = 0; i < this.fontLocations.length; ++i) {
                BufferedImage bufferedImage;
                this.fontLocations[i] = String.format("%s%02x.png", fontBaseLocation, i);
                try {
                    bufferedImage = ImageIO.read(RenderText.class.getResourceAsStream(this.fontLocations[i]));
                }
                catch (Exception e) {
                    continue;
                }
                int pixelsPerSide = bufferedImage.getHeight();
                int pixelsPerRowCol = pixelsPerSide / 16;
                for (int charRow = 0; charRow < 16; ++charRow) {
                    block4: for (int charCol = 0; charCol < 16; ++charCol) {
                        char charChecking = (char)(i * 256 + charRow * 16 + charCol);
                        if (charChecking == ' ') {
                            this.charWidths[charChecking] = 4.0f;
                            continue;
                        }
                        this.offsetsMinU[charChecking] = (float)charCol / 16.0f;
                        this.offsetsMaxU[charChecking] = (float)(charCol + 1) / 16.0f;
                        this.offsetsMaxV[charChecking] = (float)charRow / 16.0f;
                        this.offsetsMinV[charChecking] = (float)(charRow + 1) / 16.0f;
                        this.charWidths[charChecking] = 8.0f;
                        boolean foundPixelThisCol = false;
                        for (int pixelCol = (charCol + 1) * pixelsPerRowCol - 1; pixelCol >= charCol * pixelsPerRowCol; --pixelCol) {
                            for (int pixelRow = charRow * pixelsPerRowCol; pixelRow < (charRow + 1) * pixelsPerRowCol; ++pixelRow) {
                                int pixelValue = bufferedImage.getRGB(pixelCol, pixelRow);
                                if (pixelValue == 0 || pixelValue >> 24 == 0) continue;
                                this.offsetsMaxU[charChecking] = (float)(++pixelCol) / (float)pixelsPerRowCol / 16.0f;
                                this.charWidths[charChecking] = (float)((pixelCol - charCol * pixelsPerRowCol) * 8) / (float)pixelsPerRowCol;
                                foundPixelThisCol = true;
                                break;
                            }
                            if (foundPixelThisCol) continue block4;
                        }
                    }
                }
            }
        }

        private void renderText(String text, Point3d position, Point3d rotation, TextAlignment alignment, float scale, boolean autoScale, int wrapWidth, float preScaledFactor, boolean pixelCoords, ColorRGB color, boolean renderLit) {
            MUTABLE_POSITION.setTo(position);
            if (text.length() > 1000) {
                text = text.substring(0, 1000);
            }
            boolean doRotation = rotation != null && !rotation.isZero();
            float[] normals = new float[]{0.0f, 0.0f, 1.0f};
            if (doRotation) {
                Point3d rotatedNormals = new Point3d(normals[0], normals[1], normals[2]).rotateFine(rotation);
                normals[0] = (float)rotatedNormals.x;
                normals[1] = (float)rotatedNormals.y;
                normals[2] = (float)rotatedNormals.z;
            }
            if (text.indexOf(274) != -1) {
                char[] textArray = text.toCharArray();
                boolean randomActive = false;
                for (int i = 0; i < textArray.length; ++i) {
                    if (textArray[i] == '\u00a7') {
                        char formattingChar;
                        if ((formattingChar = textArray[++i]) == 'k') {
                            randomActive = true;
                            continue;
                        }
                        if (formattingChar != 'r') continue;
                        randomActive = false;
                        continue;
                    }
                    if (!randomActive) continue;
                    textArray[i] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt((int)(Math.random() * 36.0));
                }
                text = String.valueOf(textArray);
            }
            if (this.isDefault) {
                DEFAULT_ADJ.set(0.0, (double)(8.0f * scale) * 0.4, 0.0);
                if (doRotation) {
                    DEFAULT_ADJ.rotateFine(rotation);
                }
                scale = (float)((double)scale * 1.4);
            } else {
                DEFAULT_ADJ.set(0.0, 0.0, 0.0);
            }
            float stringWidth = this.getStringWidth(text);
            if (autoScale && wrapWidth > 0) {
                float adjustedStringWidthFactor = scale * stringWidth;
                if (!pixelCoords) {
                    adjustedStringWidthFactor *= 16.0f;
                }
                if (adjustedStringWidthFactor > (float)wrapWidth) {
                    double scaleFactor = (float)wrapWidth / adjustedStringWidthFactor;
                    if (pixelCoords) {
                        DEFAULT_ADJ.add(0.0, -8.0 * ((double)scale * scaleFactor - (double)scale) / 2.0, 0.0);
                    } else {
                        DEFAULT_ADJ.add(0.0, 8.0 * ((double)scale * scaleFactor - (double)scale) / 2.0, 0.0);
                    }
                    scale = (float)((double)scale * scaleFactor);
                }
                wrapWidth = 0;
            }
            MUTABLE_POSITION.add(DEFAULT_ADJ);
            MUTABLE_POSITION.multiply(preScaledFactor);
            float alignmentOffset = 0.0f;
            if (alignment.equals((Object)TextAlignment.CENTERED)) {
                alignmentOffset = (wrapWidth == 0 ? -stringWidth : (float)(-wrapWidth)) / 2.0f;
            } else if (alignment.equals((Object)TextAlignment.RIGHT_ALIGNED)) {
                alignmentOffset = -stringWidth;
            }
            if (wrapWidth != 0) {
                wrapWidth = (int)((float)wrapWidth / scale);
            }
            int currentOffset = 0;
            int currentLineOffset = 0;
            int indexAtLastNewline = 0;
            ColorRGB currentColor = color;
            FontRenderState currentState = STATES[0];
            block26: for (int i = 0; i < text.length(); ++i) {
                char textChar = text.charAt(i);
                if (textChar == '\u00a7') {
                    char formattingChar = text.charAt(++i);
                    switch (formattingChar) {
                        case 'l': {
                            currentState = STATES[currentState.index | 1];
                            break;
                        }
                        case 'o': {
                            currentState = STATES[currentState.index | 2];
                            break;
                        }
                        case 'n': {
                            currentState = STATES[currentState.index | 4];
                            break;
                        }
                        case 'm': {
                            currentState = STATES[currentState.index | 8];
                            break;
                        }
                        case 'r': {
                            currentState = STATES[0];
                            currentColor = color;
                            break;
                        }
                        default: {
                            try {
                                currentColor = COLORS[Integer.decode("0x" + formattingChar)];
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                    continue;
                }
                if (textChar == '\n') {
                    currentOffset = 0;
                    currentLineOffset = (int)((float)currentLineOffset - 8.5f);
                    indexAtLastNewline = i;
                    continue;
                }
                if (wrapWidth != 0 && currentOffset > wrapWidth) {
                    if (text.substring(indexAtLastNewline + 1, i).indexOf(32) != -1) {
                        for (int j = i - 1; j > 0; --j) {
                            char priorChar = text.charAt(j);
                            if (priorChar == ' ') {
                                i = j;
                                currentOffset = 0;
                                currentLineOffset = (int)((float)currentLineOffset - 8.5f);
                                indexAtLastNewline = i;
                                continue block26;
                            }
                            RenderableObject priorRenderObject = this.getObjectFor(priorChar, currentColor);
                            if (priorRenderObject.vertices.position() != 0) {
                                priorRenderObject.vertices.position(priorRenderObject.vertices.position() - 48);
                            }
                            if (currentState.bold) {
                                priorRenderObject.vertices.position(priorRenderObject.vertices.position() - 48);
                            }
                            if (currentState.underline) {
                                RenderableObject underlineRenderObject = this.getObjectFor('_', currentColor);
                                underlineRenderObject.vertices.position(underlineRenderObject.vertices.position() - 48);
                            }
                            if (!currentState.strikethrough) continue;
                            RenderableObject strikethroughRenderObject = this.getObjectFor('-', currentColor);
                            strikethroughRenderObject.vertices.position(strikethroughRenderObject.vertices.position() - 48);
                        }
                        continue;
                    }
                    currentOffset = 0;
                    currentLineOffset = (int)((float)currentLineOffset - 8.5f);
                    indexAtLastNewline = i;
                    continue;
                }
                if (textChar == ' ') {
                    currentOffset = (int)((float)currentOffset + (this.charWidths[textChar] + 0.5f));
                    continue;
                }
                RenderableObject currentRenderObject = this.getObjectFor(textChar, currentColor);
                float charWidth = this.charWidths[textChar];
                int charSteps = 6;
                if (currentState.bold) {
                    charSteps += 6;
                }
                if (currentState.underline) {
                    charSteps += 6;
                }
                if (currentState.strikethrough) {
                    charSteps += 6;
                }
                block28: for (int j = 0; j < charSteps; ++j) {
                    switch (j) {
                        case 0: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset + charWidth;
                            this.charVertex[1] = currentLineOffset - 8;
                            this.charUV[0] = this.offsetsMaxU[textChar];
                            this.charUV[1] = this.offsetsMinV[textChar];
                            break;
                        }
                        case 1: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset + charWidth;
                            if (currentState.italic) {
                                this.charVertex[0] = this.charVertex[0] + 1.0f;
                            }
                            this.charVertex[1] = currentLineOffset;
                            this.charUV[0] = this.offsetsMaxU[textChar];
                            this.charUV[1] = this.offsetsMaxV[textChar];
                            break;
                        }
                        case 2: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset;
                            if (currentState.italic) {
                                this.charVertex[0] = this.charVertex[0] + 1.0f;
                            }
                            this.charVertex[1] = currentLineOffset;
                            this.charUV[0] = this.offsetsMinU[textChar];
                            this.charUV[1] = this.offsetsMaxV[textChar];
                            break;
                        }
                        case 3: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset + charWidth;
                            this.charVertex[1] = currentLineOffset - 8;
                            this.charUV[0] = this.offsetsMaxU[textChar];
                            this.charUV[1] = this.offsetsMinV[textChar];
                            break;
                        }
                        case 4: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset;
                            if (currentState.italic) {
                                this.charVertex[0] = this.charVertex[0] + 1.0f;
                            }
                            this.charVertex[1] = currentLineOffset;
                            this.charUV[0] = this.offsetsMinU[textChar];
                            this.charUV[1] = this.offsetsMaxV[textChar];
                            break;
                        }
                        case 5: {
                            this.charVertex[0] = alignmentOffset + (float)currentOffset;
                            this.charVertex[1] = currentLineOffset - 8;
                            this.charUV[0] = this.offsetsMinU[textChar];
                            this.charUV[1] = this.offsetsMinV[textChar];
                            break;
                        }
                        default: {
                            char customChar;
                            int currentIndex = currentRenderObject.vertices.position();
                            currentRenderObject.vertices.position(currentIndex - (6 - j % 6 + j - 6) * 8 + 3);
                            currentRenderObject.vertices.get(this.supplementalUV);
                            currentRenderObject.vertices.get(this.supplementalVertex);
                            currentRenderObject.vertices.position(currentIndex);
                            if (currentState.bold && j < 12) {
                                this.supplementalVertex[0] = this.supplementalVertex[0] + 0.2f * scale;
                                this.supplementalVertex[1] = this.supplementalVertex[1] + 0.2f * scale;
                                currentRenderObject.vertices.put(normals).put(this.supplementalUV).put(this.supplementalVertex);
                                break;
                            }
                            if (currentState.underline && j < 18) {
                                customChar = '_';
                            } else {
                                if (!currentState.strikethrough) continue block28;
                                customChar = '-';
                            }
                            this.supplementalVertex[1] = this.supplementalVertex[1] + 0.5f;
                            switch (j % 6) {
                                case 0: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] + 0.5f;
                                    this.supplementalUV[0] = this.offsetsMaxU[customChar];
                                    this.supplementalUV[1] = this.offsetsMinV[customChar];
                                    break;
                                }
                                case 1: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] + 0.5f;
                                    this.supplementalUV[0] = this.offsetsMaxU[customChar];
                                    this.supplementalUV[1] = this.offsetsMaxV[customChar];
                                    break;
                                }
                                case 2: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] - 0.5f;
                                    this.supplementalUV[0] = this.offsetsMinU[customChar];
                                    this.supplementalUV[1] = this.offsetsMaxV[customChar];
                                    break;
                                }
                                case 3: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] + 0.5f;
                                    this.supplementalUV[0] = this.offsetsMaxU[customChar];
                                    this.supplementalUV[1] = this.offsetsMinV[customChar];
                                    break;
                                }
                                case 4: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] - 0.5f;
                                    this.supplementalUV[0] = this.offsetsMinU[customChar];
                                    this.supplementalUV[1] = this.offsetsMaxV[customChar];
                                    break;
                                }
                                case 5: {
                                    this.supplementalVertex[0] = this.supplementalVertex[0] - 0.5f;
                                    this.supplementalUV[0] = this.offsetsMinU[customChar];
                                    this.supplementalUV[1] = this.offsetsMinV[customChar];
                                }
                            }
                            RenderableObject customRenderObject = this.getObjectFor(customChar, currentColor);
                            customRenderObject.vertices.put(normals).put(this.supplementalUV).put(this.supplementalVertex);
                            this.activeRenderObjects.add(customRenderObject);
                        }
                    }
                    if (j >= 6) continue;
                    this.charVertex[2] = 0.0f;
                    if (doRotation) {
                        this.rotatedVertex.set(this.charVertex[0], this.charVertex[1], this.charVertex[2]).rotateFine(rotation);
                        this.charVertex[0] = (float)this.rotatedVertex.x;
                        this.charVertex[1] = (float)this.rotatedVertex.y;
                        this.charVertex[2] = (float)this.rotatedVertex.z;
                    }
                    currentRenderObject.vertices.put(normals).put(this.charUV).put(this.charVertex);
                }
                currentOffset = (int)((float)currentOffset + (charWidth + 0.5f));
                this.activeRenderObjects.add(currentRenderObject);
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)FontData.MUTABLE_POSITION.x, (double)FontData.MUTABLE_POSITION.y, (double)FontData.MUTABLE_POSITION.z);
            for (RenderableObject object : this.activeRenderObjects) {
                object.disableLighting = renderLit;
                object.scale = scale * preScaledFactor;
                object.vertices.flip();
                object.render();
                object.vertices.clear();
            }
            this.activeRenderObjects.clear();
            GL11.glPopMatrix();
        }

        private RenderableObject getObjectFor(char textChar, ColorRGB color) {
            RenderableObject object;
            String font;
            Map<ColorRGB, RenderableObject> map1;
            if (textChar / 256 >= this.fontLocations.length) {
                textChar = '\u0000';
            }
            if ((map1 = createdRenderObjects.get(font = this.fontLocations[textChar / 256])) == null) {
                map1 = new HashMap<ColorRGB, RenderableObject>();
                createdRenderObjects.put(font, map1);
            }
            if ((object = map1.get(color)) == null) {
                object = new RenderableObject("font_block", font, color, FloatBuffer.allocate(48000), false);
                map1.put(color, object);
            }
            return object;
        }

        private float getStringWidth(String text) {
            float stringWidth = 0.0f;
            int totalChars = 0;
            boolean skipNext = false;
            for (char textChar : text.toCharArray()) {
                if (textChar == '\u00a7') {
                    skipNext = true;
                    continue;
                }
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                stringWidth += this.charWidths[textChar];
                ++totalChars;
            }
            return stringWidth + (float)totalChars * 0.5f;
        }

        private static class FontRenderState {
            private static final int BOLD_BIT_INDEX = 1;
            private static final int ITALIC_BIT_INDEX = 2;
            private static final int UNDERLINE_BIT_INDEX = 4;
            private static final int STRIKETHROUGH_BIT_INDEX = 8;
            private final int index;
            private final boolean bold;
            private final boolean italic;
            private final boolean underline;
            private final boolean strikethrough;

            private FontRenderState(int index) {
                this.index = index;
                this.bold = (index & 1) == 1;
                this.italic = (index & 2) == 2;
                this.underline = (index & 4) == 4;
                this.strikethrough = (index & 8) == 8;
            }

            public static FontRenderState[] generateDefaults() {
                FontRenderState[] states = new FontRenderState[(int)Math.pow(2.0, 4.0)];
                for (int i = 0; i < states.length; ++i) {
                    states[i] = new FontRenderState(i);
                }
                return states;
            }
        }
    }
}

