/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.rendering.components.ARenderEntityDefinable;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import org.lwjgl.opengl.GL11;

public class RenderVehicle
extends ARenderEntityDefinable<EntityVehicleF_Physics> {
    @Override
    protected void renderModel(EntityVehicleF_Physics vehicle, boolean blendingEnabled, float partialTicks) {
        super.renderModel(vehicle, blendingEnabled, partialTicks);
        vehicle.world.beginProfiling("PartHoloboxes", true);
        if (blendingEnabled) {
            WrapperPlayer player = InterfaceClient.getClientPlayer();
            AItemBase heldItem = player.getHeldItem();
            AItemPart heldPart = heldItem instanceof AItemPart ? (AItemPart)heldItem : null;
            boolean holdingScanner = player.isHoldingItemType(JSONItem.ItemComponentType.SCANNER);
            if (heldPart != null || holdingScanner) {
                GL11.glPushMatrix();
                GL11.glRotated((double)(-vehicle.angles.z), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)(-vehicle.angles.x), (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(-vehicle.angles.y), (double)0.0, (double)1.0, (double)0.0);
                if (holdingScanner) {
                    for (Map.Entry partSlotEntry : vehicle.allPartSlotBoxes.entrySet()) {
                        BoundingBox box = (BoundingBox)partSlotEntry.getKey();
                        JSONPartDefinition placementDefinition = (JSONPartDefinition)partSlotEntry.getValue();
                        if (vehicle.areVariablesBlocking(placementDefinition, player) || placementDefinition.validSubNames != null && !placementDefinition.validSubNames.contains(vehicle.subName)) continue;
                        RenderableObject renderable = (RenderableObject)vehicle.allPartSlotRenderables.get(box);
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(box.globalCenter.x - vehicle.position.x), (double)(box.globalCenter.y - vehicle.position.y), (double)(box.globalCenter.z - vehicle.position.z));
                        renderable.setHolographicBoundingBox(box);
                        renderable.color.setTo(ColorRGB.BLUE);
                        renderable.render();
                        GL11.glPopMatrix();
                    }
                } else {
                    for (Map.Entry partSlotEntry : vehicle.activePartSlotBoxes.entrySet()) {
                        BoundingBox box;
                        RenderableObject renderable;
                        boolean isHoldingCorrectTypePart = false;
                        boolean isHoldingCorrectParamPart = false;
                        if (heldPart.isPartValidForPackDef((JSONPartDefinition)partSlotEntry.getValue(), vehicle.subName, false)) {
                            isHoldingCorrectTypePart = true;
                            if (heldPart.isPartValidForPackDef((JSONPartDefinition)partSlotEntry.getValue(), vehicle.subName, true)) {
                                isHoldingCorrectParamPart = true;
                            }
                        }
                        if (!isHoldingCorrectTypePart || (renderable = (RenderableObject)vehicle.allPartSlotRenderables.get(box = (BoundingBox)partSlotEntry.getKey())) == null) continue;
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(box.globalCenter.x - vehicle.position.x), (double)(box.globalCenter.y - vehicle.position.y), (double)(box.globalCenter.z - vehicle.position.z));
                        renderable.setHolographicBoundingBox(box);
                        renderable.color.setTo(isHoldingCorrectParamPart ? ColorRGB.GREEN : ColorRGB.RED);
                        renderable.render();
                        GL11.glPopMatrix();
                    }
                }
                GL11.glPopMatrix();
            }
        }
        vehicle.world.endProfiling();
    }

    @Override
    protected void renderBoundingBoxes(EntityVehicleF_Physics vehicle, Point3d entityPositionDelta) {
        super.renderBoundingBoxes(vehicle, entityPositionDelta);
        for (BoundingBox box : vehicle.groundDeviceCollective.getGroundBounds()) {
            Point3d boxCenterDelta = box.globalCenter.copy().subtract(vehicle.position).add(entityPositionDelta);
            GL11.glTranslated((double)boxCenterDelta.x, (double)boxCenterDelta.y, (double)boxCenterDelta.z);
            box.renderable.color.setTo(ColorRGB.BLUE);
            box.renderable.setWireframeBoundingBox(box);
            box.renderable.render();
            GL11.glTranslated((double)(-boxCenterDelta.x), (double)(-boxCenterDelta.y), (double)(-boxCenterDelta.z));
        }
    }
}

