/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.sound.DecodedFile;
import minecrafttransportsimulator.sound.IStreamDecoder;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;

public class OGGDecoder
implements IStreamDecoder {
    private final CodecJOrbis decoder;
    private final DecoderThread decoderThread;
    private final ConcurrentLinkedQueue<SoundBuffer> decoderOutputBuffers = new ConcurrentLinkedQueue();
    private final ByteBuffer decodedDataBuffer;
    private final boolean isStereo;
    private final int sampleRate;
    private static final URLStreamHandler resourceStreamHandler = new ResourceStreamHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OGGDecoder(URL soundURL) {
        this.decoder = new CodecJOrbis();
        this.decoder.initialize(soundURL);
        this.decodedDataBuffer = ByteBuffer.allocateDirect(SoundSystemConfig.getStreamingBufferSize() * 2);
        this.decoderThread = new DecoderThread();
        this.decoderThread.start();
        DecoderThread decoderThread = this.decoderThread;
        synchronized (decoderThread) {
            try {
                this.decoderThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isStereo = this.decoderOutputBuffers.peek().audioFormat.getChannels() == 2;
        this.sampleRate = (int)this.decoderOutputBuffers.peek().audioFormat.getSampleRate();
    }

    @Override
    public ByteBuffer readBlock() {
        SoundBuffer decodedOutputBuffer = this.decoderOutputBuffers.poll();
        this.decodedDataBuffer.clear();
        if (decodedOutputBuffer != null) {
            this.decodedDataBuffer.clear();
            return (ByteBuffer)this.decodedDataBuffer.put(decodedOutputBuffer.audioData).flip();
        }
        return null;
    }

    @Override
    public void stop() {
        this.decoderThread.radioPlaying = false;
    }

    @Override
    public boolean isStereo() {
        return this.isStereo;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    public static DecodedFile parseInternalFile(String soundName) {
        try {
            CodecJOrbis decoder = new CodecJOrbis();
            URL soundURL = new URL(null, "mtssounds:" + soundName + ".ogg", resourceStreamHandler);
            decoder.initialize(soundURL);
            SoundBuffer decoderOutput = decoder.readAll();
            ByteBuffer decoderData = (ByteBuffer)ByteBuffer.allocateDirect(decoderOutput.audioData.length).put(decoderOutput.audioData).flip();
            return new DecodedFile(decoderOutput.audioFormat.getChannels() == 2, (int)decoderOutput.audioFormat.getSampleRate(), decoderData);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ResourceStreamHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(final URL connection) {
            return new URLConnection(connection){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    String soundName = connection.getFile();
                    String soundDomain = soundName.substring(0, soundName.indexOf(58));
                    soundName = soundName.substring(soundDomain.length() + 1);
                    return OGGDecoder.class.getResourceAsStream("/assets/" + soundDomain + "/sounds/" + soundName);
                }
            };
        }
    }

    private class DecoderThread
    extends Thread {
        private boolean radioPlaying = true;

        private DecoderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.radioPlaying && !OGGDecoder.this.decoder.endOfStream()) {
                SoundBuffer buffer;
                while (OGGDecoder.this.decoderOutputBuffers.size() < 5 && (buffer = OGGDecoder.this.decoder.read()) != null) {
                    OGGDecoder.this.decoderOutputBuffers.add(buffer);
                }
                DecoderThread decoderThread = OGGDecoder.this.decoderThread;
                synchronized (decoderThread) {
                    OGGDecoder.this.decoderThread.notify();
                    try {
                        DecoderThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            OGGDecoder.this.decoder.cleanup();
        }
    }
}

