/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javazoom.jl.decoder.Equalizer;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.InterfaceSound;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.MP3Decoder;
import minecrafttransportsimulator.sound.OGGDecoder;
import minecrafttransportsimulator.sound.RadioManager;

public class RadioStation {
    private final RadioManager.RadioSources source;
    private final int index;
    private final boolean randomOrder;
    private final String url;
    private final List<File> musicFiles;
    private final Set<EntityRadio> queuedRadios = new HashSet<EntityRadio>();
    private final Set<EntityRadio> playingRadios = new HashSet<EntityRadio>();
    public String displayText = "";
    public final Equalizer equalizer;
    private volatile List<Integer> activeBuffers = new ArrayList<Integer>();
    private volatile IStreamDecoder decoder;
    private volatile DecoderThread decoderThread;

    public RadioStation(int index, boolean randomOrder) {
        this.source = RadioManager.RadioSources.LOCAL;
        this.equalizer = new Equalizer();
        this.index = index;
        this.randomOrder = randomOrder;
        this.url = null;
        this.musicFiles = RadioManager.parseLocalDirectory(index, randomOrder);
        if (this.musicFiles.isEmpty()) {
            this.displayText = "Fewer than " + (index + 1) + " folders in mts_music.\nGo add some!";
        }
        InterfaceSound.addRadioStation(this);
    }

    public RadioStation(String url) {
        this.source = RadioManager.RadioSources.INTERNET;
        this.equalizer = new Equalizer();
        this.index = 0;
        this.randomOrder = false;
        this.url = url;
        if (url.isEmpty()) {
            this.displayText = "No station set for this preset.  Press SET to teach a station.";
        }
        this.musicFiles = new ArrayList<File>();
        InterfaceSound.addRadioStation(this);
    }

    private int generateBufferIndex() {
        ByteBuffer buffer = this.decoder.readBlock();
        if (buffer != null) {
            int bufferIndex = InterfaceSound.createBuffer(buffer, this.decoder);
            this.activeBuffers.add(bufferIndex);
            this.displayText = this.displayText.substring(0, this.displayText.indexOf("Buffers:") + "Buffers:".length());
            for (int i = 0; i < this.activeBuffers.size(); i = (int)((byte)(i + 1))) {
                this.displayText = this.displayText + "X";
            }
            return bufferIndex;
        }
        return 0;
    }

    public void addRadio(EntityRadio radio) {
        this.queuedRadios.add(radio);
    }

    public void removeRadio(EntityRadio radio) {
        this.playingRadios.remove(radio);
        this.queuedRadios.remove(radio);
    }

    public void update() {
        if (!this.playingRadios.isEmpty() || !this.queuedRadios.isEmpty()) {
            if (this.decoderThread == null && this.decoder == null) {
                this.startPlayback();
            } else if (this.decoderThread == null) {
                int newIndex;
                int freeBufferIndex = 0;
                if (!this.playingRadios.isEmpty() && (freeBufferIndex = InterfaceSound.getFreeStationBuffer(this.playingRadios)) != 0) {
                    this.activeBuffers.remove(this.activeBuffers.indexOf(freeBufferIndex));
                    InterfaceSound.deleteBuffer(freeBufferIndex);
                }
                if ((freeBufferIndex != 0 || this.playingRadios.isEmpty()) && !this.queuedRadios.isEmpty()) {
                    for (EntityRadio radio : this.queuedRadios) {
                        radio.start();
                        InterfaceSound.addRadioSound(radio.getPlayingSound(), this.activeBuffers);
                        this.playingRadios.add(radio);
                    }
                    this.queuedRadios.clear();
                }
                if (this.activeBuffers.size() < 5 && (newIndex = this.generateBufferIndex()) != 0) {
                    for (EntityRadio radio : this.playingRadios) {
                        InterfaceSound.bindBuffer(radio.getPlayingSound(), newIndex);
                    }
                }
                if (this.activeBuffers.isEmpty()) {
                    this.startPlayback();
                }
            }
        } else if (!this.source.equals((Object)RadioManager.RadioSources.LOCAL) && this.decoder != null) {
            this.decoder.stop();
            this.decoder = null;
        }
    }

    private void startPlayback() {
        for (int buffer : this.activeBuffers) {
            InterfaceSound.deleteBuffer(buffer);
        }
        this.activeBuffers.clear();
        this.queuedRadios.addAll(this.playingRadios);
        this.playingRadios.clear();
        if (this.source.equals((Object)RadioManager.RadioSources.LOCAL)) {
            if (this.musicFiles.isEmpty()) {
                this.musicFiles.addAll(RadioManager.parseLocalDirectory(this.index, this.randomOrder));
            }
            this.playFromLocalFiles();
        } else {
            if (!this.url.isEmpty() && this.playFromInternet()) {
                return;
            }
            this.queuedRadios.clear();
        }
    }

    private void playFromLocalFiles() {
        Iterator<File> iterator = this.musicFiles.iterator();
        while (iterator.hasNext()) {
            try {
                File musicFile = iterator.next();
                if (!musicFile.getName().toLowerCase().endsWith(".mp3")) {
                    iterator.remove();
                    continue;
                }
                this.displayText = "Station: " + this.musicFiles.get(0).getParentFile().getName() + "\nNow Playing: " + this.musicFiles.get(0).getName();
                this.displayText = this.displayText + "\nBuffers:";
                this.decoder = null;
                this.decoderThread = new DecoderThread(this, this.musicFiles.get(0));
                this.decoderThread.start();
                iterator.remove();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                iterator.remove();
            }
        }
    }

    private boolean playFromInternet() {
        try {
            URL urlObj = new URL(this.url);
            URLConnection connection = urlObj.openConnection();
            String contentType = connection.getHeaderField("Content-Type");
            if (contentType == null) {
                this.displayText = "ERROR: No Content-Type header found.  Contact the mod author for more information.";
                return false;
            }
            switch (contentType) {
                case "audio/mpeg": {
                    break;
                }
                case "application/ogg": {
                    break;
                }
                case "audio/x-wav": {
                    this.displayText = "ERROR: WAV file format not supported...yet.  Contact the mod author.";
                    return false;
                }
                case "audio/flac": {
                    this.displayText = "ERROR: Who the heck streams in FLAC?  Contact the mod author.";
                    return false;
                }
                default: {
                    this.displayText = contentType.startsWith("audio") ? "ERROR: Unsupported audio format of " + contentType + ".  Contact the mod author." : "ERROR: Format " + contentType + " is NOT an audio format.  Is this really a music URL?";
                    return false;
                }
            }
            this.displayText = "Name: " + (connection.getHeaderField("icy-name") != null ? connection.getHeaderField("icy-name") : "");
            this.displayText = this.displayText + "\nDesc: " + (connection.getHeaderField("icy-description") != null ? connection.getHeaderField("icy-description") : "");
            this.displayText = this.displayText + "\nGenre: " + (connection.getHeaderField("icy-genre") != null ? connection.getHeaderField("icy-genre") : "");
            this.displayText = this.displayText + "\nBuffers:";
            this.decoder = null;
            this.decoderThread = new DecoderThread(this, contentType, urlObj);
            this.decoderThread.start();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayText = "ERROR: Unable to open URL.  Have you tried playing it in another application first?";
            return false;
        }
    }

    public static class DecoderThread
    extends Thread {
        private final RadioStation station;
        private final String contentType;
        private final URL contentURL;
        private final File contentFile;

        public DecoderThread(RadioStation station, String contentType, URL contentURL) {
            this.station = station;
            this.contentType = contentType;
            this.contentURL = contentURL;
            this.contentFile = null;
        }

        public DecoderThread(RadioStation station, File contentFile) {
            this.station = station;
            this.contentType = null;
            this.contentURL = null;
            this.contentFile = contentFile;
        }

        @Override
        public void run() {
            try {
                if (this.contentURL != null) {
                    switch (this.contentType) {
                        case "audio/mpeg": {
                            this.station.decoder = new MP3Decoder(this.contentURL.openStream(), this.station.equalizer);
                            break;
                        }
                        case "application/ogg": {
                            this.station.decoder = new OGGDecoder(this.contentURL);
                        }
                    }
                } else {
                    this.station.decoder = new MP3Decoder(new FileInputStream(this.contentFile), this.station.equalizer);
                }
                for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                    this.station.generateBufferIndex();
                }
                this.station.decoderThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

