/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.jsondefs.JSONSound;

public class SoundInstance {
    public final AEntityB_Existing entity;
    public final String soundName;
    public final JSONSound soundDef;
    public final EntityRadio radio;
    public final Point3d position;
    public int sourceIndex;
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public boolean stopSound = false;

    public SoundInstance(AEntityB_Existing entity, String soundName) {
        this(entity, soundName, null, null);
    }

    public SoundInstance(AEntityB_Existing entity, JSONSound soundDef) {
        this(entity, soundDef.name, soundDef, null);
    }

    public SoundInstance(AEntityB_Existing entity, String soundName, JSONSound soundDef, EntityRadio radio) {
        this.entity = entity;
        this.soundName = soundName;
        this.soundDef = soundDef;
        this.radio = radio;
        this.position = entity.position.copy();
    }

    public void updatePosition() {
        if (this.soundDef != null && this.soundDef.pos != null) {
            this.position.setTo(this.soundDef.pos).rotateFine(this.entity.angles).add(this.entity.position);
        } else {
            this.position.setTo(this.entity.position);
        }
    }
}

