/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;

public class CameraSystem {
    private static int zoomLevel;
    private static boolean enableCustomCameras;
    public static boolean runningCustomCameras;
    private static int customCameraIndex;
    private static float currentFOV;
    public static String customCameraOverlay;

    public static void changeCameraZoom(boolean zoomIn) {
        if (zoomIn && zoomLevel > 0) {
            zoomLevel -= 2;
        } else if (!zoomIn) {
            zoomLevel += 2;
        }
    }

    public static boolean adjustCamera(WrapperPlayer player, Point3d cameraPosition, Point3d cameraRotation, float partialTicks) {
        AEntityE_Interactable<?> ridingEntity = player.getEntityRiding();
        AEntityF_Multipart multipart = ridingEntity instanceof AEntityF_Multipart ? (AEntityF_Multipart)ridingEntity : null;
        PartSeat sittingSeat = multipart != null ? (PartSeat)multipart.getPartAtLocation((Point3d)multipart.locationRiderMap.inverse().get((Object)player)) : null;
        EntityPlayerGun playerGunEntity = EntityPlayerGun.playerClientGuns.get(player.getID());
        if (InterfaceClient.inFirstPerson()) {
            if (playerGunEntity != null && playerGunEntity.activeGun != null && sittingSeat == null) {
                enableCustomCameras = playerGunEntity.activeGun.isHandHeldGunAimed;
                customCameraIndex = 0;
            }
            if (!enableCustomCameras && sittingSeat != null && sittingSeat.placementDefinition.forceCameras) {
                enableCustomCameras = true;
                customCameraIndex = 0;
            }
            if (enableCustomCameras) {
                runningCustomCameras = true;
                int camerasChecked = 0;
                JSONCameraObject camera = null;
                AEntityE_Interactable cameraProvider = null;
                if (multipart != null) {
                    if (((AJSONPartProvider)multipart.definition).rendering.cameraObjects != null) {
                        for (JSONCameraObject jSONCameraObject : ((AJSONPartProvider)multipart.definition).rendering.cameraObjects) {
                            if (!CameraSystem.isCameraActive(jSONCameraObject, multipart, partialTicks) || camerasChecked++ != customCameraIndex) continue;
                            camera = jSONCameraObject;
                            cameraProvider = multipart;
                            break;
                        }
                    }
                    for (APart aPart : multipart.parts) {
                        if (((JSONPart)aPart.definition).rendering != null && ((JSONPart)aPart.definition).rendering.cameraObjects != null) {
                            for (JSONCameraObject testCamera : ((JSONPart)aPart.definition).rendering.cameraObjects) {
                                if (!CameraSystem.isCameraActive(testCamera, aPart, partialTicks) || camerasChecked++ != customCameraIndex) continue;
                                camera = testCamera;
                                cameraProvider = aPart;
                                break;
                            }
                        }
                        if (camera == null) continue;
                        break;
                    }
                } else if (playerGunEntity != null && playerGunEntity.activeGun != null && ((JSONPart)playerGunEntity.activeGun.definition).rendering != null && ((JSONPart)playerGunEntity.activeGun.definition).rendering.cameraObjects != null) {
                    for (JSONCameraObject jSONCameraObject : ((JSONPart)playerGunEntity.activeGun.definition).rendering.cameraObjects) {
                        if (!CameraSystem.isCameraActive(jSONCameraObject, playerGunEntity, partialTicks) || camerasChecked++ != customCameraIndex) continue;
                        camera = jSONCameraObject;
                        cameraProvider = playerGunEntity;
                        break;
                    }
                }
                if (camera != null) {
                    String string = customCameraOverlay = camera.overlay != null ? camera.overlay + ".png" : null;
                    if (camera.animations != null) {
                        boolean inhibitAnimations = false;
                        for (JSONAnimationDefinition animation : camera.animations) {
                            double variableValue = cameraProvider.getAnimatedVariableValue(cameraProvider.animationClocks.get(animation), partialTicks);
                            switch (animation.animationType) {
                                case TRANSLATION: {
                                    if (inhibitAnimations || variableValue == 0.0) break;
                                    Point3d translationAmount = animation.axis.copy().multiply(variableValue).rotateFine(cameraRotation);
                                    cameraPosition.add(translationAmount);
                                    break;
                                }
                                case ROTATION: {
                                    if (inhibitAnimations || variableValue == 0.0) break;
                                    Point3d rotationAmount = animation.axis.copy().multiply(variableValue);
                                    Point3d rotationOffset = camera.pos.copy().subtract(animation.centerPoint);
                                    if (!rotationOffset.isZero()) {
                                        cameraPosition.subtract(rotationOffset).add(rotationOffset.rotateFine(rotationAmount));
                                    }
                                    cameraRotation.add(rotationAmount);
                                    break;
                                }
                                case SCALING: {
                                    break;
                                }
                                case VISIBILITY: {
                                    break;
                                }
                                case INHIBITOR: {
                                    if (!(variableValue >= (double)animation.clampMin) || !(variableValue <= (double)animation.clampMax)) break;
                                    inhibitAnimations = true;
                                    break;
                                }
                                case ACTIVATOR: {
                                    if (!(variableValue >= (double)animation.clampMin) || !(variableValue <= (double)animation.clampMax)) break;
                                    inhibitAnimations = false;
                                }
                            }
                        }
                    }
                    Point3d entityAnglesDelta = cameraProvider.prevAngles.getInterpolatedPoint(cameraProvider.angles, partialTicks);
                    cameraRotation.add(entityAnglesDelta);
                    cameraPosition.add(camera.pos).rotateFine(entityAnglesDelta);
                    if (camera.rot != null) {
                        cameraRotation.add(camera.rot);
                    }
                    Point3d point3d = cameraProvider.prevPosition.getInterpolatedPoint(cameraProvider.position, partialTicks);
                    point3d.subtract(player.getRenderedPosition(partialTicks).add(0.0, player.getEyeHeight(), 0.0));
                    cameraPosition.add(point3d);
                    if (camera.fovOverride != 0.0f) {
                        if (currentFOV == 0.0f) {
                            currentFOV = InterfaceClient.getFOV();
                        }
                        InterfaceClient.setFOV(camera.fovOverride);
                    }
                    return true;
                }
            } else if (sittingSeat != null) {
                double pitchAngle;
                double playerYawDelta = (360.0 + (multipart.angles.y - (double)player.getYaw()) % 360.0) % 360.0;
                if (playerYawDelta > 180.0) {
                    playerYawDelta -= 360.0;
                }
                double d = multipart.prevAngles.z + (multipart.angles.z - multipart.prevAngles.z) * (double)partialTicks;
                for (pitchAngle = multipart.prevAngles.x + (multipart.angles.x - multipart.prevAngles.x) * (double)partialTicks; pitchAngle > 180.0; pitchAngle -= 360.0) {
                }
                while (pitchAngle < -180.0) {
                    pitchAngle += 360.0;
                }
                while (d > 180.0) {
                    d -= 360.0;
                }
                while (d < -180.0) {
                    d += 360.0;
                }
                double rollRollComponent = Math.cos(Math.toRadians(playerYawDelta)) * d;
                double pitchRollComponent = -Math.sin(Math.toRadians(playerYawDelta)) * pitchAngle;
                cameraRotation.z = rollRollComponent + pitchRollComponent;
            }
            enableCustomCameras = false;
            runningCustomCameras = false;
        } else if (InterfaceClient.inThirdPerson()) {
            if (runningCustomCameras) {
                ++customCameraIndex;
                InterfaceClient.toggleFirstPerson();
            } else if (sittingSeat != null) {
                enableCustomCameras = true;
                customCameraIndex = 0;
                cameraPosition.set(-sittingSeat.localOffset.x, 0.0, zoomLevel);
            }
        } else if (sittingSeat != null) {
            if (((AJSONPartProvider)multipart.definition).rendering.cameraObjects != null) {
                InterfaceClient.toggleFirstPerson();
            } else {
                for (APart part : multipart.parts) {
                    if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.cameraObjects == null) continue;
                    InterfaceClient.toggleFirstPerson();
                    break;
                }
            }
            cameraPosition.set(-sittingSeat.localOffset.x, 0.0, -zoomLevel);
        }
        customCameraOverlay = null;
        if (currentFOV != 0.0f) {
            InterfaceClient.setFOV(currentFOV);
            currentFOV = 0.0f;
        }
        return false;
    }

    private static boolean isCameraActive(JSONCameraObject camera, AEntityD_Definable<?> entity, float partialTicks) {
        if (camera.animations != null) {
            for (JSONAnimationDefinition animation : camera.animations) {
                double value;
                if (!animation.animationType.equals((Object)JSONAnimationDefinition.AnimationComponentType.VISIBILITY) || !((value = entity.getAnimatedVariableValue(entity.animationClocks.get(animation), partialTicks)) < (double)animation.clampMin) && !(value > (double)animation.clampMax)) continue;
                return false;
            }
        }
        return true;
    }
}

