/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.jsondefs.JSONCraftingOverrides;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.PackParserSystem;

public final class ConfigSystem {
    private static File configFile;
    private static File craftingFile;
    public static JSONConfig configObject;

    public static void loadFromDisk(File configDirectory) {
        configFile = new File(configDirectory, "mtsconfig.json");
        craftingFile = new File(configFile.getParentFile(), "mtscraftingoverrides.json");
        if (configFile.exists()) {
            try {
                configObject = JSONParser.parseStream(new FileReader(configFile), JSONConfig.class, null, null);
            }
            catch (Exception e) {
                InterfaceCore.logError("ConfigSystem failed to parse config file JSON.  Reverting to defauts.");
                InterfaceCore.logError(e.getMessage());
            }
        }
        if (configObject == null) {
            configObject = new JSONConfig();
        }
        ConfigSystem.saveToDisk();
        File oldConfigFile = new File(configDirectory, "mts.cfg");
        if (oldConfigFile.exists()) {
            oldConfigFile.delete();
        }
    }

    public static void initCraftingOverrides() {
        if (((Boolean)ConfigSystem.configObject.general.dumpCraftingConfig.value).booleanValue()) {
            try {
                FileWriter writer = new FileWriter(craftingFile);
                JSONCraftingOverrides craftingOverridesObject = new JSONCraftingOverrides();
                craftingOverridesObject.overrides = new LinkedHashMap<String, Map<String, List<String>>>();
                for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
                    if (!craftingOverridesObject.overrides.containsKey(((AJSONItem)packItem.definition).packID)) {
                        craftingOverridesObject.overrides.put(((AJSONItem)packItem.definition).packID, new LinkedHashMap());
                    }
                    if (packItem instanceof AItemSubTyped) {
                        ArrayList<String> materials = new ArrayList<String>();
                        materials.addAll(((AJSONItem)packItem.definition).general.materials);
                        materials.addAll(((AItemSubTyped)packItem).getExtraMaterials());
                        craftingOverridesObject.overrides.get(((AJSONItem)packItem.definition).packID).put(((AJSONItem)packItem.definition).systemName + ((AItemSubTyped)packItem).subName, materials);
                    } else {
                        craftingOverridesObject.overrides.get(((AJSONItem)packItem.definition).packID).put(((AJSONItem)packItem.definition).systemName, ((AJSONItem)packItem.definition).general.materials);
                    }
                    if (((AJSONItem)packItem.definition).general.repairMaterials == null) continue;
                    craftingOverridesObject.overrides.get(((AJSONItem)packItem.definition).packID).put(((AJSONItem)packItem.definition).systemName + "_repair", ((AJSONItem)packItem.definition).general.repairMaterials);
                }
                JSONParser.exportStream(craftingOverridesObject, writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                InterfaceCore.logError("ConfigSystem failed to create fresh crafting overrides file.  Report to the mod author!");
            }
        } else if (craftingFile.exists()) {
            try {
                JSONCraftingOverrides craftingOverridesObject = (JSONCraftingOverrides)new Gson().fromJson((Reader)new FileReader(craftingFile), JSONCraftingOverrides.class);
                for (String craftingOverridePackID : craftingOverridesObject.overrides.keySet()) {
                    for (String craftingOverrideSystemName : craftingOverridesObject.overrides.get(craftingOverridePackID).keySet()) {
                        Object item = PackParserSystem.getItem(craftingOverridePackID, craftingOverrideSystemName);
                        if (item instanceof AItemSubTyped) {
                            List<String> extraMaterials = ((AItemSubTyped)item).getExtraMaterials();
                            extraMaterials.clear();
                            extraMaterials.addAll((Collection<String>)craftingOverridesObject.overrides.get(craftingOverridePackID).get(craftingOverrideSystemName));
                            ((AJSONItem)((AItemPack)item).definition).general.materials.clear();
                            continue;
                        }
                        if (item == null) continue;
                        ((AJSONItem)((AItemPack)item).definition).general.materials = craftingOverridesObject.overrides.get(craftingOverridePackID).get(craftingOverrideSystemName);
                        ((AJSONItem)((AItemPack)item).definition).general.repairMaterials = craftingOverridesObject.overrides.get(craftingOverridePackID).get(craftingOverrideSystemName + "_repair");
                    }
                }
            }
            catch (Exception e) {
                InterfaceCore.logError("ConfigSystem failed to parse crafting override file JSON.  Crafting overrides will not be applied.");
                InterfaceCore.logError(e.getMessage());
            }
        }
    }

    public static void saveToDisk() {
        try {
            FileWriter writer = new FileWriter(configFile);
            JSONParser.exportStream(configObject, writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            InterfaceCore.logError("ConfigSystem failed to save modified config file.  Report to the mod author!");
        }
    }
}

