/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPanelAircraft;
import minecrafttransportsimulator.guis.instances.GUIPanelGround;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class ControlSystem {
    private static final int NULL_COMPONENT = 999;
    private static boolean joysticksInhibited = false;
    private static WrapperPlayer clientPlayer;

    public static void controlPlayerGun(EntityPlayerGun entity) {
        if (entity.activeGun != null) {
            InterfacePacket.sendToServer(new PacketPartGun(entity.activeGun, InterfaceInput.isLeftMouseButtonDown() && !entity.player.isSpectator(), InterfaceInput.isRightMouseButtonDown()));
        }
    }

    public static void controlVehicle(EntityVehicleF_Physics vehicle, boolean isPlayerController) {
        clientPlayer = InterfaceClient.getClientPlayer();
        if (((JSONVehicle)vehicle.definition).motorized.isAircraft) {
            ControlSystem.controlAircraft(vehicle, isPlayerController);
        } else {
            ControlSystem.controlGroundVehicle(vehicle, isPlayerController);
        }
    }

    private static void controlCamera(ControlsKeyboard camLock, ControlsKeyboard zoomIn, ControlsKeyboard zoomOut, ControlsJoystick changeView) {
        if (camLock.isPressed()) {
            boolean bl = EntityVehicleF_Physics.lockCameraToMovement = !EntityVehicleF_Physics.lockCameraToMovement;
        }
        if (zoomIn.isPressed()) {
            CameraSystem.changeCameraZoom(true);
        }
        if (zoomOut.isPressed()) {
            CameraSystem.changeCameraZoom(false);
        }
        if (changeView.isPressed()) {
            InterfaceClient.toggleFirstPerson();
        }
    }

    private static void rotateCamera(ControlsJoystick lookR, ControlsJoystick lookL, ControlsJoystick lookU, ControlsJoystick lookD, ControlsJoystick lookA) {
        float pollData;
        if (lookR.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
        }
        if (lookL.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
        }
        if (lookU.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
        }
        if (lookD.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
        }
        if ((pollData = lookA.getMultistateValue()) != 0.0f) {
            if (pollData >= 0.125f && pollData <= 0.375f) {
                clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
            }
            if (pollData >= 0.375f && pollData <= 0.625f) {
                clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
            }
            if (pollData >= 0.625f && pollData <= 0.875f) {
                clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
            }
            if (pollData >= 0.875f || pollData <= 0.125f) {
                clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
            }
        }
    }

    private static void controlBrake(EntityVehicleF_Physics vehicle, ControlsKeyboardDynamic brakeMod, ControlsJoystick brakeJoystick, ControlsJoystick brakeButton, ControlsJoystick pBrake) {
        double brakeValue;
        boolean isParkingBrakePressed;
        boolean bl = InterfaceInput.isJoystickPresent(brakeJoystick.config.joystickName) ? pBrake.isPressed() : (isParkingBrakePressed = brakeMod.isPressed() || pBrake.isPressed());
        double d = InterfaceInput.isJoystickPresent(brakeJoystick.config.joystickName) ? brakeJoystick.getAxisState(true) : (brakeValue = brakeMod.mainControl.isPressed() || brakeButton.isPressed() ? 1.0 : 0.0);
        if (isParkingBrakePressed ? !vehicle.parkingBrakeOn : brakeValue > 0.0 && vehicle.parkingBrakeOn) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(vehicle, "p_brake"));
        }
        InterfacePacket.sendToServer(new PacketEntityVariableSet(vehicle, "brake", brakeValue));
    }

    private static void controlGun(EntityVehicleF_Physics vehicle, ControlsKeyboard gunTrigger, ControlsKeyboard gunSwitch) {
        boolean gunSwitchPressedThisScan = gunSwitch.isPressed();
        for (APart part : vehicle.parts) {
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                if (!InterfaceClient.getClientPlayer().equals(gun.getController())) continue;
                InterfacePacket.sendToServer(new PacketPartGun(gun, gunTrigger.isPressed(), false));
                continue;
            }
            if (!(part instanceof PartSeat) || !gunSwitchPressedThisScan || !InterfaceClient.getClientPlayer().equals(vehicle.locationRiderMap.get((Object)part.placementOffset))) continue;
            InterfacePacket.sendToServer(new PacketPartSeat((PartSeat)part));
        }
    }

    private static void controlRadio(EntityVehicleF_Physics vehicle, ControlsKeyboard radio) {
        if (radio.isPressed()) {
            if (AGUIBase.activeInputGUI instanceof GUIRadio) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceClient.isGUIOpen()) {
                new GUIRadio(vehicle.radio);
            }
        }
    }

    private static void controlJoystick(EntityVehicleF_Physics vehicle, ControlsKeyboard joystickInhibit) {
        if (joystickInhibit.isPressed()) {
            joysticksInhibited = !joysticksInhibited;
            InterfaceInput.inhibitJoysticks(joysticksInhibited);
        }
    }

    private static void controlControlSurface(EntityVehicleF_Physics vehicle, ControlsJoystick axis, ControlsKeyboard increment, ControlsKeyboard decrement, double rate, double bounds, String variable, double currentValue) {
        if (InterfaceInput.isJoystickPresent(axis.config.joystickName)) {
            double axisValue = axis.getAxisState(false);
            if (Double.isNaN(axisValue)) {
                InterfacePacket.sendToServer(new PacketEntityVariableSet(vehicle, variable, 0.0));
            } else {
                InterfacePacket.sendToServer(new PacketEntityVariableSet(vehicle, variable, bounds * (-1.0 + 2.0 * axisValue)));
            }
        } else if (increment.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, rate * (double)(currentValue < 0.0 ? 2 : 1), -bounds, bounds));
        } else if (decrement.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -rate * (double)(currentValue > 0.0 ? 2 : 1), -bounds, bounds));
        } else if (currentValue > 0.0) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -rate, 0.0, bounds));
        } else if (currentValue < 0.0) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, rate, -bounds, 0.0));
        }
    }

    private static void controlControlTrim(EntityVehicleF_Physics vehicle, ControlsJoystick increment, ControlsJoystick decrement, double bounds, String variable) {
        if (increment.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, 0.1, -bounds, bounds));
        } else if (decrement.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -0.1, -bounds, bounds));
        }
    }

    private static void controlAircraft(EntityVehicleF_Physics aircraft, boolean isPlayerController) {
        boolean aircraftIsAutolevel;
        ControlSystem.controlCamera(ControlsKeyboard.AIRCRAFT_CAMLOCK, ControlsKeyboard.AIRCRAFT_ZOOM_I, ControlsKeyboard.AIRCRAFT_ZOOM_O, ControlsJoystick.AIRCRAFT_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.AIRCRAFT_LOOK_R, ControlsJoystick.AIRCRAFT_LOOK_L, ControlsJoystick.AIRCRAFT_LOOK_U, ControlsJoystick.AIRCRAFT_LOOK_D, ControlsJoystick.AIRCRAFT_LOOK_A);
        ControlSystem.controlGun(aircraft, ControlsKeyboard.AIRCRAFT_GUN_FIRE, ControlsKeyboard.AIRCRAFT_GUN_SWITCH);
        ControlSystem.controlRadio(aircraft, ControlsKeyboard.AIRCRAFT_RADIO);
        ControlSystem.controlJoystick(aircraft, ControlsKeyboard.AIRCRAFT_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        if (ControlsKeyboard.AIRCRAFT_PANEL.isPressed() && aircraft.canPlayerStartEngines(clientPlayer)) {
            if (AGUIBase.activeInputGUI instanceof GUIPanelAircraft) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceClient.isGUIOpen()) {
                new GUIPanelAircraft(aircraft);
            }
        }
        ControlSystem.controlBrake(aircraft, ControlsKeyboardDynamic.AIRCRAFT_PARK, ControlsJoystick.AIRCRAFT_BRAKE, ControlsJoystick.AIRCRAFT_BRAKE_DIGITAL, ControlsJoystick.AIRCRAFT_PARK);
        if (ControlsJoystick.AIRCRAFT_REVERSE.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(aircraft, "reverser"));
        }
        if (ControlsJoystick.AIRCRAFT_GEAR.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(aircraft, "gear_setpoint"));
        }
        if (InterfaceInput.isJoystickPresent(ControlsJoystick.AIRCRAFT_THROTTLE.config.joystickName)) {
            InterfacePacket.sendToServer(new PacketEntityVariableSet(aircraft, "throttle", ControlsJoystick.AIRCRAFT_THROTTLE.getAxisState(true) * 1.0));
        } else {
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_U.isPressed()) {
                InterfacePacket.sendToServer(new PacketEntityVariableIncrement(aircraft, "throttle", 0.01, 0.0, 1.0));
            }
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_D.isPressed()) {
                InterfacePacket.sendToServer(new PacketEntityVariableIncrement(aircraft, "throttle", -0.01, 0.0, 1.0));
            }
        }
        if (((JSONVehicle)aircraft.definition).motorized.flapNotches != null && !((JSONVehicle)aircraft.definition).motorized.flapNotches.isEmpty()) {
            int currentFlapSetting = ((JSONVehicle)aircraft.definition).motorized.flapNotches.indexOf(Float.valueOf((float)aircraft.flapDesiredAngle));
            if (ControlsKeyboard.AIRCRAFT_FLAPS_D.isPressed() && currentFlapSetting + 1 < ((JSONVehicle)aircraft.definition).motorized.flapNotches.size()) {
                InterfacePacket.sendToServer(new PacketEntityVariableSet(aircraft, "flaps_setpoint", ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting + 1).floatValue()));
            } else if (ControlsKeyboard.AIRCRAFT_FLAPS_U.isPressed() && currentFlapSetting > 0) {
                InterfacePacket.sendToServer(new PacketEntityVariableSet(aircraft, "flaps_setpoint", ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting - 1).floatValue()));
            }
        }
        ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_YAW, ControlsKeyboard.AIRCRAFT_YAW_R, ControlsKeyboard.AIRCRAFT_YAW_L, (Double)ConfigSystem.configObject.clientControls.steeringControlRate.value, 45.0, "rudder", aircraft.rudderAngle);
        ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_YAW_R, ControlsJoystick.AIRCRAFT_TRIM_YAW_L, 10.0, "trim_rudder");
        if (((Boolean)ConfigSystem.configObject.clientControls.mouseYoke.value).booleanValue()) {
            if (EntityVehicleF_Physics.lockCameraToMovement && AGUIBase.activeInputGUI == null) {
                long mouseDelta = InterfaceInput.getMouseDelta();
                double deltaAileron = (Double)ConfigSystem.configObject.clientControls.flightControlRate.value * (double)((short)(mouseDelta >> 32));
                double deltaElevator = (Double)ConfigSystem.configObject.clientControls.flightControlRate.value * (double)((short)(-mouseDelta));
                InterfacePacket.sendToServer(new PacketEntityVariableIncrement(aircraft, "aileron", deltaAileron, -25.0, 25.0));
                InterfacePacket.sendToServer(new PacketEntityVariableIncrement(aircraft, "elevator", deltaElevator, -25.0, 25.0));
            }
        } else {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_PITCH, ControlsKeyboard.AIRCRAFT_PITCH_U, ControlsKeyboard.AIRCRAFT_PITCH_D, (Double)ConfigSystem.configObject.clientControls.flightControlRate.value, 25.0, "elevator", aircraft.elevatorAngle);
            ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_PITCH_U, ControlsJoystick.AIRCRAFT_TRIM_PITCH_D, 10.0, "trim_elevator");
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_ROLL, ControlsKeyboard.AIRCRAFT_ROLL_R, ControlsKeyboard.AIRCRAFT_ROLL_L, (Double)ConfigSystem.configObject.clientControls.flightControlRate.value, 25.0, "aileron", aircraft.aileronAngle);
            ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_ROLL_R, ControlsJoystick.AIRCRAFT_TRIM_ROLL_L, 10.0, "trim_aileron");
        }
        boolean bl = aircraftIsAutolevel = aircraft.getVariable("auto_level") != 0.0;
        if ((Boolean)ConfigSystem.configObject.clientControls.heliAutoLevel.value ^ aircraftIsAutolevel) {
            InterfacePacket.sendToServer(new PacketEntityVariableSet(aircraft, "auto_level", (Boolean)ConfigSystem.configObject.clientControls.heliAutoLevel.value != false ? 1.0 : 0.0));
        }
    }

    private static void controlGroundVehicle(EntityVehicleF_Physics powered, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboard.CAR_CAMLOCK, ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsJoystick.CAR_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
        ControlSystem.controlGun(powered, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        ControlSystem.controlRadio(powered, ControlsKeyboard.CAR_RADIO);
        ControlSystem.controlJoystick(powered, ControlsKeyboard.CAR_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        if (ControlsKeyboard.CAR_PANEL.isPressed() && powered.canPlayerStartEngines(clientPlayer)) {
            if (AGUIBase.activeInputGUI instanceof GUIPanelGround) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceClient.isGUIOpen()) {
                new GUIPanelGround(powered);
            }
        }
        if (((JSONVehicle)powered.definition).motorized.hasIncrementalThrottle) {
            ControlSystem.controlBrake(powered, ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsJoystick.CAR_PARK);
            if (InterfaceInput.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                double throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0;
                if (powered.autopilotSetting == 0.0 || powered.throttle < throttleLevel) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleLevel));
                }
            } else {
                if (ControlsKeyboard.CAR_GAS.isPressed()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableIncrement(powered, "throttle", 0.01, 0.0, 1.0));
                }
                if (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableIncrement(powered, "throttle", -0.01, 0.0, 1.0));
                }
            }
        } else if (((Boolean)ConfigSystem.configObject.clientControls.simpleThrottle.value).booleanValue()) {
            if (!powered.engines.values().isEmpty()) {
                byte currentGear = 0;
                for (PartEngine engine : powered.engines.values()) {
                    currentGear = engine.currentGear;
                }
                double brakeValue = 0.0;
                if (InterfaceInput.isJoystickPresent(ControlsJoystick.CAR_BRAKE.config.joystickName)) {
                    brakeValue = ControlsJoystick.CAR_BRAKE.getAxisState(true);
                } else if (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed()) {
                    brakeValue = 1.0;
                }
                double throttleValue = 0.0;
                if (InterfaceInput.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                    throttleValue = ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0;
                } else if (ControlsKeyboardDynamic.CAR_SLOW.isPressed()) {
                    throttleValue = (Boolean)ConfigSystem.configObject.clientControls.halfThrottle.value != false ? 1.0 : 0.5;
                } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
                    double d = throttleValue = (Boolean)ConfigSystem.configObject.clientControls.halfThrottle.value != false ? 0.5 : 1.0;
                }
                if (brakeValue > 0.25 && currentGear >= 0 && powered.axialVelocity < (double)0.01f) {
                    if (currentGear > 0) {
                        for (PartEngine engine : powered.engines.values()) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_neutral"));
                        }
                    } else {
                        for (PartEngine engine : powered.engines.values()) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_down"));
                        }
                    }
                } else if (throttleValue > 0.25 && currentGear <= 0 && powered.axialVelocity < (double)0.01f) {
                    if (currentGear < 0) {
                        for (PartEngine engine : powered.engines.values()) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_neutral"));
                        }
                    } else {
                        for (PartEngine engine : powered.engines.values()) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_up"));
                        }
                    }
                }
                if (throttleValue == 0.0 && brakeValue == 0.0 && powered.axialVelocity < (double)0.35f) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "brake", 1.0));
                } else if (currentGear >= 0) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "brake", brakeValue));
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleValue));
                } else {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "brake", throttleValue));
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", brakeValue));
                }
            }
        } else {
            ControlSystem.controlBrake(powered, ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsJoystick.CAR_PARK);
            if (InterfaceInput.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                double throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true);
                if (powered.autopilotSetting == 0.0 || powered.throttle < throttleLevel) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleLevel));
                }
            } else if (ControlsKeyboardDynamic.CAR_SLOW.isPressed()) {
                if (!((Boolean)ConfigSystem.configObject.clientControls.halfThrottle.value).booleanValue()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.5));
                } else {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", 1.0));
                }
            } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
                if (!((Boolean)ConfigSystem.configObject.clientControls.halfThrottle.value).booleanValue()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", 1.0));
                } else {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.5));
                }
            } else if (powered.autopilotSetting == 0.0) {
                InterfacePacket.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.0));
            }
        }
        if (!powered.lockedOnRoad) {
            if (((Boolean)ConfigSystem.configObject.clientControls.mouseYoke.value).booleanValue()) {
                if (EntityVehicleF_Physics.lockCameraToMovement && AGUIBase.activeInputGUI == null) {
                    long mouseDelta = InterfaceInput.getMouseDelta();
                    double deltaRudder = (Double)ConfigSystem.configObject.clientControls.flightControlRate.value * (double)((short)(mouseDelta >> 32));
                    InterfacePacket.sendToServer(new PacketEntityVariableIncrement(powered, "rudder", deltaRudder, -45.0, 45.0));
                }
            } else {
                ControlSystem.controlControlSurface(powered, ControlsJoystick.CAR_TURN, ControlsKeyboard.CAR_TURN_R, ControlsKeyboard.CAR_TURN_L, (Double)ConfigSystem.configObject.clientControls.steeringControlRate.value, 45.0, "rudder", powered.rudderAngle);
                if (InterfaceInput.isJoystickPresent(ControlsJoystick.CAR_TURN.config.joystickName)) {
                    if (powered.slipping) {
                        InterfaceInput.setJoystickRumble(ControlsJoystick.CAR_TURN.config.joystickName, (float)Math.max(powered.velocity, 1.0));
                    } else {
                        InterfaceInput.setJoystickRumble(ControlsJoystick.CAR_TURN.config.joystickName, 0.0f);
                    }
                }
            }
        }
        if (ControlsKeyboardDynamic.CAR_SHIFT_NU.isPressed() || ControlsKeyboardDynamic.CAR_SHIFT_ND.isPressed()) {
            for (PartEngine engine : powered.engines.values()) {
                InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_neutral"));
            }
        } else {
            if (ControlsKeyboard.CAR_SHIFT_U.isPressed()) {
                for (PartEngine engine : powered.engines.values()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_up"));
                }
            }
            if (ControlsKeyboard.CAR_SHIFT_D.isPressed()) {
                for (PartEngine engine : powered.engines.values()) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_shift_down"));
                }
            }
        }
        if (ControlsKeyboard.CAR_HORN.isPressed() && !powered.isVariableActive("horn")) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "horn"));
        } else if (!ControlsKeyboard.CAR_HORN.isPressed() && powered.isVariableActive("horn")) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "horn"));
        }
        if (ControlsKeyboard.CAR_LIGHTS.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "running_light"));
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "headlight"));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_L.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_R.isPressed()) {
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
        }
        if (((Boolean)ConfigSystem.configObject.clientControls.autoTrnSignals.value).booleanValue()) {
            if (!powered.turningLeft && powered.rudderAngle < -20.0) {
                powered.turningLeft = true;
                powered.turningCooldown = (byte)40;
                InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
            }
            if (!powered.turningRight && powered.rudderAngle > 20.0) {
                powered.turningRight = true;
                powered.turningCooldown = (byte)40;
                InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
            }
            if (powered.turningLeft && (powered.rudderAngle > 0.0 || powered.turningCooldown == 0)) {
                powered.turningLeft = false;
                InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
            }
            if (powered.turningRight && (powered.rudderAngle < 0.0 || powered.turningCooldown == 0)) {
                powered.turningRight = false;
                InterfacePacket.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
            }
            if (powered.velocity != 0.0 && powered.turningCooldown > 0 && powered.rudderAngle == 0.0) {
                powered.turningCooldown = (byte)(powered.turningCooldown - 1);
            }
        }
    }

    static {
        for (ControlsJoystick controlsJoystick : ControlsJoystick.values()) {
            ConfigSystem.configObject.controls.joystick.put(controlsJoystick.systemName, controlsJoystick.config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            ConfigSystem.configObject.controls.keyboard.put(((ControlsKeyboard)enum_).systemName, ((ControlsKeyboard)enum_).config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            if (((ControlsKeyboard)enum_).config.keyCode != 0) continue;
            ((ControlsKeyboard)enum_).config.keyCode = InterfaceInput.getKeyCodeForName(((ControlsKeyboard)enum_).defaultKeyName);
        }
        ConfigSystem.saveToDisk();
    }

    public static enum ControlsKeyboardDynamic {
        AIRCRAFT_PARK(ControlsKeyboard.AIRCRAFT_BRAKE, ControlsKeyboard.AIRCRAFT_MOD),
        CAR_PARK(ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_MOD),
        CAR_SLOW(ControlsKeyboard.CAR_GAS, ControlsKeyboard.CAR_MOD),
        CAR_SHIFT_NU(ControlsKeyboard.CAR_SHIFT_U, ControlsKeyboard.CAR_MOD),
        CAR_SHIFT_ND(ControlsKeyboard.CAR_SHIFT_D, ControlsKeyboard.CAR_MOD);

        public final String translatedName = InterfaceCore.translate("input." + this.name().toLowerCase().replaceFirst("_", "."));
        public final ControlsKeyboard mainControl;
        public final ControlsKeyboard modControl;

        private ControlsKeyboardDynamic(ControlsKeyboard mainControl, ControlsKeyboard modControl) {
            this.mainControl = mainControl;
            this.modControl = modControl;
        }

        public boolean isPressed() {
            return this.modControl.isPressed() ? this.mainControl.isPressed() : false;
        }
    }

    public static enum ControlsJoystick {
        AIRCRAFT_MOD(false, false),
        AIRCRAFT_CAMLOCK(false, true),
        AIRCRAFT_YAW(true, false),
        AIRCRAFT_PITCH(true, false),
        AIRCRAFT_ROLL(true, false),
        AIRCRAFT_THROTTLE(true, false),
        AIRCRAFT_BRAKE(true, false),
        AIRCRAFT_BRAKE_DIGITAL(false, false),
        AIRCRAFT_GEAR(false, true),
        AIRCRAFT_FLAPS_U(false, true),
        AIRCRAFT_FLAPS_D(false, true),
        AIRCRAFT_PANEL(false, true),
        AIRCRAFT_PARK(false, true),
        AIRCRAFT_RADIO(false, true),
        AIRCRAFT_GUN_FIRE(false, false),
        AIRCRAFT_GUN_SWITCH(false, true),
        AIRCRAFT_ZOOM_I(false, true),
        AIRCRAFT_ZOOM_O(false, true),
        AIRCRAFT_CHANGEVIEW(false, true),
        AIRCRAFT_LOOK_L(false, false),
        AIRCRAFT_LOOK_R(false, false),
        AIRCRAFT_LOOK_U(false, false),
        AIRCRAFT_LOOK_D(false, false),
        AIRCRAFT_LOOK_A(false, false),
        AIRCRAFT_TRIM_YAW_R(false, false),
        AIRCRAFT_TRIM_YAW_L(false, false),
        AIRCRAFT_TRIM_PITCH_U(false, false),
        AIRCRAFT_TRIM_PITCH_D(false, false),
        AIRCRAFT_TRIM_ROLL_R(false, false),
        AIRCRAFT_TRIM_ROLL_L(false, false),
        AIRCRAFT_REVERSE(false, true),
        AIRCRAFT_JS_INHIBIT(false, true),
        CAR_MOD(false, false),
        CAR_CAMLOCK(false, true),
        CAR_TURN(true, false),
        CAR_GAS(true, false),
        CAR_BRAKE(true, false),
        CAR_BRAKE_DIGITAL(false, false),
        CAR_PANEL(false, true),
        CAR_SHIFT_U(false, true),
        CAR_SHIFT_D(false, true),
        CAR_HORN(false, false),
        CAR_PARK(false, true),
        CAR_RADIO(false, true),
        CAR_GUN_FIRE(false, false),
        CAR_GUN_SWITCH(false, true),
        CAR_ZOOM_I(false, true),
        CAR_ZOOM_O(false, true),
        CAR_CHANGEVIEW(false, true),
        CAR_LOOK_L(false, false),
        CAR_LOOK_R(false, false),
        CAR_LOOK_U(false, false),
        CAR_LOOK_D(false, false),
        CAR_LOOK_A(false, false),
        CAR_LIGHTS(false, true),
        CAR_TURNSIGNAL_L(false, true),
        CAR_TURNSIGNAL_R(false, true),
        CAR_JS_INHIBIT(false, true);

        public final boolean isAxis;
        public final boolean isMomentary;
        public final String systemName;
        public final String translatedName;
        public final JSONConfig.ConfigJoystick config;
        private boolean wasPressedLastCall;

        private ControlsJoystick(boolean isAxis, boolean isMomentary) {
            this.isAxis = isAxis;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase().replaceFirst("_", ".");
            this.translatedName = InterfaceCore.translate("input." + this.systemName);
            this.config = ConfigSystem.configObject.controls.joystick.containsKey(this.systemName) ? ConfigSystem.configObject.controls.joystick.get(this.systemName) : new JSONConfig.ConfigJoystick();
        }

        public boolean isPressed() {
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = InterfaceInput.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                    return false;
                }
                this.wasPressedLastCall = InterfaceInput.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                return this.wasPressedLastCall;
            }
            return InterfaceInput.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
        }

        private float getMultistateValue() {
            return InterfaceInput.getJoystickAxisValue(this.config.joystickName, this.config.buttonIndex);
        }

        private double getAxisState(boolean ignoreDeadzone) {
            double pollValue = this.getMultistateValue();
            if (ignoreDeadzone || Math.abs(pollValue) > (Double)ConfigSystem.configObject.clientControls.joystickDeadZone.value) {
                pollValue = Math.max(this.config.axisMinTravel, pollValue);
                pollValue = Math.min(this.config.axisMaxTravel, pollValue);
                pollValue = (pollValue - this.config.axisMinTravel) / (this.config.axisMaxTravel - this.config.axisMinTravel);
                if (this.config.invertedAxis) {
                    pollValue = 1.0 - pollValue;
                }
                return pollValue;
            }
            return Double.NaN;
        }

        public void setControl(String joystickName, int buttonIndex) {
            this.config.joystickName = joystickName;
            this.config.buttonIndex = buttonIndex;
            ConfigSystem.saveToDisk();
        }

        public void setAxisControl(String joystickName, int buttonIndex, double axisMinTravel, double axisMaxTravel, boolean invertedAxis) {
            this.config.axisMinTravel = axisMinTravel;
            this.config.axisMaxTravel = axisMaxTravel;
            this.config.invertedAxis = invertedAxis;
            this.setControl(joystickName, buttonIndex);
        }

        public void clearControl() {
            this.setControl(null, 999);
        }
    }

    public static enum ControlsKeyboard {
        AIRCRAFT_MOD(ControlsJoystick.AIRCRAFT_MOD, false, "RSHIFT"),
        AIRCRAFT_CAMLOCK(ControlsJoystick.AIRCRAFT_CAMLOCK, true, "RCONTROL"),
        AIRCRAFT_YAW_R(ControlsJoystick.AIRCRAFT_YAW, false, "L"),
        AIRCRAFT_YAW_L(ControlsJoystick.AIRCRAFT_YAW, false, "J"),
        AIRCRAFT_PITCH_U(ControlsJoystick.AIRCRAFT_PITCH, false, "S"),
        AIRCRAFT_PITCH_D(ControlsJoystick.AIRCRAFT_PITCH, false, "W"),
        AIRCRAFT_ROLL_R(ControlsJoystick.AIRCRAFT_ROLL, false, "D"),
        AIRCRAFT_ROLL_L(ControlsJoystick.AIRCRAFT_ROLL, false, "A"),
        AIRCRAFT_THROTTLE_U(ControlsJoystick.AIRCRAFT_THROTTLE, false, "I"),
        AIRCRAFT_THROTTLE_D(ControlsJoystick.AIRCRAFT_THROTTLE, false, "K"),
        AIRCRAFT_FLAPS_U(ControlsJoystick.AIRCRAFT_FLAPS_U, true, "Y"),
        AIRCRAFT_FLAPS_D(ControlsJoystick.AIRCRAFT_FLAPS_D, true, "H"),
        AIRCRAFT_BRAKE(ControlsJoystick.AIRCRAFT_BRAKE, false, "B"),
        AIRCRAFT_PANEL(ControlsJoystick.AIRCRAFT_PANEL, true, "U"),
        AIRCRAFT_RADIO(ControlsJoystick.AIRCRAFT_RADIO, true, "MINUS"),
        AIRCRAFT_GUN_FIRE(ControlsJoystick.AIRCRAFT_GUN_FIRE, false, "SPACE"),
        AIRCRAFT_GUN_SWITCH(ControlsJoystick.AIRCRAFT_GUN_SWITCH, true, "V"),
        AIRCRAFT_ZOOM_I(ControlsJoystick.AIRCRAFT_ZOOM_I, true, "PRIOR"),
        AIRCRAFT_ZOOM_O(ControlsJoystick.AIRCRAFT_ZOOM_O, true, "NEXT"),
        AIRCRAFT_JS_INHIBIT(ControlsJoystick.AIRCRAFT_JS_INHIBIT, true, "SCROLL"),
        CAR_MOD(ControlsJoystick.CAR_MOD, false, "RSHIFT"),
        CAR_CAMLOCK(ControlsJoystick.CAR_CAMLOCK, true, "RCONTROL"),
        CAR_TURN_R(ControlsJoystick.CAR_TURN, false, "D"),
        CAR_TURN_L(ControlsJoystick.CAR_TURN, false, "A"),
        CAR_GAS(ControlsJoystick.CAR_GAS, false, "W"),
        CAR_BRAKE(ControlsJoystick.CAR_BRAKE, false, "S"),
        CAR_PANEL(ControlsJoystick.CAR_PANEL, true, "U"),
        CAR_SHIFT_U(ControlsJoystick.CAR_SHIFT_U, true, "R"),
        CAR_SHIFT_D(ControlsJoystick.CAR_SHIFT_D, true, "F"),
        CAR_HORN(ControlsJoystick.CAR_HORN, false, "C"),
        CAR_RADIO(ControlsJoystick.CAR_RADIO, true, "MINUS"),
        CAR_GUN_FIRE(ControlsJoystick.CAR_GUN_FIRE, false, "SPACE"),
        CAR_GUN_SWITCH(ControlsJoystick.CAR_GUN_SWITCH, true, "V"),
        CAR_ZOOM_I(ControlsJoystick.CAR_ZOOM_I, true, "PRIOR"),
        CAR_ZOOM_O(ControlsJoystick.CAR_ZOOM_O, true, "NEXT"),
        CAR_LIGHTS(ControlsJoystick.CAR_LIGHTS, true, "NUMPAD5"),
        CAR_TURNSIGNAL_L(ControlsJoystick.CAR_TURNSIGNAL_L, true, "NUMPAD4"),
        CAR_TURNSIGNAL_R(ControlsJoystick.CAR_TURNSIGNAL_R, true, "NUMPAD6"),
        CAR_JS_INHIBIT(ControlsJoystick.CAR_JS_INHIBIT, true, "SCROLL");

        public final boolean isMomentary;
        public final String systemName;
        public final String translatedName;
        public final String defaultKeyName;
        public final JSONConfig.ConfigKeyboard config;
        private final ControlsJoystick linkedJoystick;
        private boolean wasPressedLastCall;

        private ControlsKeyboard(ControlsJoystick linkedJoystick, boolean isMomentary, String defaultKeyName) {
            this.linkedJoystick = linkedJoystick;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase().replaceFirst("_", ".");
            this.translatedName = InterfaceCore.translate("input." + this.systemName);
            this.defaultKeyName = defaultKeyName;
            this.config = ConfigSystem.configObject.controls.keyboard.containsKey(this.systemName) ? ConfigSystem.configObject.controls.keyboard.get(this.systemName) : new JSONConfig.ConfigKeyboard();
        }

        public boolean isPressed() {
            if (this.linkedJoystick.isPressed()) {
                return true;
            }
            if (InterfaceInput.isJoystickPresent(this.linkedJoystick.config.joystickName) && ((Boolean)ConfigSystem.configObject.clientControls.kbOverride.value).booleanValue()) {
                return false;
            }
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = InterfaceInput.isKeyPressed(this.config.keyCode);
                    return false;
                }
                this.wasPressedLastCall = InterfaceInput.isKeyPressed(this.config.keyCode);
                return this.wasPressedLastCall;
            }
            return InterfaceInput.isKeyPressed(this.config.keyCode);
        }
    }
}

