/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.block.entity;

import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.misc.BackpackDataItems;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBackpack
extends TileEntity
implements ITickable,
IBackpack {
    private static final int DESPAWN_DISTANCE = 20;
    private static final int DESPAWN_TIME = 6000;
    public static final String TAG_AGE = "age";
    public static final String TAG_STACK = "stack";
    public static final String TAG_DATA = "data";
    public static final String TAG_FACING = "facing";
    public static final String TAG_DESPAWN_TIMER = "despawnTimer";
    private int _age = 0;
    private ItemStack _stack = ItemStack.field_190927_a;
    private IBackpackData _data = null;
    private int _playersUsing = 0;
    private int _lidTicks = 0;
    private int _prevLidTicks = 0;
    private int _despawnTimer = -1;
    public EnumFacing facing = EnumFacing.NORTH;

    public int getAge() {
        return this._age;
    }

    public void func_73660_a() {
        EntityPlayer player;
        ++this._age;
        if (this.field_145850_b.field_72995_K) {
            BackpackHelper.updateLidTicks(this, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        } else if (this._despawnTimer >= 0 && (player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 20.0, false)) == null && ++this._despawnTimer > 6000) {
            this._stack = ItemStack.field_190927_a;
            this._data = null;
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            this._playersUsing = type;
            return true;
        }
        return false;
    }

    public void setPlacedOnDeath(boolean mayDespawn) {
        this._age = -10;
        this._despawnTimer = mayDespawn ? 0 : -1;
    }

    public void readNBT(NBTTagCompound compound, boolean isClient) {
        this._age = !isClient ? compound.func_74762_e(TAG_AGE) : 0;
        this.facing = EnumFacing.func_82600_a((int)(NbtUtils.get(compound, Byte.valueOf((byte)0), TAG_FACING) + 2));
        this._stack = NbtUtils.readItem(compound.func_74775_l(TAG_STACK));
        if (this._stack.func_190926_b() || isClient) {
            this._data = null;
            return;
        }
        this._data = BackpackHelper.getBackpackType(this._stack).createBackpackData(this._stack);
        NBTBase dataTag = compound.func_74781_a(TAG_DATA);
        if (dataTag != null) {
            this._data.deserializeNBT(dataTag);
        }
        this._despawnTimer = compound.func_74764_b(TAG_DESPAWN_TIMER) ? compound.func_74762_e(TAG_DESPAWN_TIMER) : -1;
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound, boolean isClient) {
        NbtUtils.addToCompound(compound, TAG_AGE, !isClient ? Integer.valueOf(this._age) : null, TAG_FACING, (byte)(this.facing.ordinal() - 2), TAG_STACK, !this._stack.func_190926_b() ? this._stack.serializeNBT() : null, TAG_DATA, this._data != null && !isClient ? this._data.serializeNBT() : null, TAG_DESPAWN_TIMER, this._despawnTimer >= 0 && !isClient ? Integer.valueOf(this._despawnTimer) : null);
        return compound;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.writeNBT(new NBTTagCompound(), true));
    }

    public final NBTTagCompound func_189517_E_() {
        return this.writeNBT(super.func_189515_b(new NBTTagCompound()), true);
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g(), true);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound, false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.writeNBT(super.func_189515_b(compound), false);
    }

    @Override
    public ItemStack getStack() {
        return this._stack;
    }

    @Override
    public void setStack(ItemStack value) {
        this._stack = value;
    }

    @Override
    public IBackpackData getData() {
        return this._data;
    }

    @Override
    public void setData(IBackpackData value) {
        this._data = value;
    }

    @Override
    public int getPlayersUsing() {
        return this._playersUsing;
    }

    @Override
    public void setPlayersUsing(int value) {
        if (value > 0 != this._playersUsing > 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, value > 0 ? 1 : 0);
        }
        this._playersUsing = value;
        this._despawnTimer = -1;
    }

    @Override
    public int getLidTicks() {
        return this._lidTicks;
    }

    @Override
    public int getPrevLidTicks() {
        return this._prevLidTicks;
    }

    @Override
    public void setLidTicks(int value) {
        this._prevLidTicks = this._lidTicks;
        this._lidTicks = value;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == IBackpack.CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && WearableBackpacks.CONFIG.enableMachineInteraction.get() != false && this.getData() instanceof BackpackDataItems || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.hasCapability(capability, facing)) {
            return null;
        }
        return (T)(capability == IBackpack.CAPABILITY ? IBackpack.CAPABILITY.cast((Object)this) : (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((BackpackDataItems)this.getData()).getItems()) : super.getCapability(capability, facing)));
    }
}

