/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config.custom;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.mcft.copy.backpacks.ProxyClient;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.client.RendererBackpack;
import net.mcft.copy.backpacks.client.gui.Alignment;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiEntityRender;
import net.mcft.copy.backpacks.client.gui.GuiScrollable;
import net.mcft.copy.backpacks.client.gui.config.BaseConfigScreen;
import net.mcft.copy.backpacks.client.gui.config.BaseEntry;
import net.mcft.copy.backpacks.client.gui.config.EntryValueField;
import net.mcft.copy.backpacks.client.gui.config.EntryValueSlider;
import net.mcft.copy.backpacks.client.gui.config.IConfigEntry;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.config.custom.EntryValueMulti;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScreenRenderOptions
extends BaseConfigScreen {
    private final IConfigValue<BackpackRegistry.RenderOptions> _element;
    private final List<BackpackRegistry.BackpackEntry> _backpacks;
    private ItemStack _stack;
    private int _index = 0;
    private long _lastUpdateTime = Long.MIN_VALUE;
    public final BaseEntry.Value<List<Double>> entryTranslate;
    public final BaseEntry.Value<Double> entryRotate;
    public final BaseEntry.Value<Double> entryScale;
    private final IBackpack _backpack = new IBackpack.Impl();

    public ScreenRenderOptions(IConfigValue<BackpackRegistry.RenderOptions> element, List<BackpackRegistry.BackpackEntry> backpacks, Class<? extends EntityLivingBase> entityClass) {
        super(GuiElementBase.getCurrentScreen(), (String[])Stream.concat(((BaseConfigScreen)GuiElementBase.getCurrentScreen()).getTitleLines().stream().skip(1L), Stream.of("config.wearablebackpacks.entity.renderOptions")).toArray(String[]::new));
        this._element = element;
        this._backpacks = backpacks;
        if (entityClass != null) {
            this.scrollableContent.entryList = null;
            this.listEntries.setWidth(180);
            this.listEntries.setAlign(new GuiScrollable.FixedMax(8), (Alignment)new GuiScrollable.FixedMax(0));
            ProxyClient.ensureHasBackpackLayer(entityClass);
            GuiEntityRender entityRender = new GuiEntityRender(entityClass);
            entityRender.setAlign(new GuiScrollable.FixedBoth(0, 0), (Alignment)new GuiScrollable.FixedBoth(0, 0));
            entityRender.setYaw(145.0f);
            entityRender.setCenter(0.3f, 0.5f);
            entityRender.setZoom(0.9f);
            entityRender.setBackgroundColor(GuiElementBase.Color.TRANSPARENT);
            entityRender.setBorderColor(GuiElementBase.Color.TRANSPARENT);
            this.scrollableContent.insert(0, entityRender);
        }
        BackpackRegistry.RenderOptions value = element.getValue().get();
        this.entryTranslate = new BaseEntry.Value<List<Double>>(new EntryValueMulti(2, EntryValueField.Decimal.class), null, Arrays.asList(value.y, value.z));
        this.entryRotate = new BaseEntry.Value<Double>(new EntryValueSlider.RangeDouble(-90.0, 90.0, 5.0), null, value.rotate);
        this.entryScale = new BaseEntry.Value<Double>(new EntryValueField.Decimal(), null, value.scale);
        this.entryTranslate.setLabelAndTooltip("entity.translate");
        this.entryRotate.setLabelAndTooltip("entity.rotate");
        this.entryScale.setLabelAndTooltip("entity.scale");
        this.entryTranslate.remove(this.entryTranslate.buttonUndo);
        this.entryRotate.remove(this.entryRotate.buttonUndo);
        this.entryScale.remove(this.entryScale.buttonUndo);
        this.listEntries.addFixed(this.entryTranslate);
        this.listEntries.addFixed(this.entryRotate);
        this.listEntries.addFixed(this.entryScale);
        this.layoutButtons.addFixed(this.buttonDone);
        this.layoutButtons.addFixed(this.buttonUndo);
    }

    private BackpackRegistry.RenderOptions getValue() {
        if (!this.buttonDone.isEnabled()) {
            return null;
        }
        List<Double> translate = this.entryTranslate.getValue().get();
        return new BackpackRegistry.RenderOptions(translate.get(0), translate.get(1), this.entryRotate.getValue().get(), this.entryScale.getValue().get());
    }

    @Override
    protected void doneClicked() {
        this._element.setValue(this.getValue());
        super.doneClicked();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        long currentTime = Minecraft.func_71386_F();
        if (currentTime > this._lastUpdateTime + 1600L) {
            this._lastUpdateTime = currentTime;
            this._index = (this._index + 1) % this._backpacks.size();
            BackpackRegistry.BackpackEntry entry = this._backpacks.get(this._index);
            Item item = Item.func_111206_d((String)entry.backpack);
            ItemStack itemStack = this._stack = item != null ? new ItemStack(item) : ItemStack.field_190927_a;
            if (entry.colorRange != null) {
                NbtUtils.set(this._stack, Integer.valueOf(entry.colorRange.getRandom()), "display", "color");
            }
        }
        this.buttonDone.setEnabled(this.listEntries.getEntries().allMatch(IConfigEntry::isValid));
        this.buttonUndo.setEnabled(this.listEntries.getEntries().anyMatch(IConfigEntry::isChanged));
        this._backpack.setStack(this._stack);
        RendererBackpack.Layer.setOverride(this._backpack, this.getValue());
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RendererBackpack.Layer.resetOverride();
    }
}

