/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import net.mcft.copy.backpacks.misc.util.RandomUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public final class WorldUtils {
    private WorldUtils() {
    }

    public static EntityItem spawnItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        world.func_72838_d((Entity)item);
        return item;
    }

    public static EntityItem spawnItemWithMotion(World world, double x, double y, double z, ItemStack stack) {
        EntityItem item = WorldUtils.spawnItem(world, x, y, z, stack);
        if (item == null) {
            return null;
        }
        item.field_70159_w = RandomUtils.getGaussian() * (double)0.05f;
        item.field_70181_x = RandomUtils.getGaussian() * (double)0.05f + (double)0.2f;
        item.field_70179_y = RandomUtils.getGaussian() * (double)0.05f;
        return item;
    }

    public static EntityItem dropStackFromBlock(World world, BlockPos pos, ItemStack stack) {
        float itemX = (float)pos.func_177958_n() + RandomUtils.getFloat(0.1f, 0.9f);
        float itemY = (float)pos.func_177956_o() + RandomUtils.getFloat(0.1f, 0.9f);
        float itemZ = (float)pos.func_177952_p() + RandomUtils.getFloat(0.1f, 0.9f);
        return WorldUtils.spawnItemWithMotion(world, itemX, itemY, itemZ, stack);
    }

    public static EntityItem dropStackFromBlock(TileEntity entity, ItemStack stack) {
        return WorldUtils.dropStackFromBlock(entity.func_145831_w(), entity.func_174877_v(), stack);
    }

    public static void dropStacksFromBlock(World world, BlockPos pos, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            WorldUtils.dropStackFromBlock(world, pos, stack);
        }
    }

    public static void dropStacksFromBlock(World world, BlockPos pos, ItemStackHandler items) {
        for (int i = 0; i < items.getSlots(); ++i) {
            WorldUtils.dropStackFromBlock(world, pos, items.getStackInSlot(i));
        }
    }

    public static void dropStacksFromBlock(TileEntity entity, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            WorldUtils.dropStackFromBlock(entity, stack);
        }
    }

    public static void dropStacksFromBlock(TileEntity entity, ItemStackHandler items) {
        for (int i = 0; i < items.getSlots(); ++i) {
            WorldUtils.dropStackFromBlock(entity, items.getStackInSlot(i));
        }
    }

    public static EntityItem dropStackFromEntity(Entity entity, ItemStack stack, float speed) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player == null) {
            double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.3;
            EntityItem item = WorldUtils.spawnItem(entity.field_70170_p, entity.field_70165_t, y, entity.field_70161_v, stack);
            if (item == null) {
                return null;
            }
            item.func_174867_a(40);
            float f1 = RandomUtils.getFloat(0.5f);
            float f2 = RandomUtils.getFloat((float)Math.PI * 2);
            item.field_70159_w = -Math.sin(f2) * (double)f1;
            item.field_70181_x = 0.2;
            item.field_70179_y = Math.cos(f2) * (double)f1;
            return item;
        }
        EntityItem item = player.func_146097_a(stack, true, false);
        if (item != null) {
            item.field_70159_w *= (double)(speed / 4.0f);
            item.field_70179_y *= (double)(speed / 4.0f);
        }
        return item;
    }

    public static void dropStacksFromEntity(Entity entity, Iterable<ItemStack> stacks, float speed) {
        for (ItemStack stack : stacks) {
            WorldUtils.dropStackFromEntity(entity, stack, speed);
        }
    }

    public static void dropStacksFromEntity(Entity entity, ItemStackHandler items, float speed) {
        for (int i = 0; i < items.getSlots(); ++i) {
            WorldUtils.dropStackFromEntity(entity, items.getStackInSlot(i), speed);
        }
    }
}

