/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiTextField;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class TextField
extends Control {
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    public static final int DEFAULT_DISABLED_COLOR = 0x707070;
    private final GuiTextField field;
    private boolean enabled = true;
    private int textColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private final ArrayList<TextChangeListener> listeners = new ArrayList();

    public TextField() {
        this.field = new GuiTextField(0, this.font, 1, 1, 198, 20);
    }

    public TextField(int x, int y, int width, int height) {
        this.field = new GuiTextField(0, this.font, x + 1, y + 1, width - 2, height - 2);
    }

    public TextField(int x, int y, int width, int height, String text) {
        this.field = new GuiTextField(0, this.font, x + 1, y + 1, width - 2, height - 2);
        this.field.func_146180_a(text);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 28 || keyCode == 156) {
            this.parent.actionPerformed(new EnterPressedEvent(this));
        } else if (keyCode == 15) {
            this.parent.actionPerformed(new TabPressedEvent(this));
        } else {
            String old = this.enabled && this.field.func_146206_l() ? this.field.func_146179_b() : null;
            this.field.func_146201_a(typedChar, keyCode);
            if (this.enabled && this.field.func_146206_l() && !this.field.func_146179_b().equals(old)) {
                for (TextChangeListener tcl : this.listeners) {
                    tcl.onTextChange(this, old, this.field.func_146179_b());
                }
                this.parent.actionPerformed(new TextChangedEvent(this, old));
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.field.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        this.field.func_146194_f();
    }

    public void setText(String text) {
        String old = this.field.func_146179_b();
        this.field.func_146180_a(text);
        if (!old.equals(text)) {
            for (TextChangeListener tcl : this.listeners) {
                tcl.onTextChange(this, old, text);
            }
        }
    }

    public void clear() {
        this.field.func_146180_a("");
    }

    public String getText() {
        return this.field.func_146179_b();
    }

    public String getSelectedText() {
        return this.field.func_146207_c();
    }

    public void setWidth(int width) {
        this.field.field_146218_h = width - 2;
    }

    @Override
    public int getWidth() {
        return this.field.field_146218_h + 2;
    }

    public void setHeight(int height) {
        this.field.field_146219_i = height - 2;
    }

    @Override
    public int getHeight() {
        return this.field.field_146219_i + 2;
    }

    public void setSize(int w, int h) {
        this.field.field_146218_h = w - 2;
        this.field.field_146219_i = h - 2;
    }

    @Override
    public void setPos(int x, int y) {
        this.field.field_146209_f = x + 1;
        this.field.field_146210_g = y + 1;
    }

    @Override
    public int getX() {
        return this.field.field_146209_f - 1;
    }

    @Override
    public int getY() {
        return this.field.field_146210_g - 1;
    }

    public void setDisabled(boolean en) {
        this.enabled = !en;
        this.field.func_146184_c(this.enabled);
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void enable() {
        this.field.func_146184_c(true);
        this.enabled = true;
    }

    public void disable() {
        this.field.func_146184_c(false);
        this.enabled = false;
    }

    public void setVisible(boolean vi) {
        this.field.func_146189_e(vi);
    }

    public boolean isVisible() {
        return this.field.func_146176_q();
    }

    public void show() {
        this.field.func_146189_e(true);
    }

    public void hide() {
        this.field.func_146189_e(false);
    }

    public void setFocused(boolean val) {
        this.field.func_146195_b(val);
    }

    public boolean hasFocus() {
        return this.field.func_146206_l();
    }

    public void focus() {
        this.field.func_146195_b(true);
    }

    public void setMaxLength(int len) {
        this.field.func_146203_f(len);
    }

    public int getMaxLength() {
        return this.field.func_146208_g();
    }

    public void setTextColor(int color) {
        this.field.func_146193_g(color);
        this.textColor = color;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setDisabledTextColor(int color) {
        this.field.func_146204_h(color);
        this.disabledColor = color;
    }

    public int getDisabledTextColor() {
        return this.disabledColor;
    }

    public GuiTextField getMcField() {
        return this.field;
    }

    public void addTextChangeListener(TextChangeListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeTextChangeListener(TextChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.field.field_146209_f = json.getInt("x", 0) + 1;
        this.field.field_146210_g = json.getInt("y", 0) + 1;
        this.field.field_146218_h = json.getInt("width", 200) - 2;
        this.field.field_146219_i = json.getInt("height", 22) - 2;
        this.field.func_146180_a(TextField.tr(json.getString("text", "")));
        this.field.func_146189_e(json.getBool("visible", true));
        this.field.func_146203_f(json.getInt("maxLength", 32));
        this.enabled = !json.getBool("disabled", false);
        this.textColor = json.getColor("textColor", 0xE0E0E0);
        this.disabledColor = json.getColor("disabledColor", 0x707070);
        this.field.func_146193_g(this.textColor);
        this.field.func_146204_h(this.disabledColor);
        this.field.func_146184_c(this.enabled);
    }

    public static interface TextChangeListener {
        public void onTextChange(TextField var1, String var2, String var3);
    }

    public static class TextChangedEvent
    extends Event<TextField> {
        private final String oldContent;
        private final String newContent;

        private TextChangedEvent(TextField tf, String old) {
            this.source = tf;
            this.oldContent = old;
            this.newContent = tf.field.func_146179_b();
        }

        public String getOldContent() {
            return this.oldContent;
        }

        public String getNewContent() {
            return this.newContent;
        }
    }

    public static class TabPressedEvent
    extends Event<TextField> {
        private final String beginning;

        private TabPressedEvent(TextField field) {
            this.source = field;
            String text = field.field.func_146179_b();
            int max = field.field.func_146198_h();
            int spacePos = 0;
            for (int i = max - 1; i >= 0; --i) {
                if (!Character.isSpaceChar(text.charAt(i))) continue;
                spacePos = i;
                break;
            }
            this.beginning = text.substring(spacePos, max).trim();
        }

        public String getBeginning() {
            return this.beginning;
        }
    }

    public static class EnterPressedEvent
    extends Event<TextField> {
        private final String text;

        private EnterPressedEvent(TextField field) {
            this.source = field;
            this.text = field.field.func_146179_b();
        }

        public String getText() {
            return this.text;
        }
    }
}

