/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class UpgradeGroup
extends BasicControl {
    private int width;
    private int height;
    private ArrayList<ItemStack> upgrades;
    private ItemStack overStack;
    private ItemStack clickStack;
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public UpgradeGroup() {
        this.parent.requirePostDraw(this);
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        if (this.upgrades != null) {
            int x = this.x;
            for (ItemStack is : this.upgrades) {
                if (is == this.overStack && !this.disabled) {
                    this.fillRect(x, this.y, 16, 16, -2130771968);
                }
                this.renderItem.func_184391_a((EntityLivingBase)this.mc.field_71439_g, is, x, this.y);
                this.renderItem.func_180453_a(this.font, is, x, this.y, null);
                x += 18;
            }
        }
    }

    @Override
    public void postDraw(int mouseX, int mouseY, float ptt) {
        if (this.overStack != null) {
            this.parent.drawItemStackTooltip(this.overStack, mouseX, mouseY);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setUpgrades(ArrayList<ItemStack> upgrades) {
        this.upgrades = upgrades;
    }

    public ArrayList<ItemStack> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 0);
        this.height = json.getInt("height", 16);
    }

    @Override
    public void mouseMove(int mouseX, int mouseY) {
        if (this.upgrades != null) {
            int sel;
            this.overStack = null;
            if (mouseY >= this.y && mouseY <= this.y + 16 && mouseX >= this.x && (sel = (mouseX -= this.x) / 18) < this.upgrades.size() && mouseX % 18 <= 16) {
                this.overStack = this.upgrades.get(sel);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.clickStack = this.overStack;
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (state == 0 && this.clickStack != null) {
            if (this.clickStack == this.overStack && !this.disabled && this.upgrades.contains(this.clickStack)) {
                this.parent.actionPerformed(new ClickEvent(this));
            }
            this.clickStack = null;
        }
    }

    public ItemStack getMouseOverUpgrade() {
        return this.overStack;
    }

    public static class ClickEvent
    extends Event<UpgradeGroup> {
        private final ItemStack clickStack;

        private ClickEvent(UpgradeGroup src) {
            this.source = src;
            this.clickStack = src.clickStack;
        }

        public ItemStack getMouseOverStack() {
            return this.clickStack;
        }
    }
}

