/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.loading;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.CheckBox;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.ControlGroup;
import net.montoyo.wd.client.gui.controls.Icon;
import net.montoyo.wd.client.gui.controls.Label;
import net.montoyo.wd.client.gui.controls.List;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.controls.UpgradeGroup;
import net.montoyo.wd.client.gui.controls.YTButton;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.Log;

public class GuiLoader {
    private static final HashMap<String, Class<? extends Control>> CONTROLS = new HashMap();
    private static final HashMap<ResourceLocation, JsonObject> RESOURCES = new HashMap();

    public static void register(Class<? extends Control> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new RuntimeException("GG retard, you just registered an abstract class...");
        }
        String name = cls.getSimpleName();
        if (CONTROLS.containsKey(name)) {
            throw new RuntimeException("Control class already registered or name taken!");
        }
        CONTROLS.put(name, cls);
    }

    public static Control create(JsonOWrapper json) {
        Control ret;
        try {
            ret = CONTROLS.get(json.getString("type", null)).newInstance();
        }
        catch (InstantiationException e) {
            Log.errorEx("Could not create control from JSON: instantiation exception", e, new Object[0]);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            Log.errorEx("Could not create control from JSON: access denied", e, new Object[0]);
            throw new RuntimeException(e);
        }
        ret.load(json);
        return ret;
    }

    public static JsonObject getJson(ResourceLocation resLoc) {
        JsonObject ret = RESOURCES.get(resLoc);
        if (ret == null) {
            IResource resource;
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
            }
            catch (IOException e) {
                Log.errorEx("Couldn't load JSON UI from file", e, new Object[0]);
                throw new RuntimeException(e);
            }
            JsonParser parser = new JsonParser();
            ret = parser.parse((Reader)new InputStreamReader(resource.func_110527_b())).getAsJsonObject();
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RESOURCES.put(resLoc, ret);
        }
        return ret;
    }

    public static void clearCache() {
        RESOURCES.clear();
    }

    static {
        GuiLoader.register(Button.class);
        GuiLoader.register(CheckBox.class);
        GuiLoader.register(ControlGroup.class);
        GuiLoader.register(Label.class);
        GuiLoader.register(List.class);
        GuiLoader.register(TextField.class);
        GuiLoader.register(Icon.class);
        GuiLoader.register(UpgradeGroup.class);
        GuiLoader.register(YTButton.class);
    }
}

