/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.server;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.montoyo.wd.utilities.Log;

public class ClientManager {
    private final SecureRandom random = new SecureRandom();
    private final HashMap<UUID, byte[]> keys = new HashMap();
    private final ReentrantReadWriteLock keyLock = new ReentrantReadWriteLock();

    public byte[] getOrGenClientKey(UUID uuid) {
        this.keyLock.readLock().lock();
        byte[] key = this.keys.get(uuid);
        this.keyLock.readLock().unlock();
        if (key == null) {
            key = new byte[32];
            this.random.nextBytes(key);
            this.keyLock.writeLock().lock();
            this.keys.put(uuid, key);
            this.keyLock.writeLock().unlock();
        }
        return key;
    }

    public byte[] getClientKey(UUID uuid) {
        this.keyLock.readLock().lock();
        byte[] ret = this.keys.get(uuid);
        this.keyLock.readLock().unlock();
        return ret;
    }

    public void revokeClientKey(UUID id) {
        this.keyLock.writeLock().lock();
        this.keys.remove(id);
        this.keyLock.writeLock().unlock();
    }

    public byte[] generateChallenge() {
        byte[] ret = new byte[32];
        this.random.nextBytes(ret);
        return ret;
    }

    public boolean verifyClient(UUID client, byte[] challenge, byte[] hmac) {
        this.keyLock.readLock().lock();
        byte[] key = this.keys.get(client);
        this.keyLock.readLock().unlock();
        if (challenge == null || hmac == null || key == null) {
            return false;
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] result = mac.doFinal(challenge);
            return Arrays.equals(hmac, result);
        }
        catch (NoSuchAlgorithmException ex) {
            Log.warningEx("%s is not supported?!?!", ex, "HmacSHA256");
        }
        catch (InvalidKeyException ex) {
            Log.warningEx("The generated key is invalid", ex, new Object[0]);
        }
        return false;
    }

    public byte[] encryptClientKey(UUID client, byte[] modulus, byte[] exponent) {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(exponent));
        try {
            PublicKey key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, (Key)key, this.random);
            return cipher.doFinal(this.getOrGenClientKey(client));
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            Log.warningEx("%s is not supported?!?!", ex, "RSA/ECB/PKCS1Padding");
        }
        catch (InvalidKeyException | InvalidKeySpecException ex) {
            Log.warningEx("A client sent a malicious key", ex, new Object[0]);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Log.warningEx("Could not encrypt client key", ex, new Object[0]);
        }
        return null;
    }
}

