/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.utilities.Log;

@Message(messageId=9, side=Side.CLIENT)
public class CMessageJSResponse
implements IMessage,
Runnable {
    private int id;
    private JSServerRequest type;
    private boolean success;
    private byte[] data;
    private int errCode;
    private String errString;

    public CMessageJSResponse() {
    }

    public CMessageJSResponse(int id, JSServerRequest t, byte[] d) {
        this.id = id;
        this.type = t;
        this.success = true;
        this.data = d;
    }

    public CMessageJSResponse(int id, JSServerRequest t, int code, String err) {
        this.id = id;
        this.type = t;
        this.success = false;
        this.errCode = code;
        this.errString = err;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.type = JSServerRequest.fromID(buf.readByte());
        this.success = buf.readBoolean();
        if (this.success) {
            this.data = new byte[buf.readByte()];
            buf.readBytes(this.data);
        } else {
            this.errCode = buf.readInt();
            this.errString = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte(this.type.ordinal());
        buf.writeBoolean(this.success);
        if (this.success) {
            buf.writeByte(this.data.length);
            buf.writeBytes(this.data);
        } else {
            buf.writeInt(this.errCode);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.errString);
        }
    }

    @Override
    public void run() {
        try {
            if (this.success) {
                WebDisplays.PROXY.handleJSResponseSuccess(this.id, this.type, this.data);
            } else {
                WebDisplays.PROXY.handleJSResponseError(this.id, this.type, this.errCode, this.errString);
            }
        }
        catch (Throwable t) {
            Log.warningEx("Could not handle JS response", t, new Object[0]);
        }
    }
}

