/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public abstract class Multiblock {
    public static final BlockOverride NULL_OVERRIDE = new BlockOverride(null, OverrideAction.NONE);

    public static void findOrigin(IBlockAccess world, Vector3i pos, BlockSide side, BlockOverride override) {
        if (override == null) {
            override = NULL_OVERRIDE;
        }
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        do {
            pos.add(side.left);
            pos.toBlock(bp);
        } while (override.apply(pos, world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen));
        pos.add(side.right);
        do {
            pos.add(side.down);
            pos.toBlock(bp);
        } while (override.apply(pos, world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen));
        pos.add(side.up);
    }

    public static Vector2i measure(IBlockAccess world, Vector3i origin, BlockSide side) {
        Vector2i ret = new Vector2i();
        Vector3i pos = origin.clone();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        pos.toBlock(bp);
        do {
            pos.add(side.up);
            pos.toBlock(bp);
            ++ret.y;
        } while (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen);
        pos.add(side.down);
        do {
            pos.add(side.right);
            pos.toBlock(bp);
            ++ret.x;
        } while (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen);
        return ret;
    }

    public static Vector3i check(IBlockAccess world, Vector3i origin, Vector2i size, BlockSide side) {
        int x;
        int y;
        Vector3i pos = origin.clone();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        for (y = 0; y < size.y; ++y) {
            for (int x2 = 0; x2 < size.x; ++x2) {
                pos.toBlock(bp);
                if (world.func_180495_p((BlockPos)bp).func_177230_c() != WebDisplays.INSTANCE.blockScreen) {
                    return pos;
                }
                pos.add(side.forward);
                pos.toBlock(bp);
                if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                    return pos;
                }
                pos.addMul(side.backward, 2);
                pos.toBlock(bp);
                if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                    return pos;
                }
                pos.add(side.forward);
                pos.add(side.right);
            }
            pos.addMul(side.left, size.x);
            pos.add(side.up);
        }
        pos.set(origin);
        pos.add(side.left);
        for (y = 0; y < size.y; ++y) {
            pos.toBlock(bp);
            if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                return pos;
            }
            pos.add(side.up);
        }
        pos.set(origin);
        pos.addMul(side.right, size.x);
        for (y = 0; y < size.y; ++y) {
            pos.toBlock(bp);
            if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                return pos;
            }
            pos.add(side.up);
        }
        pos.set(origin);
        pos.add(side.down);
        for (x = 0; x < size.x; ++x) {
            pos.toBlock(bp);
            if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                return pos;
            }
            pos.add(side.right);
        }
        pos.set(origin);
        pos.addMul(side.up, size.y);
        for (x = 0; x < size.x; ++x) {
            pos.toBlock(bp);
            if (world.func_180495_p((BlockPos)bp).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                return pos;
            }
            pos.add(side.right);
        }
        return null;
    }

    public static class BlockOverride {
        final Vector3i pos;
        final OverrideAction action;

        public BlockOverride(Vector3i p, OverrideAction act) {
            this.pos = p;
            this.action = act;
        }

        public boolean apply(Vector3i bp, boolean originalResult) {
            if (this.action == OverrideAction.NONE || !bp.equals(this.pos)) {
                return originalResult;
            }
            return this.action == OverrideAction.SIMULATE;
        }
    }

    public static enum OverrideAction {
        NONE,
        SIMULATE,
        IGNORE;

    }
}

