/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.vc.CommonProxy;
import noppes.vc.EntityChairMount;
import noppes.vc.EntityHolyHandGrenade;
import noppes.vc.EntityMagicProjectile;
import noppes.vc.EntityProjectile;
import noppes.vc.ServerEventsHandler;
import noppes.vc.VCArmors;
import noppes.vc.VCBlocks;
import noppes.vc.VCItems;
import noppes.vc.VCRecipes;
import noppes.vc.VCWeapons;
import noppes.vc.client.VCSounds;
import noppes.vc.config.ConfigLoader;
import noppes.vc.config.ConfigProp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="variedcommodities", version="1.12.2", name="VariedCommodities", acceptedMinecraftVersions="1.12, 1.12.1, 1.12.2")
public class VariedCommodities {
    public static final String MODID = "variedcommodities";
    public static final String VERSION = "1.12.2";
    @SidedProxy(clientSide="noppes.vc.client.ClientProxy", serverSide="noppes.vc.CommonProxy")
    public static CommonProxy proxy;
    @ConfigProp(info="Disables all Varied Commodities recipes")
    public static boolean DisableRecipes;
    @ConfigProp(info="Disables all Varied Commodities enchantments")
    public static boolean DisableEnchantments;
    public static FMLEventChannel Channel;
    public static VariedCommodities Instance;
    private static int NewEntityStartId;
    public static Logger Log;
    public static ConfigLoader Config;

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        Instance = this;
        Config = new ConfigLoader(this.getClass(), event.getModConfigurationDirectory(), "VariedCommodities");
        Config.loadConfig();
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(MODID);
        MinecraftForge.EVENT_BUS.register((Object)new VCItems());
        MinecraftForge.EVENT_BUS.register((Object)new VCWeapons());
        MinecraftForge.EVENT_BUS.register((Object)new VCBlocks());
        MinecraftForge.EVENT_BUS.register((Object)new VCArmors());
        if (!DisableRecipes) {
            MinecraftForge.EVENT_BUS.register((Object)new VCRecipes());
        }
        MinecraftForge.EVENT_BUS.register((Object)new VCSounds());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preinit();
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerNewEntity(EntityChairMount.class, "VCChairMount", 64, 10, false);
        this.registerNewEntity(EntityProjectile.class, "VCProjectile", 64, 3, true);
        this.registerNewEntity(EntityMagicProjectile.class, "VCMagicProjectile", 64, 3, true);
        this.registerNewEntity(EntityHolyHandGrenade.class, "VCHolyHandGrenade", 64, 1, true);
    }

    private void registerNewEntity(Class<? extends Entity> cl, String name, int range, int update, boolean velocity) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, name), cl, (String)name, (int)NewEntityStartId++, (Object)this, (int)range, (int)update, (boolean)velocity);
    }

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        proxy.postinit();
    }

    @SubscribeEvent
    public void onMissingMapping(RegistryEvent.MissingMappings<Item> event) {
        HashMap<String, ResourceLocation> maps = new HashMap<String, ResourceLocation>();
        this.dealMissingMapping(maps);
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String resourcePath = mapping.key.toString().toLowerCase();
            if (!maps.containsKey(resourcePath)) continue;
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)maps.get(resourcePath));
            if (item == null) {
                System.out.println(maps.get(resourcePath));
            }
            mapping.remap((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public void onMissingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        HashMap<String, ResourceLocation> maps = new HashMap<String, ResourceLocation>();
        this.dealMissingMapping(maps);
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String resourcePath = mapping.key.toString().toLowerCase();
            if (!maps.containsKey(resourcePath)) continue;
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)maps.get(resourcePath));
            mapping.remap((IForgeRegistryEntry)b);
        }
    }

    private void dealMissingMapping(HashMap<String, ResourceLocation> maps) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(MinecraftServer.class.getResourceAsStream("/assets/variedcommodities/mappingfix.cfg")));
            while ((line = br.readLine()) != null) {
                String[] split = line.toLowerCase().split("=");
                if (split.length != 2) continue;
                maps.put(split[0], new ResourceLocation(split[1]));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        DisableRecipes = false;
        DisableEnchantments = false;
        NewEntityStartId = 0;
        Log = LogManager.getLogger();
    }
}

