/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.gui.component;

import com.pau101.fairylights.client.gui.GuiEditLetteredConnection;
import com.pau101.fairylights.client.gui.component.GuiButtonColor;
import com.pau101.fairylights.util.Mth;
import com.pau101.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonPalette
extends GuiButton {
    private static final int TEX_U = 0;
    private static final int TEX_V = 40;
    private static final int SELECT_U = 28;
    private static final int SELECT_V = 40;
    private static final int COLOR_U = 34;
    private static final int COLOR_V = 40;
    private static final int COLOR_WIDTH = 6;
    private static final int COLOR_HEIGHT = 6;
    private static final TextFormatting[] IDX_COLOR = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.GRAY, TextFormatting.DARK_GRAY, TextFormatting.BLACK, TextFormatting.RED, TextFormatting.DARK_RED, TextFormatting.YELLOW, TextFormatting.GOLD, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE, TextFormatting.GREEN, TextFormatting.DARK_GREEN, TextFormatting.BLUE, TextFormatting.DARK_BLUE, TextFormatting.AQUA, TextFormatting.DARK_AQUA};
    private static final int[] COLOR_IDX = Mth.invertMap(IDX_COLOR, Enum::ordinal);
    private final FontRenderer font;
    private final GuiButtonColor colorBtn;

    public GuiButtonPalette(int id, int x, int y, FontRenderer font, GuiButtonColor colorBtn) {
        super(id, x, y, 28, 28, "");
        this.font = font;
        this.colorBtn = colorBtn;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        int idx;
        if (super.func_146116_c(mc, mouseX, mouseY) && (idx = this.getMouseOverIndex(mouseX, mouseY)) > -1) {
            this.colorBtn.setDisplayColor(this.font, IDX_COLOR[idx]);
            return true;
        }
        return false;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float delta) {
        if (this.field_146125_m) {
            mc.func_110434_K().func_110577_a(GuiEditLetteredConnection.WIDGETS_TEXTURE);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 40, this.field_146120_f, this.field_146121_g);
            if (this.colorBtn.hasDisplayColor()) {
                int idx = COLOR_IDX[this.colorBtn.getDisplayColor().ordinal()];
                int selectX = this.field_146128_h + 2 + idx % 4 * 6;
                int selectY = this.field_146129_i + 2 + idx / 4 * 6;
                this.func_73729_b(selectX, selectY, 28, 40, 6, 6);
            }
            for (int i = 0; i < IDX_COLOR.length; ++i) {
                TextFormatting color = IDX_COLOR[i];
                int rgb = StyledString.getColor(this.font, color);
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
                this.func_73729_b(this.field_146128_h + 2 + i % 4 * 6, this.field_146129_i + 2 + i / 4 * 6, 34, 40, 6, 6);
            }
            int selectIndex = this.getMouseOverIndex(mouseX, mouseY);
            if (selectIndex > -1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                int hoverSelectX = this.field_146128_h + 2 + selectIndex % 4 * 6;
                int hoverSelectY = this.field_146129_i + 2 + selectIndex / 4 * 6;
                this.func_73729_b(hoverSelectX, hoverSelectY, 28, 40, 6, 6);
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private int getMouseOverIndex(int mouseX, int mouseY) {
        int relX = mouseX - this.field_146128_h - 3;
        int relY = mouseY - this.field_146129_i - 3;
        if (relX < 0 || relY < 0 || relX > 22 || relY > 22) {
            return -1;
        }
        int bucketX = relX % 6;
        int bucketY = relY % 6;
        if (bucketX > 3 || bucketY > 3) {
            return -1;
        }
        int x = relX / 6;
        int y = relY / 6;
        return x + y * 4;
    }
}

