/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.letter;

import java.util.HashMap;
import java.util.Map;

public final class SymbolSet {
    private final Symbol[] symbols;
    private final Map<Character, Symbol> chars;
    private final int size;

    private SymbolSet(Symbol[] symbols, int size) {
        this.symbols = symbols;
        this.size = size;
        this.chars = new HashMap<Character, Symbol>();
        for (Symbol symbol : symbols) {
            this.chars.put(Character.valueOf(symbol.character), symbol);
        }
    }

    public int getHeight() {
        return this.size;
    }

    public boolean contains(char character) {
        return this.chars.containsKey(Character.valueOf(character));
    }

    public int getWidth(char character) {
        return this.chars.getOrDefault(Character.valueOf(character), Symbol.UNKNOWN).width;
    }

    public int getU(char character) {
        return this.chars.getOrDefault(Character.valueOf(character), Symbol.UNKNOWN).u;
    }

    public int getV(char character) {
        return this.chars.getOrDefault(Character.valueOf(character), Symbol.UNKNOWN).v;
    }

    public static SymbolSet from(int columns, int size, String str) {
        String[] chars = str.split(",");
        Symbol[] symbols = new Symbol[chars.length / 2];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            char c = chars[i++].charAt(0);
            int w = Integer.valueOf(chars[i++]);
            symbols[j] = new Symbol(c, w, j % columns * size, j / columns * size);
            ++j;
        }
        return new SymbolSet(symbols, size);
    }

    private static class Symbol {
        public static final Symbol UNKNOWN = new Symbol('?', 0, 0, 0);
        private final char character;
        private final int width;
        private final int u;
        private final int v;

        public Symbol(char character, int width, int u, int v) {
            this.character = character;
            this.width = width;
            this.u = u;
            this.v = v;
        }
    }
}

