/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BeehiveWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!HarvestCraft.config.enableBeehiveGeneration) {
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(chunkX, 0, chunkZ));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return;
        }
        BeehiveWorldGen.tryGenerateBeehives(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
    }

    private static void tryGenerateBeehives(World world, Random random, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos variableBlockPos = new BlockPos.MutableBlockPos();
        if (random.nextFloat() < (float)HarvestCraft.config.beehiveRarity / 33.0f) {
            int x = chunkX + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            int y = world.func_189649_b(x, z) - 1;
            variableBlockPos.func_181079_c(x, y, z);
            if (!BeehiveWorldGen.isBlockLeaves(world, (BlockPos)variableBlockPos)) {
                return;
            }
            int newY = BeehiveWorldGen.getHeightBelowLeaves(world, x, y, z);
            if (newY < 0) {
                return;
            }
            variableBlockPos.func_185336_p(newY);
            world.func_175656_a((BlockPos)variableBlockPos, BlockRegistry.beehive.func_176223_P());
        }
    }

    private static boolean isBlockLeaves(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        return block.isLeaves(blockState, (IBlockAccess)world, blockPos);
    }

    private static int getHeightBelowLeaves(World world, int posX, int posY, int posZ) {
        BlockPos.MutableBlockPos variableBlockPos = new BlockPos.MutableBlockPos();
        variableBlockPos.func_181079_c(posX, posY, posZ);
        int sealevel = world.func_181545_F();
        for (int y = posY; y >= sealevel; --y) {
            variableBlockPos.func_185336_p(y);
            IBlockState blockState = world.func_180495_p((BlockPos)variableBlockPos);
            Block block = blockState.func_177230_c();
            if (block.isLeaves(blockState, (IBlockAccess)world, (BlockPos)variableBlockPos)) continue;
            if (world.func_175623_d((BlockPos)variableBlockPos)) {
                return y;
            }
            return -1;
        }
        return -1;
    }
}

