/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.PizzaCraft;
import com.tiviacz.pizzacraft.crafting.chopping.ChoppingBoardRecipes;
import com.tiviacz.pizzacraft.crafting.chopping.ChoppingBoardUtils;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.ModPotions;
import com.tiviacz.pizzacraft.tileentity.TileEntityChoppingBoard;
import com.tiviacz.pizzacraft.util.Bounds;
import com.tiviacz.pizzacraft.util.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockChoppingBoard
extends BlockContainer
implements IHasModel {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB CHOPPING_BOARD_AABB = new Bounds(0.125, 0.0, 0.25, 0.875, 0.046875, 0.75).toAABB();
    private static final AxisAlignedBB CHOPPING_BOARD_AABB2 = new Bounds(0.25, 0.0, 0.125, 0.75, 0.046875, 0.875).toAABB();

    public BlockChoppingBoard(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(PizzaCraft.PIZZACRAFTTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149752_b(10.0f);
        this.func_149711_c(2.0f);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                return CHOPPING_BOARD_AABB;
            }
            case SOUTH: {
                return CHOPPING_BOARD_AABB;
            }
            case EAST: {
                return CHOPPING_BOARD_AABB2;
            }
            case WEST: {
                return CHOPPING_BOARD_AABB2;
            }
        }
        return CHOPPING_BOARD_AABB;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntityChoppingBoard tile = (TileEntityChoppingBoard)worldIn.func_175625_s(pos);
            IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack stack = playerIn.func_184586_b(hand);
            if (ChoppingBoardUtils.isItemValid(stack)) {
                if (inv.getStackInSlot(0).func_190926_b() && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 0)) {
                    playerIn.func_184611_a(hand, inv.insertItem(0, stack, false));
                    return true;
                }
            } else {
                if (!inv.getStackInSlot(0).func_190926_b() && stack.func_190926_b() && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 0)) {
                    playerIn.func_184611_a(hand, inv.extractItem(0, 64, false));
                    return true;
                }
                if (stack.func_77973_b() == ModItems.KNIFE && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 0) && !inv.getStackInSlot(0).func_190926_b()) {
                    if (tile.chop()) {
                        if (ChoppingBoardRecipes.instance().getChoppingResult(tile.inventory.getStackInSlot(0)).func_77973_b() == ModItems.ONION_SLICE) {
                            playerIn.func_70690_d(new PotionEffect(ModPotions.EYE_IRRITATION_EFFECT, 100, 0, true, true));
                        }
                        stack.func_77972_a(1, (EntityLivingBase)playerIn);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187730_dW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return true;
                    }
                } else {
                    if (!inv.getStackInSlot(1).func_190926_b() && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 1) && stack.func_190926_b()) {
                        playerIn.func_184611_a(hand, inv.extractItem(1, 64, false));
                        return true;
                    }
                    if (inv.getStackInSlot(2).func_190926_b() && stack.func_77973_b() == ModItems.KNIFE && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 1)) {
                        playerIn.func_184611_a(hand, inv.insertItem(2, stack, false));
                        return true;
                    }
                    if (!inv.getStackInSlot(2).func_190926_b() && stack.func_190926_b() && this.canHit((EnumFacing)state.func_177229_b((IProperty)FACING), hitX, hitZ, 1)) {
                        playerIn.func_184611_a(hand, inv.extractItem(2, 64, false));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityChoppingBoard tile = (TileEntityChoppingBoard)worldIn.func_175625_s(pos);
        IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            BlockChoppingBoard.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private boolean canHit(EnumFacing facing, float hitX, float hitZ, int slot) {
        if (facing == EnumFacing.NORTH) {
            if (hitX >= 0.5f && slot == 0) {
                return true;
            }
            if (hitX <= 0.5f && slot == 1) {
                return true;
            }
        }
        if (facing == EnumFacing.SOUTH) {
            if (hitX <= 0.5f && slot == 0) {
                return true;
            }
            if (hitX >= 0.5f && slot == 1) {
                return true;
            }
        }
        if (facing == EnumFacing.EAST) {
            if (hitZ >= 0.5f && slot == 0) {
                return true;
            }
            if (hitZ <= 0.5f && slot == 1) {
                return true;
            }
        }
        if (facing == EnumFacing.WEST) {
            if (hitZ <= 0.5f && slot == 0) {
                return true;
            }
            if (hitZ >= 0.5f && slot == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityChoppingBoard();
    }

    @Override
    public void registerModel() {
        PizzaCraft.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }
}

