/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks.plants;

import com.tiviacz.pizzacraft.blocks.plants.CornPlantBottom;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.util.Bounds;
import com.tiviacz.pizzacraft.util.HarvestingUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CornPlantTop
extends CornPlantBottom {
    public static final PropertyInteger CORN_TOP_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
    private static final AxisAlignedBB[] CORN_BOTTOM_AABB = new AxisAlignedBB[]{new Bounds(0, 0, 0, 16, 10, 16).toAABB(), new Bounds(0, 0, 0, 16, 10, 16).toAABB(), new Bounds(0, 0, 0, 16, 10, 16).toAABB(), new Bounds(0, 0, 0, 16, 15, 16).toAABB(), new Bounds(0, 0, 0, 16, 15, 16).toAABB(), new Bounds(0, 0, 0, 16, 15, 16).toAABB()};

    public CornPlantTop(String name) {
        super(name);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_185525_y(state)) {
            HarvestingUtils.harvestPlant(state, playerIn, worldIn, pos);
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CORN_BOTTOM_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    @Override
    protected PropertyInteger func_185524_e() {
        return CORN_TOP_AGE;
    }

    @Override
    public int func_185526_g() {
        return 5;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == ModBlocks.CORN_PLANT_BOTTOM;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.func_185528_e(i), 2);
    }

    public float getGrowthChance(World par1World, int par2, int par3, int par4) {
        return 0.0f;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState cornBottom = worldIn.func_180495_p(pos.func_177977_b());
        return (worldIn.func_175699_k(pos) >= 8 || worldIn.func_175678_i(pos)) && cornBottom.func_177230_c() == ModBlocks.CORN_PLANT_BOTTOM && cornBottom.func_177230_c().func_176201_c(cornBottom) >= ((CornPlantBottom)cornBottom.func_177230_c()).func_185526_g() - 1;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        int age = this.func_185527_x(state);
        Random rand = new Random();
        if (age >= this.func_185526_g()) {
            if (rand.nextInt(2 * this.func_185526_g()) <= age) {
                drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
            }
            drops.add((Object)new ItemStack(this.func_149865_P(), 1, 0));
            for (int i = 0; i < 1 + fortune; ++i) {
                if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                drops.add((Object)new ItemStack(this.func_149865_P(), 1, 0));
            }
        } else {
            drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
        }
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.func_185525_y(state);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CORN_TOP_AGE});
    }
}

