/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.crafting.bakeware;

import com.tiviacz.pizzacraft.crafting.bakeware.IBakewareRecipe;
import com.tiviacz.pizzacraft.crafting.bakeware.ItemStackUtils;
import com.tiviacz.pizzacraft.gui.inventory.InventoryCraftingImproved;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class CraftingUtils {
    public static void addShapelessRecipe(NonNullList<ItemStack> list, Object ... recipeComponents) {
        Arrays.stream(recipeComponents).forEachOrdered(object -> {
            if (object instanceof ItemStack) {
                list.add((Object)((ItemStack)object).func_77946_l());
            } else if (object instanceof Item) {
                list.add((Object)ItemStackUtils.getItemStack(object));
            } else {
                if (!(object instanceof Block)) {
                    throw new AssertionError((Object)("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!"));
                }
                list.add((Object)ItemStackUtils.getItemStack(object));
            }
        });
    }

    public static ItemStack findMatchingRecipe(List<IBakewareRecipe> recipes, InventoryCraftingImproved craftMatrix, World worldIn) {
        return recipes.stream().filter(irecipe -> irecipe.matches(craftMatrix, worldIn)).findFirst().map(irecipe -> irecipe.getCraftingResult(craftMatrix)).orElse(ItemStack.field_190927_a);
    }

    public static NonNullList<ItemStack> getRemainingItems(List<IBakewareRecipe> recipes, InventoryCraftingImproved craftMatrix, World worldIn) {
        for (IBakewareRecipe recipe : recipes) {
            if (!recipe.matches(craftMatrix, worldIn)) continue;
            return recipe.getRemainingItems(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return nonnulllist;
    }

    public static void onTake(EntityPlayer player, InventoryCraftingImproved craftMatrix, NonNullList<ItemStack> input) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack slotStack = craftMatrix.func_70301_a(i);
            ItemStack inputStack = (ItemStack)input.get(i);
            if (!slotStack.func_190926_b()) {
                craftMatrix.func_70298_a(i, 1);
                slotStack = craftMatrix.func_70301_a(i);
            }
            if (inputStack.func_190926_b()) continue;
            if (slotStack.func_190926_b()) {
                craftMatrix.func_70299_a(i, inputStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)inputStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)inputStack)) {
                inputStack.func_190917_f(slotStack.func_190916_E());
                craftMatrix.func_70299_a(i, inputStack);
                continue;
            }
            if (player.field_71071_by.func_70441_a(inputStack)) continue;
            player.func_71019_a(inputStack, false);
        }
    }
}

