/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.crafting.bakeware;

import com.tiviacz.pizzacraft.crafting.bakeware.ItemStackUtils;
import com.tiviacz.pizzacraft.gui.inventory.InventoryCraftingImproved;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessOreRecipeUtils {
    public static void createRecipe(ItemStack output, NonNullList<Object> input, Object ... recipe) {
        Arrays.stream(recipe).forEachOrdered(in -> {
            if (in instanceof ItemStack) {
                input.add((Object)((ItemStack)in).func_77946_l());
            } else if (in instanceof Item || in instanceof Block) {
                input.add((Object)ItemStackUtils.getItemStack(in));
            } else if (in instanceof String) {
                input.add((Object)OreDictionary.getOres((String)((String)in)));
            } else {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                Arrays.stream(recipe).forEachOrdered(tmp -> ret.append(tmp).append(", "));
                ret.append(output);
                throw new RuntimeException(ret.toString());
            }
        });
    }

    public static boolean matches(NonNullList<Object> input, InventoryCraftingImproved inv) {
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(input);
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match = false;
                if (aRequired instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)aRequired), (ItemStack)slot, (boolean)false);
                } else if (aRequired instanceof List) {
                    Iterator itr = ((List)aRequired).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(aRequired);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }
}

