/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.tileentity;

import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.util.Reference;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityPizzaBag
extends TileEntity {
    public ItemStackHandler inventory = new ItemStackHandler(6){

        protected int getStackLimit(int slot, ItemStack stack) {
            return Reference.getValidBagItems().contains(stack.func_77973_b()) ? 64 : 0;
        }
    };

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public String getName() {
        return "container.pizza_bag";
    }

    public boolean isEmpty() {
        ItemStack stack1 = this.inventory.getStackInSlot(0);
        ItemStack stack2 = this.inventory.getStackInSlot(1);
        ItemStack stack3 = this.inventory.getStackInSlot(2);
        ItemStack stack4 = this.inventory.getStackInSlot(3);
        ItemStack stack5 = this.inventory.getStackInSlot(4);
        ItemStack stack6 = this.inventory.getStackInSlot(5);
        return stack1.func_190926_b() && stack2.func_190926_b() && stack3.func_190926_b() && stack4.func_190926_b() && stack5.func_190926_b() && stack6.func_190926_b();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    public void loadData(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
    }

    public void dropAsItem(World world, BlockPos pos) {
        ItemStack stack = new ItemStack(ModBlocks.PIZZA_BAG);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (!this.isEmpty()) {
            stack.func_77982_d(compound);
        }
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }
}

