/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.world.gen;

import com.tiviacz.pizzacraft.blocks.trees.BlockLeavesGrowing;
import com.tiviacz.pizzacraft.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenOliveTree
extends WorldGenAbstractTree {
    public static final IBlockState LOG = ModBlocks.OLIVE_LOG.func_176223_P();
    public static final IBlockState LEAF = ModBlocks.OLIVE_LEAVES.func_176223_P();
    public static final IBlockState LEAF_GROWING = ModBlocks.OLIVE_LEAVES_GROWING.func_176223_P();
    public static final IBlockState LEAF_GROWING_1 = ModBlocks.OLIVE_LEAVES_GROWING.func_176223_P().func_177226_a((IProperty)BlockLeavesGrowing.AGE, (Comparable)Integer.valueOf(1));

    public WorldGenOliveTree() {
        super(false);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)ModBlocks.OLIVE_SAPLING);
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + i);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = position.func_177958_n() - l2; i3 <= position.func_177958_n() + l2; ++i3) {
                        int j1 = i3 - position.func_177958_n();
                        for (int k1 = position.func_177952_p() - l2; k1 <= position.func_177952_p() + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                            if (rand.nextInt(10) < 2) {
                                if (rand.nextInt(10) > 5) {
                                    this.func_175903_a(worldIn, blockpos, LEAF_GROWING_1);
                                    continue;
                                }
                                this.func_175903_a(worldIn, blockpos, LEAF_GROWING);
                                continue;
                            }
                            this.func_175903_a(worldIn, blockpos, LEAF);
                        }
                    }
                }
                for (int j2 = 0; j2 < i; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), LOG);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151578_c || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }
}

