/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.google.common.base.Strings;
import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.TileEntityVehicleCrate;
import com.mrcrayfish.vehicle.util.Bounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVehicleCrate
extends BlockRotatedObject {
    private static final List<ResourceLocation> REGISTERED_CRATES = new ArrayList<ResourceLocation>();
    private static final AxisAlignedBB PANEL = new Bounds(0, 0, 0, 16, 2, 16).toAABB();

    public BlockVehicleCrate() {
        super(Material.field_151573_f, MapColor.field_151680_x, "vehicle:vehicle_crate");
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(VehicleMod.CREATIVE_TAB);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.isBelowBlockTopSolid(world, pos) && this.canOpen(world, pos);
    }

    private boolean canOpen(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos pos2 = pos.func_177972_a(side);
            if (world.func_184144_a(null, Block.field_185505_j.func_186670_a(pos2)).isEmpty() && this.isBelowBlockTopSolid(world, pos2)) continue;
            return false;
        }
        return true;
    }

    private boolean isBelowBlockTopSolid(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileEntity = source.func_175625_s(pos);
        if (tileEntity instanceof TileEntityVehicleCrate && ((TileEntityVehicleCrate)tileEntity).isOpened()) {
            return PANEL;
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityVehicleCrate && ((TileEntityVehicleCrate)tileEntity).isOpened()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PANEL);
            return;
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.UP && playerIn.func_184586_b(hand).func_77973_b() == ModItems.WRENCH) {
            this.openCrate(world, pos, state, (EntityLivingBase)playerIn);
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer && ((EntityPlayer)placer).field_71075_bZ.field_75098_d) {
            this.openCrate(worldIn, pos, state, placer);
        }
    }

    private void openCrate(World world, BlockPos pos, IBlockState state, EntityLivingBase placer) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityVehicleCrate && this.canOpen(world, pos)) {
            if (world.field_72995_K) {
                this.spawnCrateOpeningParticles(world, pos, state);
            } else {
                ((TileEntityVehicleCrate)tileEntity).open(placer.func_110124_au());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCrateOpeningParticles(World world, BlockPos pos, IBlockState state) {
        double y = 0.875;
        ParticleDigging.Factory factory = new ParticleDigging.Factory();
        for (int j = 0; j < 4; ++j) {
            for (int l = 0; l < 4; ++l) {
                double x = ((double)j + 0.5) / 4.0;
                double z = ((double)l + 0.5) / 4.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)((ParticleDigging)factory.func_178902_a(0, world, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, x - 0.5, y - 0.5, z - 0.5, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos));
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVehicleCrate();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound blockEntityTag;
        String vehicle = "vehicle";
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("BlockEntityTag", 10) && !Strings.isNullOrEmpty((String)(vehicle = (blockEntityTag = tagCompound.func_74775_l("BlockEntityTag")).func_74779_i("vehicle")))) {
            vehicle = I18n.func_135052_a((String)("entity.vehicle." + vehicle.split(":")[1] + ".name"), (Object[])new Object[0]);
            tooltip.add(TextFormatting.BLUE + vehicle);
        }
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)(this.func_149739_a() + ".info"), (Object[])new Object[]{vehicle});
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        REGISTERED_CRATES.forEach(resourceLocation -> {
            NBTTagCompound blockEntityTag = new NBTTagCompound();
            blockEntityTag.func_74778_a("vehicle", resourceLocation.toString());
            blockEntityTag.func_74768_a("engineTier", EngineTier.WOOD.ordinal());
            blockEntityTag.func_74768_a("wheelType", WheelType.STANDARD.ordinal());
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74782_a("BlockEntityTag", (NBTBase)blockEntityTag);
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77982_d(itemTag);
            items.add((Object)stack);
        });
    }

    public static ItemStack create(ResourceLocation entityId, int color, @Nullable EngineTier engineTier, @Nullable WheelType wheelType, int wheelColor) {
        NBTTagCompound blockEntityTag = new NBTTagCompound();
        blockEntityTag.func_74778_a("vehicle", entityId.toString());
        blockEntityTag.func_74768_a("color", color);
        if (engineTier != null) {
            blockEntityTag.func_74768_a("engineTier", engineTier.ordinal());
        }
        if (wheelType != null) {
            blockEntityTag.func_74768_a("wheelType", wheelType.ordinal());
            if (wheelColor != -1) {
                blockEntityTag.func_74768_a("wheelColor", wheelColor);
            }
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("BlockEntityTag", (NBTBase)blockEntityTag);
        ItemStack stack = new ItemStack(ModBlocks.VEHICLE_CRATE);
        stack.func_77982_d(itemTag);
        return stack;
    }

    public static void registerVehicle(String id) {
        ResourceLocation resource = new ResourceLocation("vehicle", id);
        if (!REGISTERED_CRATES.contains(resource)) {
            REGISTERED_CRATES.add(resource);
            Collections.sort(REGISTERED_CRATES);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityVehicleCrate) {
            ItemStack drop = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tileEntityTag = new NBTTagCompound();
            tileEntity.func_189515_b(tileEntityTag);
            tileEntityTag.func_82580_o("x");
            tileEntityTag.func_82580_o("y");
            tileEntityTag.func_82580_o("z");
            tileEntityTag.func_82580_o("id");
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
            drop.func_77982_d(compound);
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
            return world.func_175698_g(pos);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }
}

