/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.util;

import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformationBuilder {
    private float tx;
    private float ty;
    private float tz;
    private float rx;
    private float ry;
    private float rz;
    private float s;

    public TransformationBuilder setTranslation(float translateX, float translateY, float translateZ) {
        this.tx = translateX;
        this.ty = translateY;
        this.tz = translateZ;
        return this;
    }

    public TransformationBuilder setRotation(float rotationX, float rotationY, float rotationZ) {
        this.rx = rotationX;
        this.ry = rotationY;
        this.rz = rotationZ;
        return this;
    }

    public TransformationBuilder setScale(float scale) {
        this.s = scale;
        return this;
    }

    public TRSRTransformation build() {
        Vector3f translation = new Vector3f(this.tx / 16.0f, this.ty / 16.0f, this.tz / 16.0f);
        Quat4f rotation = TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(this.rx, this.ry, this.rz));
        Vector3f scale = new Vector3f(this.s, this.s, this.s);
        return new TRSRTransformation(translation, rotation, scale, null);
    }
}

