/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LockingItemCloningRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public final Ingredient locking;
    public final NonNullList<Ingredient> blanks;
    public final ItemStack result;

    public LockingItemCloningRecipe(Ingredient locking, NonNullList<Ingredient> blanks, ItemStack result) {
        this.locking = locking;
        this.blanks = blanks;
        this.result = result;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ItemStack locking = ItemStack.field_190927_a;
        ArrayList blanks = Lists.newArrayList();
        for (int a = 0; a < inv.func_70302_i_(); ++a) {
            ItemStack stack = inv.func_70301_a(a);
            if (stack.func_190926_b()) continue;
            if (LocksUtil.hasKey(stack, "Id") && this.locking.test((Object)stack)) {
                locking = stack;
                continue;
            }
            blanks.add(stack);
        }
        return !locking.func_190926_b() && RecipeMatcher.findMatches((List)blanks, this.blanks) != null;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList stacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int a = 0; a < inv.func_70302_i_(); ++a) {
            ItemStack stack = inv.func_70301_a(a);
            if (!this.locking.test((Object)stack)) continue;
            stacks.set(a, (Object)stack.func_77946_l());
        }
        return stacks;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        ItemStack locking = ItemStack.field_190927_a;
        for (int a = 0; a < inventory.func_70302_i_() && locking.func_190926_b(); ++a) {
            ItemStack stack = inventory.func_70301_a(a);
            if (stack.func_190926_b() || !LocksUtil.hasKey(stack, "Id") || !this.locking.test((Object)stack)) continue;
            locking = stack;
        }
        return LockingItem.copyId(locking, this.result.func_77946_l());
    }

    public boolean func_194133_a(int width, int height) {
        return this.blanks.size() + 1 <= width * height;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext ctx, JsonObject json) {
            Ingredient locking = CraftingHelper.getIngredient((JsonElement)json.get("locking"), (JsonContext)ctx);
            NonNullList<Ingredient> blanks = Factory.deserializeIngredients(JsonUtils.func_151214_t((JsonObject)json, (String)"blanks"));
            if (blanks.isEmpty()) {
                throw new JsonParseException("Not enough items for locking item cloning recipe");
            }
            if (blanks.size() > 8) {
                throw new JsonParseException("Too many items for locking item cloning recipe");
            }
            ItemStack result = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new LockingItemCloningRecipe(locking, blanks, result);
        }

        private static NonNullList<Ingredient> deserializeIngredients(JsonArray array) {
            NonNullList list = NonNullList.func_191196_a();
            for (int a = 0; a < array.size(); ++a) {
                Ingredient ingredient = ShapedRecipes.func_193361_a((JsonElement)array.get(a));
                if (ingredient == Ingredient.field_193370_a) continue;
                list.add((Object)ingredient);
            }
            return list;
        }
    }
}

