/*
 * Decompiled with CFR 0.152.
 */
package com.spjoes.extraons.apps.karaoke;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.core.Laptop;
import com.spjoes.extraons.RunnableSelectFile;
import com.spjoes.extraons.apps.karaoke.Karaoke;
import com.spjoes.extraons.items.ItemLinkable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class ApplicationKaraoke
extends Application {
    private Layout menuLayout;
    private Layout noMicLayout;
    private Layout noMicHeldLayout;
    private Button openFileButton;
    private Label noMicLabel;
    private RunnableSelectFile select;
    private Karaoke karaoke;

    public void init(@Nullable NBTTagCompound intent) {
        this.menuLayout = new Layout(100, 100);
        this.openFileButton = new Button(5, 75, "Open file");
        this.openFileButton.setSize(90, 20);
        this.openFileButton.setClickListener((x, y, button) -> {
            if (this.select == null) {
                this.select = new RunnableSelectFile();
                new Thread(this.select).start();
            }
        });
        this.openFileButton.setToolTip("Opens file from your computer", "I mean your real computer, the one you're using to play Minecraft right now");
        this.menuLayout.addComponent((Component)this.openFileButton);
        this.noMicLayout = new Layout(100, 100);
        this.noMicLayout.setBackground((gui, mc, x, y, w, h, mx, my, active) -> {
            mc.field_71466_p.func_78276_b("You don't have a", x, y + 36, 0xFF0000);
            mc.field_71466_p.func_78276_b("a device linked", x, y + 46, 0xFF0000);
            mc.field_71466_p.func_78276_b("to this laptop.", x, y + 56, 0xFF0000);
        });
        this.noMicHeldLayout = new Layout(100, 100);
        this.noMicHeldLayout.setBackground((gui, mc, x, y, w, h, mx, my, active) -> {
            mc.field_71466_p.func_78276_b("You don't have a", x, y + 26, 0xFF0000);
            mc.field_71466_p.func_78276_b("microphone in your", x, y + 36, 0xFF0000);
            mc.field_71466_p.func_78276_b("hand, or a headset", x, y + 46, 0xFF0000);
            mc.field_71466_p.func_78276_b("on your head.", x, y + 56, 0xFF0000);
        });
        EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
        InventoryPlayer inv = pl.field_71071_by;
        boolean hasMic = false;
        BlockPos c = new BlockPos((Vec3i)Laptop.getPos());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!ItemLinkable.isLinked(inv.func_70301_a(i), c)) continue;
            hasMic = true;
        }
        AtomicBoolean holdingLinkable = new AtomicBoolean(false);
        ItemLinkable.getLinkables().forEach(arg_0 -> ApplicationKaraoke.lambda$init$3((EntityPlayer)pl, holdingLinkable, arg_0));
        if (!hasMic) {
            this.setCurrentLayout(this.noMicLayout);
        } else if (!holdingLinkable.get()) {
            this.setCurrentLayout(this.noMicHeldLayout);
        } else {
            this.setCurrentLayout(this.menuLayout);
        }
    }

    public void onTick() {
        super.onTick();
        if (this.select != null && this.select.isClosed()) {
            if (this.select.isFileSelected()) {
                ZipFile zip = null;
                File music = null;
                String text = null;
                try {
                    String zipPath = this.select.getSelectedFile().getAbsolutePath();
                    zip = new ZipFile(zipPath);
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        String line;
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                        if ((name.equalsIgnoreCase("music.ogg") || name.equalsIgnoreCase("music.mp3")) && music == null) {
                            String tmpFile = Minecraft.func_71410_x().field_71412_D + "/data.tmp";
                            FileSystem fs = FileSystems.newFileSystem(Paths.get(zipPath, new String[0]), null);
                            Path toExt = fs.getPath(name, new String[0]);
                            File f = new File(tmpFile);
                            if (f.exists()) {
                                f.delete();
                            }
                            Files.copy(toExt, Paths.get(tmpFile, new String[0]), new CopyOption[0]);
                            music = new File(tmpFile);
                            continue;
                        }
                        if (!name.equalsIgnoreCase("lyrics.json")) continue;
                        StringBuilder fileContent = new StringBuilder();
                        while ((line = in.readLine()) != null) {
                            fileContent.append(line);
                            fileContent.append('\n');
                        }
                        text = fileContent.toString();
                    }
                    this.karaoke = new Karaoke(this, music, text);
                    this.setCurrentLayout(new Layout(200, 100));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.select = null;
        }
        if (this.karaoke != null) {
            this.karaoke.onTick();
        }
    }

    public String getWindowTitle() {
        if (this.karaoke != null) {
            return this.karaoke.getNameAndArtist();
        }
        return super.getWindowTitle();
    }

    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        super.render(laptop, mc, x, y, mouseX, mouseY, active, partialTicks);
        if (this.karaoke != null) {
            this.karaoke.render(mc, x, y, partialTicks);
        }
    }

    public void load(NBTTagCompound arg0) {
    }

    public void save(NBTTagCompound arg0) {
    }

    public void onClose() {
        super.onClose();
        if (this.karaoke != null) {
            this.karaoke.stop();
            this.karaoke = null;
        }
    }

    public void menu() {
        this.setCurrentLayout(this.menuLayout);
        this.karaoke = null;
    }

    private static /* synthetic */ void lambda$init$3(EntityPlayer pl, AtomicBoolean holdingLinkable, ItemLinkable linkable) {
        EntityEquipmentSlot[] slots;
        for (EntityEquipmentSlot slot : slots = linkable.getCorrectSlots()) {
            if (pl.func_184582_a(slot).func_77973_b() != linkable) continue;
            holdingLinkable.set(true);
        }
    }
}

