/*
 * Decompiled with CFR 0.152.
 */
package com.spjoes.extraons.apps.karaoke;

import com.google.gson.Gson;
import com.spjoes.extraons.apps.karaoke.ApplicationKaraoke;
import com.spjoes.extraons.apps.karaoke.KaraokeLine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import net.minecraft.client.Minecraft;

public class Karaoke {
    private ApplicationKaraoke parent;
    private BasicPlayer player;
    private ArrayList<KaraokeLine> lines;
    private String nameAndArtist;
    private Object data;
    private static final Gson GSON = new Gson();
    private int pos = 0;
    private int lineIndex = 0;

    public Karaoke(ApplicationKaraoke parent, File music, String json) throws Throwable {
        this.parent = parent;
        HashMap list = (HashMap)GSON.fromJson(json, HashMap.class);
        this.nameAndArtist = "\"" + list.get("name") + "\" - " + list.get("artist");
        ArrayList linesRaw = (ArrayList)list.get("lyrics");
        this.lines = new ArrayList();
        linesRaw.forEach(theLine -> this.lines.add(new KaraokeLine((String)theLine.get((Object)"text"), (int)((Double)theLine.get((Object)"start")).doubleValue() * 20, (int)((Double)theLine.get((Object)"duration")).doubleValue() * 20)));
        this.player = new BasicPlayer();
        this.player.open(music);
        this.player.play();
    }

    public String getNameAndArtist() {
        return this.nameAndArtist;
    }

    public void onTick() {
        if (this.player.getStatus() == 0) {
            ++this.pos;
            if (this.pos >= 0) {
                KaraokeLine line;
                if (this.lineIndex < this.lines.size() - 1 && this.lines.get(this.lineIndex + 1).getStart() == this.pos) {
                    ++this.lineIndex;
                } else if (this.lineIndex == this.lines.size() - 1 && this.pos > (line = this.lines.get(this.lineIndex)).getStart() + line.getDuration()) {
                    this.stop();
                    this.parent.menu();
                }
                this.lines.get(this.lineIndex).onTick();
            }
        }
    }

    public void render(Minecraft mc, int x, int y, float partialTicks) {
        this.lines.get(this.lineIndex).render(mc, x, y, partialTicks);
    }

    public void stop() {
        try {
            this.player.stop();
        }
        catch (BasicPlayerException basicPlayerException) {
            // empty catch block
        }
    }
}

