/*
 * Decompiled with CFR 0.152.
 */
package com.spjoes.extraons.apps.karaoke;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class KaraokeLine {
    private List<String> lines;
    private int start;
    private int duration;
    private int position;
    private int height;
    private int totalWidth;

    public KaraokeLine(String text, int start, int duration) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.lines = new ArrayList<String>();
        String[] split = text.split(" ");
        String lineToAdd = "";
        for (String word : split) {
            if (fr.func_78256_a(lineToAdd + word) > 200) {
                this.lines.add(lineToAdd);
                lineToAdd = word + " ";
                continue;
            }
            lineToAdd = lineToAdd + word + " ";
        }
        if (lineToAdd.charAt(lineToAdd.length() - 1) == ' ') {
            lineToAdd = lineToAdd.substring(0, lineToAdd.length() - 1);
        }
        this.lines.add(lineToAdd);
        this.height = (this.lines.size() - 1) * 10 + 8;
        this.start = start;
        this.duration = duration;
        this.totalWidth = 0;
        for (String line : this.lines) {
            this.totalWidth += fr.func_78256_a(line);
        }
        this.position = 0;
    }

    public void render(Minecraft mc, int x, int y, float partialTicks) {
        String line;
        int i;
        ScaledResolution sr = new ScaledResolution(mc);
        int scale = sr.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scale), (int)(mc.field_71440_d - (y + 100) * scale), (int)(200 * scale), (int)(100 * scale));
        float realPosition = (float)this.position + partialTicks;
        for (int i2 = 0; i2 < this.lines.size(); ++i2) {
            String line2 = this.lines.get(i2);
            int w = mc.field_71466_p.func_78256_a(line2);
            mc.field_71466_p.func_78276_b(line2, x + 100 - w / 2, y + 50 - this.height / 2 + i2 * 10, 0xFFFFFF);
        }
        int currW = 0;
        ArrayList<float[]> scissors = new ArrayList<float[]>();
        for (i = 0; i < this.lines.size(); ++i) {
            line = this.lines.get(i);
            float[] scissor = new float[2];
            int w = mc.field_71466_p.func_78256_a(line);
            scissor[0] = 100 - mc.field_71466_p.func_78256_a(line) / 2;
            float progress = (float)this.totalWidth * (realPosition / (float)this.duration);
            int progrW = (int)((float)this.totalWidth * progress) - currW * this.totalWidth;
            scissor[1] = (float)currW <= progress ? ((float)(currW + w) >= progress ? (float)(progrW / this.totalWidth) : (float)w) : 0.0f;
            scissors.add(scissor);
            currW += w;
        }
        for (i = 0; i < this.lines.size(); ++i) {
            GL11.glScissor((int)((int)((float)x + ((float[])scissors.get(i))[0]) * scale), (int)(mc.field_71440_d - (y + 50 - this.height / 2 + (i + 1) * 10) * scale), (int)((int)(((float[])scissors.get(i))[1] * (float)scale)), (int)(10 * scale));
            line = this.lines.get(i);
            int w = mc.field_71466_p.func_78256_a(line);
            mc.field_71466_p.func_78276_b(line, x + 100 - w / 2, y + 50 - this.height / 2 + i * 10, 0);
        }
        GL11.glDisable((int)3089);
    }

    public void onTick() {
        this.position = Math.min(this.position + 1, this.duration);
    }

    public int getStart() {
        return this.start;
    }

    public int getDuration() {
        return this.duration;
    }
}

