/*
 * Decompiled with CFR 0.152.
 */
package com.spjoes.extraons.items;

import com.mrcrayfish.device.init.DeviceBlocks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ItemLinkable
extends Item {
    private static final ArrayList<ItemLinkable> LINKABLES = new ArrayList();

    public ItemLinkable() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        LINKABLES.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && stack.func_77942_o()) {
            stack.func_77982_d(null);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == DeviceBlocks.LAPTOP) {
            if (ItemLinkable.isLinked(stack, pos)) {
                return EnumActionResult.PASS;
            }
            if (!world.field_72995_K) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound nbt = stack.func_77978_p();
                nbt.func_74783_a("devicePos", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static boolean hasDevicePos(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("devicePos", 11);
    }

    public static boolean isLinked(ItemStack stack, BlockPos pos) {
        int[] linkpos;
        return stack.func_77973_b() instanceof ItemLinkable && ItemLinkable.hasDevicePos(stack) && (linkpos = stack.func_77978_p().func_74759_k("devicePos"))[0] == pos.func_177958_n() && linkpos[1] == pos.func_177956_o() && linkpos[2] == pos.func_177952_p();
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemLinkable.hasDevicePos(stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String colText;
        block6: {
            colText = "Color: ";
            try {
                if (stack.func_77952_i() == 16) {
                    colText = colText + TextFormatting.RED + TextFormatting.BOLD + "R" + TextFormatting.GOLD + TextFormatting.BOLD + "A" + TextFormatting.YELLOW + TextFormatting.BOLD + "I" + TextFormatting.GREEN + TextFormatting.BOLD + "N" + TextFormatting.DARK_GREEN + TextFormatting.BOLD + "B" + TextFormatting.BLUE + TextFormatting.BOLD + "O" + TextFormatting.LIGHT_PURPLE + TextFormatting.BOLD + "W";
                    break block6;
                }
                if (stack.func_77952_i() < 16) {
                    EnumDyeColor col = EnumDyeColor.func_176764_b((int)stack.func_77952_i());
                    Field f = EnumDyeColor.class.getDeclaredField("chatColor");
                    f.setAccessible(true);
                    TextFormatting tf = (TextFormatting)f.get(col);
                    colText = colText + tf + TextFormatting.BOLD + col.func_192396_c().toUpperCase().replaceAll("_", " ");
                    break block6;
                }
                throw new Exception();
            }
            catch (Exception e) {
                colText = colText + TextFormatting.OBFUSCATED + TextFormatting.BOLD + "unknown";
            }
        }
        tooltip.add(colText);
        if (ItemLinkable.hasDevicePos(stack)) {
            int[] pos = stack.func_77978_p().func_74759_k("devicePos");
            tooltip.add(TextFormatting.AQUA + "Is linked to device at pos");
            StringBuilder sb = new StringBuilder();
            sb.append(TextFormatting.RED);
            sb.append(TextFormatting.BOLD);
            sb.append("X: ");
            sb.append(TextFormatting.RESET);
            sb.append(TextFormatting.GRAY);
            sb.append(pos[0]);
            sb.append(", ");
            sb.append(TextFormatting.GREEN);
            sb.append(TextFormatting.BOLD);
            sb.append("Y: ");
            sb.append(TextFormatting.RESET);
            sb.append(TextFormatting.GRAY);
            sb.append(pos[1]);
            sb.append(", ");
            sb.append(TextFormatting.BLUE);
            sb.append(TextFormatting.BOLD);
            sb.append("Z: ");
            sb.append(TextFormatting.RESET);
            sb.append(TextFormatting.GRAY);
            sb.append(pos[2]);
            tooltip.add(sb.toString());
        } else {
            tooltip.add("Right-click a computer to link it");
        }
    }

    public abstract EntityEquipmentSlot[] getCorrectSlots();

    public static ArrayList<ItemLinkable> getLinkables() {
        return LINKABLES;
    }
}

