/*
 * Decompiled with CFR 0.152.
 */
package com.spjoes.extraons.proxies;

import com.spjoes.extraons.blocks.BlockConsole;
import com.spjoes.extraons.client.TESRCentralUnit;
import com.spjoes.extraons.handlers.ItemHandler;
import com.spjoes.extraons.proxies.CommonProxy;
import com.spjoes.extraons.tileentities.TileEntityCentralUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerModels() {
        for (EnumDyeColor col : EnumDyeColor.values()) {
            this.registerModel(ItemHandler.MICROPHONE, col.func_176765_a(), new ResourceLocation("extraons", "mic/" + col.func_176610_l()));
            this.registerModel(ItemHandler.HEADPHONES, col.func_176765_a(), new ResourceLocation("extraons", "headphones/" + col.func_176610_l()));
        }
        for (int i = 0; i < 3; ++i) {
            BlockConsole.EnumConsoleType type = BlockConsole.EnumConsoleType.fromMeta(i);
            this.registerModel(ItemHandler.CONSOLE, i, new ResourceLocation("extraons", "console_" + type.func_176610_l()));
            this.registerModel(ItemHandler.CONTROLLER, i, new ResourceLocation("extraons", "controller_" + type.func_176610_l()));
        }
        this.registerModel(ItemHandler.MICROPHONE, 16, new ResourceLocation("extraons", "mic/white"));
        this.registerModel(ItemHandler.HEADPHONES, 16, new ResourceLocation("extraons", "headphones/white"));
        this.registerModel(ItemHandler.MONITOR_ITEM, 0, new ResourceLocation("extraons", "monitor"));
        this.registerModel(ItemHandler.MOUSE_ITEM, 0, new ResourceLocation("extraons", "mouse"));
        this.registerModel(ItemHandler.CENTRAL_UNIT_ITEM, 0, new ResourceLocation("extraons", "central_unit"));
        this.registerModel(ItemHandler.HDMI_CABLE, 0, new ResourceLocation("extraons", "hdmi_cable"));
        this.registerModel(ItemHandler.TAB_ICON, 0, new ResourceLocation("extraons", "tab_icon"));
        this.registerModel(ItemHandler.PHONE, 0, new ResourceLocation("extraons", "phone"));
        this.registerModel(ItemHandler.TV_ITEM, 0, new ResourceLocation("extraons", "tv"));
        this.registerModel(ItemHandler.SMB, 0, new ResourceLocation("extraons", "smb"));
        this.registerModel(ItemHandler.KEYBOARD, 0, new ResourceLocation("extraons", "keyboard"));
        this.registerModel(ItemHandler.CHAIR, 0, new ResourceLocation("extraons", "chair"));
        this.registerModel(ItemHandler.MIC_HANDLE, 0, new ResourceLocation("extraons", "mic_handle"));
        this.registerModel(ItemHandler.MIC_CABLE, 0, new ResourceLocation("extraons", "mic_cable"));
    }

    @Override
    public void registerItemColors() {
        IItemColor jeb = (stack, tintIndex) -> {
            int time = (int)(Minecraft.func_71386_F() % 6000L);
            int r = 0;
            int g = 0;
            int b = 0;
            if (time < 1000) {
                r = 255;
                g = (int)((double)time / 1000.0 * 255.0);
            } else if (time < 2000) {
                g = 255;
                r = (int)((1.0 - (double)(time - 1000) / 1000.0) * 255.0);
            } else if (time < 3000) {
                g = 255;
                b = (int)((double)(time - 2000) / 1000.0 * 255.0);
            } else if (time < 4000) {
                b = 255;
                g = (int)((1.0 - (double)(time - 3000) / 1000.0) * 255.0);
            } else if (time < 5000) {
                b = 255;
                r = (int)((double)(time - 4000) / 1000.0 * 255.0);
            } else {
                r = 255;
                b = (int)((1.0 - (double)(time - 5000) / 1000.0) * 255.0);
            }
            return tintIndex == 1 && stack.func_77952_i() == 16 ? (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF : 0xFFFFFF;
        };
        Minecraft.func_71410_x().getItemColors().func_186730_a(jeb, new Item[]{ItemHandler.HEADPHONES, ItemHandler.MICROPHONE});
    }

    private void registerModel(Item item, int damage, ResourceLocation rl) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)damage, (ModelResourceLocation)new ModelResourceLocation(rl, "inventory"));
    }

    @Override
    public void registerTERenders() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCentralUnit.class, (TileEntitySpecialRenderer)new TESRCentralUnit());
    }
}

