/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        if (entity instanceof AbstractHorseEntity) {
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof SheepEntity || entity instanceof LlamaEntity || entity instanceof PigEntity || entity instanceof DonkeyEntity || entity instanceof HorseEntity || entity instanceof MuleEntity) {
            if (!(entity instanceof AnimalEntity)) {
                return false;
            }
            AnimalEntity animal = (AnimalEntity)entity;
            return !animal.func_70631_g_();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        try {
            entitystring = entity.toString();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (name != "") {
            entity.func_200203_b((ITextComponent)new StringTextComponent(name));
        }
    }

    public static void addPotionEffect(Entity entity, Effect effect, Integer ms) {
        EffectInstance freeze = new EffectInstance(effect, ms / 50);
        LivingEntity le = (LivingEntity)entity;
        le.func_195064_c(freeze);
    }

    public static void removePotionEffect(Entity entity, Effect effect) {
        LivingEntity le = (LivingEntity)entity;
        le.func_195063_d(effect);
    }

    public static void chargeEntity(Entity entity) {
        World world = entity.func_130014_f_();
        Vec3d evec = entity.func_174791_d();
        LightningBoltEntity lightning = new LightningBoltEntity(world, evec.field_72450_a, evec.field_72448_b, evec.field_72449_c, true);
        lightning.func_184221_a(new UUID(0L, GlobalVariables.random.nextInt() * 1000000));
        entity.func_70077_a(lightning);
        entity.func_70066_B();
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof MobEntity)) {
            return;
        }
        MobEntity mobfrom = (MobEntity)from;
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EquipmentSlotType.MAINHAND) || (itemstack = mobfrom.func_184582_a(equipmentslottype)).func_190926_b()) continue;
            to.func_184201_a(equipmentslottype, itemstack.func_77946_l());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(PlayerEntity player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((LivingEntity)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(LivingEntity entity, int halfheartdamage) {
        float newhealth = entity.func_110143_aJ() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
            return false;
        }
        entity.func_70097_a(DamageSource.field_76376_m, 0.1f);
        entity.func_70606_j(newhealth);
        return true;
    }
}

