/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFunctions {
    public static void generateEntityDropsFromLootTable(World world) {
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        GlobalVariables.entitydrops = new HashMap();
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockPos pos = new BlockPos(0, 0, 0);
        ItemStack lootingsword = new ItemStack((IItemProvider)Items.field_151048_u, 1);
        lootingsword.func_77966_a(Enchantments.field_185304_p, 10);
        fakeplayer.func_184201_a(EquipmentSlotType.MAINHAND, lootingsword);
        Collection entitytypes = ForgeRegistries.ENTITIES.getValues();
        for (EntityType type : entitytypes) {
            Entity entity;
            if (type == null || (entity = type.func_200721_a(world)) == null || !(entity instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            ResourceLocation lootlocation = le.func_200600_R().func_220348_g();
            LootTable loottable = server.func_200249_aQ().func_186521_a(lootlocation);
            LootContext context = new LootContext.Builder((ServerWorld)world).func_216023_a(world.func_201674_k()).func_186469_a(1000000.0f).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216284_d, (Object)fakeplayer).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.func_76365_a((PlayerEntity)fakeplayer)).func_216022_a(LootParameterSets.field_216263_d);
            ArrayList<Item> alldrops = new ArrayList<Item>();
            for (int n = 0; n < (Integer)ConfigHandler.COLLECTIVE.loopsAmountUsedToGetAllEntityDrops.get(); ++n) {
                List newdrops = loottable.func_216113_a(context);
                for (ItemStack newdrop : newdrops) {
                    Item newitem = newdrop.func_77973_b();
                    if (alldrops.contains(newitem) || newitem.equals(Items.field_190931_a)) continue;
                    alldrops.add(newitem);
                }
            }
            GlobalVariables.entitydrops.put(type, alldrops);
        }
    }

    public static Boolean isTool(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ShovelItem || item instanceof AxeItem || item instanceof PickaxeItem || item instanceof SwordItem || item instanceof HoeItem) {
            return true;
        }
        String itemname = item.toString().toLowerCase();
        if (itemname.contains("_sword") || itemname.contains("_pickaxe") || itemname.contains("_axe") || itemname.contains("_shovel") || itemname.contains("_hoe")) {
            return true;
        }
        return false;
    }

    public static void shrinkGiveOrDropItemStack(PlayerEntity player, Hand hand, ItemStack used, ItemStack give) {
        used.func_190918_g(1);
        if (used.func_190926_b()) {
            Item giveitem = give.func_77973_b();
            int maxstacksize = give.func_77976_d();
            NonNullList inventory = player.field_71071_by.field_70462_a;
            boolean increased = false;
            for (int n = 0; n < inventory.size(); ++n) {
                int slotcount;
                ItemStack slot = (ItemStack)inventory.get(n);
                if (!slot.func_77973_b().equals(giveitem) || (slotcount = slot.func_190916_E()) >= maxstacksize) continue;
                slot.func_190920_e(slotcount + 1);
                increased = true;
                break;
            }
            if (!increased) {
                player.func_184611_a(hand, give);
            }
        } else if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static void giveOrDropItemStack(PlayerEntity player, ItemStack give) {
        if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static boolean isStoneTypeItem(Item item) {
        return GlobalVariables.stoneblockitems.contains(item);
    }

    public static String itemToReadableString(Item item, int amount) {
        String itemstring = "";
        String translationkey = item.func_77658_a();
        if (translationkey.contains("block.")) {
            return BlockFunctions.blockToReadableString(Block.func_149634_a((Item)item), amount);
        }
        String[] itemspl = translationkey.replace("item.", "").split("\\.");
        itemstring = itemspl.length > 1 ? itemspl[1] : itemspl[0];
        itemstring = itemstring.replace("_", " ");
        if (amount > 1) {
            itemstring = itemstring + "s";
        }
        return itemstring;
    }

    public static String itemToReadableString(Item item) {
        return ItemFunctions.itemToReadableString(item, 1);
    }
}

