/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldFunctions {
    public static void setWorldTime(World world, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        Integer days = WorldFunctions.getTotalDaysPassed(world);
        world.func_72877_b((long)(time + days * 24000));
    }

    public static int getTotalTimePassed(World world) {
        return (int)world.func_72820_D();
    }

    public static int getTotalDaysPassed(World world) {
        Integer currenttime = WorldFunctions.getTotalTimePassed(world);
        Integer days = (int)Math.floor((double)currenttime.intValue() / 24000.0);
        return days;
    }

    public static int getWorldTime(World world) {
        return WorldFunctions.getTotalTimePassed(world) - WorldFunctions.getTotalDaysPassed(world) * 24000;
    }

    public static String getWorldDimensionName(World world) {
        String dimensionname = world.field_73011_w.toString();
        dimensionname = dimensionname.split("@")[0].replace("net.minecraft.world.dimension.", "").replace("Dimension", "");
        return dimensionname;
    }

    public static boolean isOverworld(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("overworld");
    }

    public static boolean isNether(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("nether");
    }

    public static boolean isEnd(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("end");
    }

    public static World getWorldIfInstanceOfAndNotRemote(IWorld iworld) {
        if (iworld.func_201670_d()) {
            return null;
        }
        if (iworld instanceof World) {
            return (World)iworld;
        }
        return null;
    }

    public static String getWorldPath(ServerWorld serverworld) {
        return serverworld.func_217485_w().func_75765_b().getPath();
    }
}

