/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    public static final String REMOVE_NAMED = "removeNamed";
    public static final String BANNED_MOBS = "bannedMobs";
    public static final String ALLOW_SPAWNER = "allowSpawners";
    public static final String ALLOW_SPAWN_EGG = "allowSpawnEgg";
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> globalIds;
    private final ForgeConfigSpec.BooleanValue allowSpawners;
    private final ForgeConfigSpec.BooleanValue allowSpawnEggs;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("A list of all banned mobs. If a mobs entity id is added to this list, it will not be allowed to spawn in any world.");
        this.globalIds = builder.defineList(BANNED_MOBS, new ArrayList(), val -> val instanceof String);
        builder.comment("Should banned mobs spawn from spawners?");
        this.allowSpawners = builder.define(ALLOW_SPAWNER, true);
        builder.comment("Should banned mobs spawn from spawn eggs?");
        this.allowSpawnEggs = builder.define(ALLOW_SPAWN_EGG, true);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean allowSpawnEgg() {
        return (Boolean)this.allowSpawnEggs.get();
    }

    public boolean allowSpawners() {
        return (Boolean)this.allowSpawners.get();
    }

    public List<? extends String> getBannedMobs() {
        return (List)this.globalIds.get();
    }
}

