/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.activitylog.ActivityLog;
import me.lucko.spark.common.command.Arguments;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.modules.ActivityLogModule;
import me.lucko.spark.common.command.modules.HealthModule;
import me.lucko.spark.common.command.modules.MemoryModule;
import me.lucko.spark.common.command.modules.SamplerModule;
import me.lucko.spark.common.command.modules.TickMonitoringModule;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.common.sampler.tick.TickReporter;
import me.lucko.spark.common.util.BytebinClient;
import me.lucko.spark.lib.okhttp3.OkHttpClient;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.event.ClickEvent;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;

public class SparkPlatform {
    public static final String VIEWER_URL = "https://sparkprofiler.github.io/#";
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();
    public static final BytebinClient BYTEBIN_CLIENT = new BytebinClient(OK_HTTP_CLIENT, "https://bytebin.lucko.me/", "spark-plugin");
    private final SparkPlugin plugin;
    private final List<CommandModule> commandModules;
    private final List<Command> commands;
    private final ActivityLog activityLog;
    private final TickHook tickHook;
    private final TickReporter tickReporter;
    private final TickStatistics tickStatistics;

    public SparkPlatform(SparkPlugin plugin) {
        this.plugin = plugin;
        this.commandModules = ImmutableList.of((Object)new SamplerModule(), (Object)new HealthModule(), (Object)new TickMonitoringModule(), (Object)new MemoryModule(), (Object)new ActivityLogModule());
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        for (CommandModule module : this.commandModules) {
            module.registerCommands(arg_0 -> ((ImmutableList.Builder)commandsBuilder).add(arg_0));
        }
        this.commands = commandsBuilder.build();
        this.activityLog = new ActivityLog(plugin.getPluginDirectory().resolve("activity.json"));
        this.activityLog.load();
        this.tickHook = plugin.createTickHook();
        this.tickReporter = plugin.createTickReporter();
        this.tickStatistics = this.tickHook != null ? new TickStatistics() : null;
    }

    public void enable() {
        if (this.tickHook != null) {
            this.tickHook.addCallback(this.tickStatistics);
            this.tickHook.start();
        }
        if (this.tickReporter != null) {
            this.tickReporter.addCallback(this.tickStatistics);
            this.tickReporter.start();
        }
        CpuMonitor.ensureMonitoring();
    }

    public void disable() {
        if (this.tickHook != null) {
            this.tickHook.close();
        }
        if (this.tickReporter != null) {
            this.tickReporter.close();
        }
        for (CommandModule module : this.commandModules) {
            module.close();
        }
    }

    public SparkPlugin getPlugin() {
        return this.plugin;
    }

    public ActivityLog getActivityLog() {
        return this.activityLog;
    }

    public TickHook getTickHook() {
        return this.tickHook;
    }

    public TickReporter getTickReporter() {
        return this.tickReporter;
    }

    public TickStatistics getTickStatistics() {
        return this.tickStatistics;
    }

    public void executeCommand(CommandSender sender, String[] args) {
        CommandResponseHandler resp = new CommandResponseHandler(this, sender);
        if (!sender.hasPermission("spark")) {
            resp.replyPrefixed(TextComponent.of("You do not have permission to use this command.", TextColor.RED));
            return;
        }
        if (args.length == 0) {
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").append(TextComponent.of("spark", TextColor.WHITE))).append(TextComponent.space())).append(TextComponent.of("v" + this.getPlugin().getVersion(), TextColor.GRAY))).build());
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of("Use "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("/" + this.getPlugin().getCommandName() + " help").color(TextColor.WHITE)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.runCommand("/" + this.getPlugin().getCommandName() + " help"))).build())).append(TextComponent.of(" to view usage information."))).build());
            return;
        }
        ArrayList<String> rawArgs = new ArrayList<String>(Arrays.asList(args));
        String alias = rawArgs.remove(0).toLowerCase();
        for (Command command : this.commands) {
            if (!command.aliases().contains(alias)) continue;
            try {
                command.executor().execute(this, sender, resp, new Arguments(rawArgs));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                resp.replyPrefixed(TextComponent.of(e.getMessage(), TextColor.RED));
            }
            return;
        }
        this.sendUsage(resp);
    }

    public List<String> tabCompleteCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("spark")) {
            return Collections.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (args.length <= 1) {
            List<String> mainCommands = this.commands.stream().map(c -> c.aliases().get(0)).collect(Collectors.toList());
            return TabCompleter.create().at(0, CompletionSupplier.startsWith(mainCommands)).complete(arguments);
        }
        String alias = (String)arguments.remove(0);
        for (Command command : this.commands) {
            if (!command.aliases().contains(alias)) continue;
            return command.tabCompleter().completions(this, sender, arguments);
        }
        return Collections.emptyList();
    }

    private void sendUsage(CommandResponseHandler sender) {
        sender.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").append(TextComponent.of("spark", TextColor.WHITE))).append(TextComponent.space())).append(TextComponent.of("v" + this.getPlugin().getVersion(), TextColor.GRAY))).build());
        for (Command command : this.commands) {
            String usage = "/" + this.getPlugin().getCommandName() + " " + command.aliases().get(0);
            ClickEvent clickEvent = ClickEvent.suggestCommand(usage);
            sender.reply((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").append((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder(">").color(TextColor.GOLD)).decoration(TextDecoration.BOLD, true)).build())).append(TextComponent.space())).append((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder(usage).color(TextColor.GRAY)).clickEvent(clickEvent)).build())).build());
            for (Command.ArgumentInfo arg : command.arguments()) {
                if (arg.requiresParameter()) {
                    sender.reply((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("       ").append(TextComponent.of("[", TextColor.DARK_GRAY))).append(TextComponent.of("--" + arg.argumentName(), TextColor.GRAY))).append(TextComponent.space())).append(TextComponent.of("<" + arg.parameterDescription() + ">", TextColor.DARK_GRAY))).append(TextComponent.of("]", TextColor.DARK_GRAY))).build());
                    continue;
                }
                sender.reply((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("       ").append(TextComponent.of("[", TextColor.DARK_GRAY))).append(TextComponent.of("--" + arg.argumentName(), TextColor.GRAY))).append(TextComponent.of("]", TextColor.DARK_GRAY))).build());
            }
        }
    }
}

