/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.activitylog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.lucko.spark.common.command.sender.CommandSender;

public class ActivityLog {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser PARSER = new JsonParser();
    private final Path file;
    private final LinkedList<Activity> log = new LinkedList();
    private final Object[] mutex = new Object[0];

    public ActivityLog(Path file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLog(Activity activity) {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            this.log.addFirst(activity);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.save();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getLog() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new LinkedList<Activity>(this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        JsonArray array = new JsonArray();
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            for (Activity activity : this.log) {
                if (activity.shouldExpire()) continue;
                array.add((JsonElement)activity.serialize());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);
                Object object = null;
                try {
                    GSON.toJson((JsonElement)array, (Appendable)writer);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        JsonArray array;
        Object[] objectArray;
        if (!Files.exists(this.file, new LinkOption[0])) {
            Object[] objectArray2 = this.mutex;
            synchronized (this.mutex) {
                this.log.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        try {
            objectArray = null;
            try (BufferedReader reader = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                array = PARSER.parse((Reader)reader).getAsJsonArray();
            }
            catch (Throwable object) {
                objectArray = object;
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        boolean save = false;
        objectArray = this.mutex;
        synchronized (this.mutex) {
            this.log.clear();
            for (JsonElement element : array) {
                try {
                    Activity activity = Activity.deserialize(element);
                    if (activity.shouldExpire()) {
                        save = true;
                        continue;
                    }
                    this.log.add(activity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var3_7] (shouldn't be in output)
            if (save) {
                try {
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public static final class Activity {
        private final CommandSender.Data user;
        private final long time;
        private final String type;
        private final String dataType;
        private final String dataValue;

        public static Activity urlActivity(CommandSender user, long time, String type, String url) {
            return new Activity(user.toData(), time, type, "url", url);
        }

        public static Activity fileActivity(CommandSender user, long time, String type, String filePath) {
            return new Activity(user.toData(), time, type, "file", filePath);
        }

        private Activity(CommandSender.Data user, long time, String type, String dataType, String dataValue) {
            this.user = user;
            this.time = time;
            this.type = type;
            this.dataType = dataType;
            this.dataValue = dataValue;
        }

        public CommandSender.Data getUser() {
            return this.user;
        }

        public long getTime() {
            return this.time;
        }

        public String getType() {
            return this.type;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getDataValue() {
            return this.dataValue;
        }

        public boolean shouldExpire() {
            if (this.dataType.equals("url")) {
                return System.currentTimeMillis() - this.time > TimeUnit.DAYS.toMillis(7L);
            }
            return false;
        }

        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.add("user", (JsonElement)this.user.serialize());
            object.add("time", (JsonElement)new JsonPrimitive((Number)this.time));
            object.add("type", (JsonElement)new JsonPrimitive(this.type));
            JsonObject data = new JsonObject();
            data.add("type", (JsonElement)new JsonPrimitive(this.dataType));
            data.add("value", (JsonElement)new JsonPrimitive(this.dataValue));
            object.add("data", (JsonElement)data);
            return object;
        }

        public static Activity deserialize(JsonElement element) {
            JsonObject object = element.getAsJsonObject();
            CommandSender.Data user = CommandSender.Data.deserialize(object.get("user"));
            long time = object.get("time").getAsJsonPrimitive().getAsLong();
            String type = object.get("type").getAsJsonPrimitive().getAsString();
            JsonObject dataObject = object.get("data").getAsJsonObject();
            String dataType = dataObject.get("type").getAsJsonPrimitive().getAsString();
            String dataValue = dataObject.get("value").getAsJsonPrimitive().getAsString();
            return new Activity(user, time, type, dataType, dataValue);
        }
    }
}

